/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAbi;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesConventionUtilKt {
    @Nullable
    public static final Name propertyNameByGetMethodName(@NotNull Name methodName) {
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Name name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "get", false, null, 12);
        if (name == null) {
            name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "is", false, null, 8);
        }
        return name;
    }

    @Nullable
    public static final Name propertyNameBySetMethodName(@NotNull Name methodName, boolean withIsPrefix) {
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "set", false, withIsPrefix ? "is" : (String)null, 4);
    }

    @NotNull
    public static final List<Name> propertyNamesBySetMethodName(@NotNull Name methodName) {
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        return kotlin.collections.CollectionsKt.filterNotNull((Iterable)kotlin.collections.CollectionsKt.listOf((Object[])new Name[]{PropertiesConventionUtilKt.propertyNameBySetMethodName(methodName, false), PropertiesConventionUtilKt.propertyNameBySetMethodName(methodName, true)}));
    }

    private static final Name propertyNameFromAccessorMethodName(Name methodName, String prefix, boolean removePrefix, String addPrefix) {
        if (methodName.isSpecial()) {
            return null;
        }
        String identifier = methodName.getIdentifier();
        if (!StringsKt.startsWith$default((String)identifier, (String)prefix, (boolean)false, (int)2)) {
            return null;
        }
        if (kotlin.collections.CollectionsKt.length((CharSequence)identifier) == kotlin.collections.CollectionsKt.length((CharSequence)prefix)) {
            return null;
        }
        char c = identifier.charAt(kotlin.collections.CollectionsKt.length((CharSequence)prefix));
        boolean bl = true;
        if (c < 'a') {
            bl = false;
        }
        boolean bl2 = true;
        if (c > 'z') {
            bl2 = false;
        }
        if (bl & bl2) {
            return null;
        }
        if (addPrefix != null) {
            PreconditionsKt.assert((boolean)removePrefix);
            return Name.identifier(addPrefix + StringsKt.removePrefix((String)identifier, (CharSequence)prefix));
        }
        if (!removePrefix) {
            return methodName;
        }
        String name = CapitalizeDecapitalizeKt.decapitalizeSmart(StringsKt.removePrefix((String)identifier, (CharSequence)prefix), true);
        if (!Name.isValidIdentifier(name)) {
            return null;
        }
        return Name.identifier(name);
    }

    static /* bridge */ /* synthetic */ Name propertyNameFromAccessorMethodName$default(Name name, String string, boolean bl, String string2, int n) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName(name, string, bl, string2);
    }

    @NotNull
    public static final List<Name> getPropertyNamesCandidatesByAccessorName(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String nameAsString = name.asString();
        if (JvmAbi.isGetterName(nameAsString)) {
            return CollectionsKt.singletonOrEmptyList(PropertiesConventionUtilKt.propertyNameByGetMethodName(name));
        }
        if (JvmAbi.isSetterName(nameAsString)) {
            return PropertiesConventionUtilKt.propertyNamesBySetMethodName(name);
        }
        return BuiltinSpecialProperties.INSTANCE.getPropertyNameCandidatesBySpecialGetterName(name);
    }
}

