/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.structure.reflect;

import java.lang.reflect.Array;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class ReflectClassUtilKt {
    @NotNull
    public static final ClassLoader getSafeClassLoader(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        ClassLoader classLoader = $receiver.getClassLoader();
        if (classLoader == null) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ClassLoader.getSystemClassLoader()");
        }
        return classLoader;
    }

    public static final boolean isEnumClassOrSpecializedEnumEntryClass(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Enum.class.isAssignableFrom($receiver);
    }

    @NotNull
    public static final ClassId getClassId(Class<?> $receiver) {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if ($receiver.isPrimitive()) {
            throw (Throwable)new IllegalArgumentException("Can't compute ClassId for primitive type: " + $receiver);
        }
        if ($receiver.isArray()) {
            throw (Throwable)new IllegalArgumentException("Can't compute ClassId for array type: " + $receiver);
        }
        if ($receiver.getEnclosingMethod() != null || $receiver.getEnclosingConstructor() != null || StringsKt.isEmpty((CharSequence)$receiver.getSimpleName())) {
            FqName fqName2 = new FqName($receiver.getName());
            clazz = new ClassId(fqName2.parent(), FqName.topLevel(fqName2.shortName()), true);
        } else {
            clazz = $receiver.getDeclaringClass();
            if (clazz == null || (clazz = ReflectClassUtilKt.getClassId(clazz)) == null || (clazz = ((ClassId)((Object)clazz)).createNestedClassId(Name.identifier($receiver.getSimpleName()))) == null) {
                ClassId classId = ClassId.topLevel(new FqName($receiver.getName()));
                clazz = classId;
                Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"ClassId.topLevel(FqName(getName()))");
            }
        }
        return clazz;
    }

    @NotNull
    public static final String getDesc(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (Intrinsics.areEqual($receiver, Void.TYPE)) {
            return "V";
        }
        return StringsKt.replace$default((String)StringsKt.substring((String)ReflectClassUtilKt.createArrayType($receiver).getName(), (int)1), (char)'.', (char)'/', (boolean)false, (int)4);
    }

    @NotNull
    public static final Class<?> createArrayType(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Array.newInstance($receiver, 0).getClass();
    }
}

