/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawSubstitution;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeTag;
import kotlin.reflect.jvm.internal.impl.renderer.CustomFlexibleRendering;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.types.CustomSubstitutionCapability;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RawTypeCapabilities
implements TypeCapabilities {
    public static final RawTypeCapabilities INSTANCE;
    public static final RawTypeCapabilities INSTANCE$;

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        TypeCapability typeCapability;
        Intrinsics.checkParameterIsNotNull(capabilityClass, (String)"capabilityClass");
        Class<T> clazz = capabilityClass;
        if (Intrinsics.areEqual(clazz, CustomSubstitutionCapability.class)) {
            RawSubstitutionCapability rawSubstitutionCapability = RawSubstitutionCapability.INSTANCE;
            if (rawSubstitutionCapability == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawSubstitutionCapability;
        } else if (Intrinsics.areEqual(clazz, CustomFlexibleRendering.class)) {
            RawFlexibleRendering rawFlexibleRendering = RawFlexibleRendering.INSTANCE;
            if (rawFlexibleRendering == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawFlexibleRendering;
        } else if (Intrinsics.areEqual(clazz, RawTypeTag.class)) {
            RawTypeTag rawTypeTag = RawTypeTag.INSTANCE;
            if (rawTypeTag == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawTypeTag;
        } else {
            typeCapability = null;
        }
        return (T)typeCapability;
    }

    private RawTypeCapabilities() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new RawTypeCapabilities();
    }

    private static final class RawSubstitutionCapability
    implements CustomSubstitutionCapability {
        @NotNull
        public static final RawSubstitution substitution;
        public static final RawSubstitutionCapability INSTANCE;
        public static final RawSubstitutionCapability INSTANCE$;

        @Override
        @NotNull
        public RawSubstitution getSubstitution() {
            return substitution;
        }

        private RawSubstitutionCapability() {
            INSTANCE = this;
            INSTANCE$ = this;
            substitution = RawSubstitution.INSTANCE;
        }

        static {
            new RawSubstitutionCapability();
        }
    }

    private static final class RawFlexibleRendering
    implements CustomFlexibleRendering {
        public static final RawFlexibleRendering INSTANCE;
        public static final RawFlexibleRendering INSTANCE$;

        /*
         * WARNING - void declaration
         */
        private final List<String> renderArguments(DescriptorRenderer $receiver, KotlinType jetType) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = jetType.getArguments();
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                void var9_9 = destination$iv$iv;
                void v0 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
                String string = $receiver.renderTypeProjection((TypeProjection)v0);
                var9_9.add(string);
            }
            return (List)destination$iv$iv;
        }

        private final String replaceArgs(String $receiver, String newArgs) {
            if (!StringsKt.contains$default((CharSequence)$receiver, (char)'<', (boolean)false, (int)2)) {
                return $receiver;
            }
            return StringsKt.substringBefore$default((String)$receiver, (char)'<', null, (int)2) + "<" + newArgs + ">" + StringsKt.substringAfterLast$default((String)$receiver, (char)'>', null, (int)2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public String renderInflexible(@NotNull KotlinType type2, @NotNull DescriptorRenderer renderer) {
            void var3_3;
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
            if (CollectionsKt.isNotEmpty((Collection)type2.getArguments())) {
                return null;
            }
            StringBuilder $receiver$iv$iv = new StringBuilder();
            StringBuilder $receiver = $receiver$iv$iv;
            TypeConstructor typeConstructor2 = type2.getConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"type.constructor");
            $receiver.append(renderer.renderTypeConstructor(typeConstructor2));
            $receiver.append("(raw)");
            if (type2.isMarkedNullable()) {
                $receiver.append('?');
            }
            return ((StringBuilder)var3_3).toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Pair<String, String> renderBounds(@NotNull Flexibility flexibility, @NotNull DescriptorRenderer renderer) {
            boolean bl;
            String newArgs;
            String upperRendered;
            String lowerRendered;
            block3: {
                void $receiver$iv;
                void destination$iv$iv;
                Iterable $receiver$iv$iv;
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)flexibility, (String)"flexibility");
                Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
                List<String> lowerArgs = this.renderArguments(renderer, flexibility.getLowerBound());
                List<String> upperArgs = this.renderArguments(renderer, flexibility.getUpperBound());
                lowerRendered = renderer.renderType(flexibility.getLowerBound());
                upperRendered = renderer.renderType(flexibility.getUpperBound());
                if (!CollectionsKt.isNotEmpty((Collection)upperArgs)) {
                    return null;
                }
                Iterable iterable = lowerArgs;
                void var8_8 = $receiver$iv2;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    void var13_13 = destination$iv$iv;
                    String string2 = "(raw) " + (String)it;
                    var13_13.add(string2);
                }
                newArgs = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62);
                $receiver$iv$iv = CollectionsKt.zip((Iterable)lowerArgs, (Iterable)upperArgs);
                for (Object element$iv : $receiver$iv) {
                    Pair it = (Pair)element$iv;
                    if (INSTANCE.onlyOutDiffers((String)it.getFirst(), (String)it.getSecond())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            String newUpper = bl ? this.replaceArgs(upperRendered, newArgs) : upperRendered;
            return new Pair((Object)this.replaceArgs(lowerRendered, newArgs), (Object)newUpper);
        }

        private final boolean onlyOutDiffers(String first, String second) {
            return Intrinsics.areEqual((Object)first, (Object)StringsKt.removePrefix((String)second, (CharSequence)"out ")) || Intrinsics.areEqual((Object)second, (Object)"*");
        }

        private RawFlexibleRendering() {
            INSTANCE = this;
            INSTANCE$ = this;
        }

        static {
            new RawFlexibleRendering();
        }
    }
}

