/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.ref.WeakReference;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.reflect.jvm.internal.KClassImpl;
import kotlin.reflect.jvm.internal.pcollections.HashPMap;
import org.jetbrains.annotations.NotNull;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"%\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u0003!\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005iI\u0003\u0002\u0001\t\b5!\u0011BA\u0005\u0002I\u0013AB!\u0005\u0003\u0005\u0001!%Q#\u0001\r\u00033\u0019AQ!\u0004\u0003\n\u0005%\tA\u0015\u0002M\u0006)\u000e\u0019\u0011#\u0007\u0003B9!\u0001Q2E\u0005\u0007\u0013\u0015\u0001\u001a!\u0006\u0002\r\u0002a\t\u0001$A\u0005\u0007\u0013\u0015\u0001\u001a!\u0006\u0002\r\u0002a\u0011\u0001D\u0001M\u0001#\u000e\tAQA)\u0004\u0003\u0015\u0001AkA\u0002"}, strings={"K_CLASS_CACHE", "Lkotlin/reflect/jvm/internal/pcollections/HashPMap;", "", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/annotations/NotNull;", "KClassCacheKt", "getOrCreateKotlinClass", "Lkotlin/reflect/jvm/internal/KClassImpl;", "T", "jClass", "Ljava/lang/Class;"}, moduleName="kotlin-reflection")
public final class KClassCacheKt {
    private static HashPMap<String, Object> K_CLASS_CACHE = HashPMap.empty();

    @NotNull
    public static final <T> KClassImpl<T> getOrCreateKotlinClass(@NotNull Class<T> jClass) {
        Intrinsics.checkParameterIsNotNull(jClass, (String)"jClass");
        String name = jClass.getName();
        Object cached = K_CLASS_CACHE.get(name);
        if (cached instanceof WeakReference) {
            KClassImpl kClass2;
            KClassImpl kClassImpl = kClass2 = (KClassImpl)((WeakReference)cached).get();
            if (Intrinsics.areEqual(kClassImpl != null ? kClassImpl.getJClass() : null, jClass)) {
                KClassImpl kClassImpl2 = kClass2;
                if (kClassImpl2 == null) {
                    Intrinsics.throwNpe();
                }
                return kClassImpl2;
            }
        } else if (cached != null) {
            Object object = cached;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<java.lang.ref.WeakReference<kotlin.reflect.jvm.internal.KClassImpl<T>>>");
            }
            WeakReference[] cfr_ignored_0 = (WeakReference[])object;
            WeakReference[] weakReferenceArray = (WeakReference[])cached;
            for (int i = 0; i < weakReferenceArray.length; ++i) {
                KClassImpl kClass3;
                WeakReference ref = weakReferenceArray[i];
                KClassImpl kClassImpl = kClass3 = (KClassImpl)ref.get();
                if (!Intrinsics.areEqual(kClassImpl != null ? kClassImpl.getJClass() : null, jClass)) continue;
                KClassImpl kClassImpl3 = kClass3;
                Intrinsics.checkExpressionValueIsNotNull((Object)kClassImpl3, (String)"kClass");
                return kClassImpl3;
            }
            int size = ((Object[])cached).length;
            WeakReference[] newArray = new WeakReference[size + 1];
            System.arraycopy(cached, 0, newArray, 0, size);
            KClassImpl<T> newKClass = new KClassImpl<T>(jClass);
            newArray[size] = new WeakReference<KClassImpl<T>>(newKClass);
            K_CLASS_CACHE = K_CLASS_CACHE.plus(name, newArray);
            return newKClass;
        }
        KClassImpl<T> newKClass = new KClassImpl<T>(jClass);
        K_CLASS_CACHE = K_CLASS_CACHE.plus(name, new WeakReference<KClassImpl<T>>(newKClass));
        return newKClass;
    }
}

