/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.List;
import kotlin.CharIterator;
import kotlin.CharsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.KeywordStringsGenerated;
import org.jetbrains.annotations.NotNull;

public final class RenderingUtilsKt {
    @NotNull
    public static final String qualifiedNameForSourceCode(@NotNull ClassifierDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        String nameString = RenderingUtilsKt.render(descriptor2.getName());
        if (descriptor2 instanceof TypeParameterDescriptor) {
            return nameString;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.getContainingDeclaration()");
        String qualifier = RenderingUtilsKt.qualifierName(declarationDescriptor);
        return qualifier != null && Intrinsics.areEqual((Object)qualifier, (Object)"") ^ true ? qualifier + "." + nameString : nameString;
    }

    private static final String qualifierName(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor = descriptor2;
        return declarationDescriptor instanceof ClassDescriptor ? RenderingUtilsKt.qualifiedNameForSourceCode((ClassifierDescriptor)descriptor2) : (declarationDescriptor instanceof PackageFragmentDescriptor ? RenderingUtilsKt.render(((PackageFragmentDescriptor)descriptor2).getFqName().toUnsafe()) : (String)null);
    }

    @NotNull
    public static final String render(Name $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (RenderingUtilsKt.shouldBeEscaped($receiver)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = $receiver.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"asString()");
            string = stringBuilder.append(CharsKt.plus((char)'`', (String)string2)).append('`').toString();
        } else {
            String string3 = $receiver.asString();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"asString()");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(Name $receiver) {
        boolean bl;
        if ($receiver.isSpecial()) {
            return false;
        }
        String string = $receiver.asString();
        if (KeywordStringsGenerated.KEYWORDS.contains(string)) return true;
        CharSequence $receiver2 = string;
        CharIterator charIterator = StringsKt.iterator((CharSequence)$receiver2);
        do {
            if (!charIterator.hasNext()) return false;
            char element = charIterator.nextChar();
            char it = element;
            if (!Character.isLetterOrDigit(it) && it != '_') {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final String render(FqNameUnsafe $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<Name> list = $receiver.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"pathSegments()");
        return RenderingUtilsKt.renderFqName(list);
    }

    @NotNull
    public static final String render(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<Name> list = $receiver.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"pathSegments()");
        return RenderingUtilsKt.renderFqName(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderFqName(@NotNull List<? extends Name> pathSegments) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull(pathSegments, (String)"pathSegments");
        StringBuilder $receiver = new StringBuilder();
        StringBuilder $receiver2 = $receiver;
        for (Name name : pathSegments) {
            if ($receiver2.length() > 0) {
                $receiver2.append(".");
            }
            $receiver2.append(RenderingUtilsKt.render(name));
        }
        String string = ((StringBuilder)var1_1).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

