/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.NullValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstantValueFactory {
    private final KotlinBuiltIns builtins;

    @NotNull
    public final LongValue createLongValue(long value2) {
        return new LongValue(value2, this.builtins);
    }

    @NotNull
    public final IntValue createIntValue(int value2) {
        return new IntValue(value2, this.builtins);
    }

    @NotNull
    public final ErrorValue createErrorValue(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return ErrorValue.Companion.create(message);
    }

    @NotNull
    public final ShortValue createShortValue(short value2) {
        return new ShortValue(value2, this.builtins);
    }

    @NotNull
    public final ByteValue createByteValue(byte value2) {
        return new ByteValue(value2, this.builtins);
    }

    @NotNull
    public final DoubleValue createDoubleValue(double value2) {
        return new DoubleValue(value2, this.builtins);
    }

    @NotNull
    public final FloatValue createFloatValue(float value2) {
        return new FloatValue(value2, this.builtins);
    }

    @NotNull
    public final BooleanValue createBooleanValue(boolean value2) {
        return new BooleanValue(value2, this.builtins);
    }

    @NotNull
    public final CharValue createCharValue(char value2) {
        return new CharValue(value2, this.builtins);
    }

    @NotNull
    public final StringValue createStringValue(@NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return new StringValue(value2, this.builtins);
    }

    @NotNull
    public final NullValue createNullValue() {
        return new NullValue(this.builtins);
    }

    @NotNull
    public final EnumValue createEnumValue(@NotNull ClassDescriptor enumEntryClass) {
        Intrinsics.checkParameterIsNotNull((Object)enumEntryClass, (String)"enumEntryClass");
        return new EnumValue(enumEntryClass);
    }

    @NotNull
    public final ArrayValue createArrayValue(@NotNull List<? extends ConstantValue<?>> value2, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return new ArrayValue(value2, type2, this.builtins);
    }

    @NotNull
    public final AnnotationValue createAnnotationValue(@NotNull AnnotationDescriptor value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return new AnnotationValue(value2);
    }

    @NotNull
    public final KClassValue createKClassValue(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return new KClassValue(type2);
    }

    @Nullable
    public final ConstantValue<?> createConstantValue(@Nullable Object value2) {
        Object object = value2;
        return object instanceof Byte ? (ConstantValue)this.createByteValue(((Number)value2).byteValue()) : (object instanceof Short ? (ConstantValue)this.createShortValue(((Number)value2).shortValue()) : (object instanceof Integer ? (ConstantValue)this.createIntValue(((Number)value2).intValue()) : (object instanceof Long ? (ConstantValue)this.createLongValue(((Number)value2).longValue()) : (object instanceof Character ? (ConstantValue)this.createCharValue(((Character)value2).charValue()) : (object instanceof Float ? (ConstantValue)this.createFloatValue(((Number)value2).floatValue()) : (object instanceof Double ? (ConstantValue)this.createDoubleValue(((Number)value2).doubleValue()) : (object instanceof Boolean ? (ConstantValue)this.createBooleanValue((Boolean)value2) : (object instanceof String ? (ConstantValue)this.createStringValue((String)value2) : (Intrinsics.areEqual((Object)object, null) ? (ConstantValue)this.createNullValue() : (ConstantValue)null)))))))));
    }

    @Nullable
    public final ConstantValue<?> createIntegerConstantValue(long value2, @NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        KotlinType notNullExpected = TypeUtils.makeNotNullable(expectedType);
        return KotlinBuiltIns.isLong(notNullExpected) ? (IntegerValueConstant)this.createLongValue(value2) : (KotlinBuiltIns.isInt(notNullExpected) && value2 == (long)((int)value2) ? (IntegerValueConstant)this.createIntValue((int)value2) : (KotlinBuiltIns.isShort(notNullExpected) && value2 == (long)((short)value2) ? (IntegerValueConstant)this.createShortValue((short)value2) : (KotlinBuiltIns.isByte(notNullExpected) && value2 == (long)((byte)value2) ? (IntegerValueConstant)this.createByteValue((byte)value2) : (KotlinBuiltIns.isChar(notNullExpected) ? (IntegerValueConstant)this.createIntValue((int)value2) : (IntegerValueConstant)null))));
    }

    public ConstantValueFactory(@NotNull KotlinBuiltIns builtins) {
        Intrinsics.checkParameterIsNotNull((Object)builtins, (String)"builtins");
        this.builtins = builtins;
    }
}

