/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kotlin.reflect.jvm.internal.impl.incremental

import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupTracker
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation
import kotlin.reflect.jvm.internal.impl.incremental.components.ScopeKind
import kotlin.reflect.jvm.internal.impl.name.Name
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.fqNameUnsafe
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope

public fun LookupTracker.record(from: LookupLocation, scopeOwner: DeclarationDescriptor, inScope: MemberScope, name: Name) {
    if (this == LookupTracker.DO_NOTHING || from is NoLookupLocation) return

    val location = from.location ?: return

    val scopeKind =
            when (scopeOwner) {
                is ClassifierDescriptor -> ScopeKind.CLASSIFIER
                is PackageFragmentDescriptor -> ScopeKind.PACKAGE
                else -> throw AssertionError("Unexpected containing declaration type: ${scopeOwner.javaClass}")
            }

    record(location, scopeOwner.fqNameUnsafe.asString(), scopeKind, name.asString())
}
