/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.KtScope;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.AbstractKotlinType;
import kotlin.reflect.jvm.internal.impl.types.CustomSubstitutionCapability;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.IndexedParametersSubstitution;
import kotlin.reflect.jvm.internal.impl.types.LazyType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLazyType
extends AbstractKotlinType
implements LazyType {
    private final NotNullLazyValue<TypeConstructor> typeConstructor;
    private final NotNullLazyValue<List<? extends TypeProjection>> arguments;
    private final NotNullLazyValue<KtScope> memberScope;

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        return (TypeConstructor)this.typeConstructor.invoke();
    }

    @NotNull
    protected abstract TypeConstructor computeTypeConstructor();

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        return (List)this.arguments.invoke();
    }

    @NotNull
    protected abstract List<TypeProjection> computeArguments();

    @Override
    @NotNull
    public TypeSubstitution getSubstitution() {
        TypeSubstitution typeSubstitution = this.computeCustomSubstitution();
        if (typeSubstitution == null) {
            typeSubstitution = new IndexedParametersSubstitution(this.getConstructor(), this.getArguments());
        }
        return typeSubstitution;
    }

    @Nullable
    protected TypeSubstitution computeCustomSubstitution() {
        AbstractLazyType $receiver = this;
        CustomSubstitutionCapability customSubstitutionCapability = $receiver.getCapability(CustomSubstitutionCapability.class);
        return customSubstitutionCapability != null ? customSubstitutionCapability.getSubstitution() : null;
    }

    @Override
    @NotNull
    public KtScope getMemberScope() {
        return (KtScope)this.memberScope.invoke();
    }

    @NotNull
    protected KtScope computeMemberScope() {
        KtScope ktScope;
        ClassifierDescriptor descriptor2 = this.getConstructor().getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = descriptor2;
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            KtScope ktScope2 = ((TypeParameterDescriptor)descriptor2).getDefaultType().getMemberScope();
            ktScope = ktScope2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktScope2, (String)"descriptor.getDefaultType().getMemberScope()");
        } else if (classifierDescriptor instanceof ClassDescriptor) {
            KtScope ktScope3 = ((ClassDescriptor)descriptor2).getMemberScope(this.getSubstitution());
            ktScope = ktScope3;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktScope3, (String)"descriptor.getMemberScope(substitution)");
        } else {
            throw (Throwable)new IllegalStateException("Unsupported classifier: " + descriptor2);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktScope, (String)"when (descriptor) {\n    \u2026: $descriptor\")\n        }");
        return ktScope;
    }

    @Override
    public boolean isMarkedNullable() {
        return false;
    }

    @Override
    public boolean isError() {
        boolean bl;
        ClassifierDescriptor classifierDescriptor = this.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            ClassifierDescriptor $receiver = classifierDescriptor;
            ClassifierDescriptor d = $receiver;
            bl = ErrorUtils.isError(d);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return Annotations.Companion.INSTANCE.getEMPTY();
    }

    @Override
    @NotNull
    public String toString() {
        if (!this.typeConstructor.isComputed()) {
            return "Type constructor is not computed";
        }
        if (!this.arguments.isComputed()) {
            return "" + this.getConstructor() + "<arguments are not computed>";
        }
        String string = super.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"super<AbstractKotlinType>.toString()");
        return string;
    }

    public AbstractLazyType(@NotNull StorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        this.typeConstructor = storageManager.createLazyValue((Function0)new Function0<TypeConstructor>(this){
            final /* synthetic */ AbstractLazyType this$0;

            @NotNull
            public final TypeConstructor invoke() {
                return this.this$0.computeTypeConstructor();
            }
            {
                this.this$0 = abstractLazyType;
                super(0);
            }
        });
        this.arguments = storageManager.createLazyValue((Function0)new Function0<List<? extends TypeProjection>>(this){
            final /* synthetic */ AbstractLazyType this$0;

            @NotNull
            public final List<TypeProjection> invoke() {
                return this.this$0.computeArguments();
            }
            {
                this.this$0 = abstractLazyType;
                super(0);
            }
        });
        this.memberScope = storageManager.createLazyValue((Function0)new Function0<KtScope>(this){
            final /* synthetic */ AbstractLazyType this$0;

            @NotNull
            public final KtScope invoke() {
                return this.this$0.computeMemberScope();
            }
            {
                this.this$0 = abstractLazyType;
                super(0);
            }
        });
    }
}

