/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrayValue
extends ConstantValue<List<? extends ConstantValue<?>>> {
    @NotNull
    private final KotlinType type;
    private final KotlinBuiltIns builtIns;

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitArrayValue(this, data);
    }

    @NotNull
    public final KotlinType getElementType() {
        KotlinType kotlinType = this.builtIns.getArrayElementType(this.getType());
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"builtIns.getArrayElementType(type)");
        return kotlinType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.ArrayValue");
        }
        return Intrinsics.areEqual((Object)((List)this.getValue()), (Object)((List)((ArrayValue)object2).getValue()));
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    @NotNull
    public KotlinType getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayValue(@NotNull List<? extends ConstantValue<?>> value2, @NotNull KotlinType type2, @NotNull KotlinBuiltIns builtIns) {
        void value3;
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        super(value2);
        this.type = type2;
        this.builtIns = builtIns;
        boolean bl = KotlinBuiltIns.isArray(this.getType()) || KotlinBuiltIns.isPrimitiveArray(this.getType());
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value3 == false) {
            String message = "Type should be an array, but was " + this.getType() + ": " + value2;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
    }
}

