/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.javax.inject.Inject;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializationComponentsForJava;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ChainedScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.KtScope;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import kotlin.reflect.jvm.internal.impl.serialization.PackageData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ErrorReporter;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeserializedDescriptorResolver {
    private final ErrorReporter errorReporter;
    private DeserializationComponents components;
    public static final Set<KotlinClassHeader.Kind> KOTLIN_CLASS = SetsKt.setOf((Object)((Object)KotlinClassHeader.Kind.CLASS));
    public static final Set<KotlinClassHeader.Kind> KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART = SetsKt.setOf((Object[])new KotlinClassHeader.Kind[]{KotlinClassHeader.Kind.FILE_FACADE, KotlinClassHeader.Kind.MULTIFILE_CLASS_PART});
    public static final Set<KotlinClassHeader.Kind> KOTLIN_PACKAGE_FACADE = SetsKt.setOf((Object)((Object)KotlinClassHeader.Kind.PACKAGE_FACADE));

    public DeserializedDescriptorResolver(@NotNull ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "<init>"));
        }
        this.errorReporter = errorReporter;
    }

    @Inject
    public void setComponents(@NotNull DeserializationComponentsForJava context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "setComponents"));
        }
        this.components = context.getComponents();
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "resolveClass"));
        }
        String[] data = this.readData(kotlinClass, KOTLIN_CLASS);
        if (data != null) {
            String[] strings = kotlinClass.getClassHeader().getStrings();
            assert (strings != null) : "String table not found in " + kotlinClass;
            ClassData classData = JvmProtoBufUtil.readClassDataFrom(data, strings);
            KotlinJvmBinarySourceElement sourceElement = new KotlinJvmBinarySourceElement(kotlinClass);
            return this.components.getClassDeserializer().deserializeClass(kotlinClass.getClassId(), new ClassDataWithSource(classData, sourceElement));
        }
        return null;
    }

    @Nullable
    public KtScope createKotlinPackagePartScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull KotlinJvmBinaryClass kotlinClass) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackagePartScope"));
        }
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackagePartScope"));
        }
        String[] data = this.readData(kotlinClass, KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART);
        if (data != null) {
            String[] strings = kotlinClass.getClassHeader().getStrings();
            assert (strings != null) : "String table not found in " + kotlinClass;
            PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(data, strings);
            return new DeserializedPackageMemberScope(descriptor2, packageData.getPackageProto(), packageData.getNameResolver(), this.components, (Function0<? extends Collection<? extends Name>>)new Function0<Collection<Name>>(){

                public Collection<Name> invoke() {
                    return Collections.emptyList();
                }
            });
        }
        return null;
    }

    @NotNull
    public KtScope createKotlinPackageScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull List<KotlinJvmBinaryClass> packageParts) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        if (packageParts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageParts", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        ArrayList<KtScope> list = new ArrayList<KtScope>();
        for (KotlinJvmBinaryClass callable : packageParts) {
            KtScope scope2 = this.createKotlinPackagePartScope(descriptor2, callable);
            if (scope2 == null) continue;
            list.add(scope2);
        }
        if (list.isEmpty()) {
            KtScope.Empty empty = KtScope.Empty.INSTANCE$;
            if (empty == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
            }
            return empty;
        }
        ChainedScope chainedScope = new ChainedScope(descriptor2, "Member scope for union of package parts data", list.toArray(new KtScope[list.size()]));
        if (chainedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        return chainedScope;
    }

    @Nullable
    public String[] readData(@NotNull KotlinJvmBinaryClass kotlinClass, @NotNull Set<KotlinClassHeader.Kind> expectedKinds) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        if (expectedKinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedKinds", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (!header.isCompatibleAbiVersion()) {
            this.errorReporter.reportIncompatibleAbiVersion(kotlinClass.getClassId(), kotlinClass.getLocation(), header.getVersion());
        } else if (expectedKinds.contains((Object)header.getKind())) {
            return header.getAnnotationData();
        }
        return null;
    }
}

