/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.Collection;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexedParametersSubstitution
extends TypeSubstitution {
    public static final /* synthetic */ KClass $kotlinClass;
    private final TypeParameterDescriptor[] parameters;
    private final TypeProjection[] arguments;

    static {
        $kotlinClass = Reflection.createKotlinClass(IndexedParametersSubstitution.class);
    }

    @Override
    public boolean isEmpty() {
        return ArraysKt.isEmpty((Object[])this.arguments);
    }

    @Override
    @Nullable
    public TypeProjection get(@NotNull JetType key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        ClassifierDescriptor classifierDescriptor = key.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
            classifierDescriptor = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
        if (typeParameterDescriptor == null) {
            return null;
        }
        TypeParameterDescriptor parameter = typeParameterDescriptor;
        int index = parameter.getIndex();
        if (index < ((Object[])this.parameters).length && Intrinsics.areEqual((Object)this.parameters[index].getTypeConstructor(), (Object)parameter.getTypeConstructor())) {
            return this.arguments[index];
        }
        return null;
    }

    public IndexedParametersSubstitution(@NotNull TypeParameterDescriptor[] parameters2, @NotNull TypeProjection[] arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        this.parameters = parameters2;
        this.arguments = arguments2;
        boolean value = ((Object[])this.parameters).length <= ((Object[])this.arguments).length;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
            String message = "Number of arguments should not be less then number of parameters, but: parameters=" + ((Object[])this.parameters).length + ", args=" + ((Object[])this.arguments).length;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
    }

    public IndexedParametersSubstitution(@NotNull TypeConstructor typeConstructor2, @NotNull List<? extends TypeProjection> argumentsList) {
        Intrinsics.checkParameterIsNotNull((Object)typeConstructor2, (String)"typeConstructor");
        Intrinsics.checkParameterIsNotNull(argumentsList, (String)"argumentsList");
        List<TypeParameterDescriptor> list = typeConstructor2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"typeConstructor.parameters");
        this(list, argumentsList);
    }

    public IndexedParametersSubstitution(@NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull List<? extends TypeProjection> argumentsList) {
        Collection $receiver;
        Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(argumentsList, (String)"argumentsList");
        Collection collection = parameters2;
        IndexedParametersSubstitution indexedParametersSubstitution = this;
        void v0 = $receiver;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection = (Collection)v0;
        TypeParameterDescriptor[] typeParameterDescriptorArray = thisCollection.toArray(new TypeParameterDescriptor[thisCollection.size()]);
        if (typeParameterDescriptorArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = typeParameterDescriptorArray;
        $receiver = argumentsList;
        objectArray = (TypeParameterDescriptor[])objectArray;
        Collection collection2 = $receiver;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        thisCollection = collection2;
        TypeProjection[] typeProjectionArray = thisCollection.toArray(new TypeProjection[thisCollection.size()]);
        if (typeProjectionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray2 = typeProjectionArray;
        indexedParametersSubstitution((TypeParameterDescriptor[])objectArray, (TypeProjection[])objectArray2);
    }
}

