/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.HashSet;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.types.DelegatingType;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.Flexibility$$TImpl;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeDelegation;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.NullAwareness;
import kotlin.reflect.jvm.internal.impl.types.SubtypingRepresentatives;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.checker.JetTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegatingFlexibleType
extends DelegatingType
implements NullAwareness,
Flexibility,
FlexibleTypeDelegation {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final HashSet<Class<? extends TypeCapability>> capabilityClasses;
    @NotNull
    private final JetType delegateType;
    @NotNull
    private final JetType lowerBound;
    @NotNull
    private final JetType upperBound;
    @NotNull
    private final FlexibleTypeCapabilities extraCapabilities;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(DelegatingFlexibleType.class);
        Companion companion = Companion = new Companion(null);
        capabilityClasses = SetsKt.hashSetOf((Object[])new Class[]{NullAwareness.class, Flexibility.class, SubtypingRepresentatives.class, FlexibleTypeDelegation.class});
    }

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        Intrinsics.checkParameterIsNotNull(capabilityClass, (String)"capabilityClass");
        T extra = this.getExtraCapabilities().getCapability(capabilityClass, this, this);
        if (extra != null) {
            return extra;
        }
        if (Companion.getCapabilityClasses().contains(capabilityClass)) {
            DelegatingFlexibleType delegatingFlexibleType = this;
            if (delegatingFlexibleType == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)delegatingFlexibleType;
        }
        return super.getCapability(capabilityClass);
    }

    @Override
    @NotNull
    public JetType makeNullableAsSpecified(boolean nullable2) {
        JetType jetType = TypeUtils.makeNullableAsSpecified(this.getLowerBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"TypeUtils.makeNullableAs\u2026ied(lowerBound, nullable)");
        JetType jetType2 = TypeUtils.makeNullableAsSpecified(this.getUpperBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType2, (String)"TypeUtils.makeNullableAs\u2026ied(upperBound, nullable)");
        return Companion.create(jetType, jetType2, this.getExtraCapabilities());
    }

    @Override
    public boolean computeIsNullable() {
        return this.getDelegateType().isMarkedNullable();
    }

    @Override
    public boolean isMarkedNullable() {
        NullAwareness nullAwareness = this.getCapability(NullAwareness.class);
        if (nullAwareness == null) {
            Intrinsics.throwNpe();
        }
        return nullAwareness.computeIsNullable();
    }

    @Override
    @NotNull
    public JetType getDelegateType() {
        return this.delegateType;
    }

    @Override
    @NotNull
    protected JetType getDelegate() {
        FlexibleTypeDelegation flexibleTypeDelegation = this.getCapability(FlexibleTypeDelegation.class);
        if (flexibleTypeDelegation == null) {
            Intrinsics.throwNpe();
        }
        return flexibleTypeDelegation.getDelegateType();
    }

    @Override
    @NotNull
    public String toString() {
        return "('" + this.getLowerBound() + "'..'" + this.getUpperBound() + "')";
    }

    @Override
    @NotNull
    public JetType getLowerBound() {
        return this.lowerBound;
    }

    @Override
    @NotNull
    public JetType getUpperBound() {
        return this.upperBound;
    }

    @Override
    @NotNull
    public FlexibleTypeCapabilities getExtraCapabilities() {
        return this.extraCapabilities;
    }

    protected DelegatingFlexibleType(@NotNull JetType lowerBound, @NotNull JetType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        Intrinsics.checkParameterIsNotNull((Object)extraCapabilities, (String)"extraCapabilities");
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.extraCapabilities = extraCapabilities;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            boolean value;
            boolean bl = !FlexibleTypesKt.isFlexible(this.getLowerBound());
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
                String message = "Lower bound of a flexible type can not be flexible: " + this.getLowerBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            value = !FlexibleTypesKt.isFlexible(this.getUpperBound());
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
                String message = "Upper bound of a flexible type can not be flexible: " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            value = Intrinsics.areEqual((Object)this.getLowerBound(), (Object)this.getUpperBound()) ^ true;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
                String message = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            value = JetTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
                String message = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
        }
        this.delegateType = this.getLowerBound();
    }

    @Override
    @NotNull
    public JetType getSubTypeRepresentative() {
        return Flexibility$$TImpl.getSubTypeRepresentative(this);
    }

    @Override
    @NotNull
    public JetType getSuperTypeRepresentative() {
        return Flexibility$$TImpl.getSuperTypeRepresentative(this);
    }

    @Override
    public boolean sameTypeConstructor(@NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return Flexibility$$TImpl.sameTypeConstructor(this, type2);
    }

    @JvmStatic
    @NotNull
    public static final JetType create(@NotNull JetType lowerBound, @NotNull JetType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        Intrinsics.checkParameterIsNotNull((Object)extraCapabilities, (String)"extraCapabilities");
        return Companion.create(lowerBound, upperBound, extraCapabilities);
    }

    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final HashSet<Class<? extends TypeCapability>> getCapabilityClasses() {
            return capabilityClasses;
        }

        @JvmStatic
        @NotNull
        public final JetType create(@NotNull JetType lowerBound, @NotNull JetType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
            Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
            Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
            Intrinsics.checkParameterIsNotNull((Object)extraCapabilities, (String)"extraCapabilities");
            if (Intrinsics.areEqual((Object)lowerBound, (Object)upperBound)) {
                return lowerBound;
            }
            return new DelegatingFlexibleType(lowerBound, upperBound, extraCapabilities);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

