/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.ComparisonsKt;
import kotlin.IndexedValue;
import kotlin.MapsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ScriptDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationWithTarget;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameBase;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.CustomFlexibleRendering;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$$TImpl;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$WhenMappings;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$renderAnnotations$;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererModifier;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptionsImpl;
import kotlin.reflect.jvm.internal.impl.renderer.NameShortness;
import kotlin.reflect.jvm.internal.impl.renderer.OverrideRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ParameterNameRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingFormat;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.LazyType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.MissingDependencyErrorClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorRendererImpl
implements DescriptorRenderer,
DescriptorRendererOptions {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final DescriptorRendererOptionsImpl options;

    static {
        $kotlinClass = Reflection.createKotlinClass(DescriptorRendererImpl.class);
    }

    private final String renderKeyword(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return "<b>" + keyword + "</b>";
            }
        }
        return null;
    }

    private final String renderError(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$1[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return "<font color=red><b>" + keyword + "</b></font>";
            }
        }
        return null;
    }

    private final String escape(String string) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$2[this.getTextFormat().ordinal()]) {
            case 1: {
                return string;
            }
            case 2: {
                return StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"<", (String)"&lt;", (boolean)false, (int)4), (String)">", (String)"&gt;", (boolean)false, (int)4);
            }
        }
        return null;
    }

    private final String lt() {
        return this.escape("<");
    }

    private final String gt() {
        return this.escape(">");
    }

    private final String arrow() {
        String string;
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$3[this.getTextFormat().ordinal()]) {
            case 1: {
                string = this.escape("->");
                break;
            }
            case 2: {
                string = "&rarr;";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String renderMessage(String message) {
        String string;
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$4[this.getTextFormat().ordinal()]) {
            case 1: {
                string = message;
                break;
            }
            case 2: {
                string = "<i>" + message + "</i>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String renderName(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.escape(RenderingUtilsKt.render(name));
    }

    private final void renderName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.getName()");
        builder.append(this.renderName(name));
    }

    private final void renderCompanionObjectName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (this.getRenderCompanionObjectName()) {
            if (this.getStartFromName()) {
                builder.append("companion object");
            }
            this.renderSpaceIfNeeded(builder);
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration != null) {
                builder.append("of ");
                Name name = containingDeclaration.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"containingDeclaration.getName()");
                builder.append(this.renderName(name));
            }
        }
        if (this.getVerbose()) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            Name name = descriptor2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.getName()");
            builder.append(this.renderName(name));
        }
    }

    @Override
    @NotNull
    public String renderFqName(@NotNull FqNameBase fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        List<Name> list = fqName2.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"fqName.pathSegments()");
        return this.renderFqName(list);
    }

    private final String renderFqName(List<? extends Name> pathSegments) {
        return this.escape(RenderingUtilsKt.renderFqName(pathSegments));
    }

    @Override
    @NotNull
    public String renderClassifierName(@NotNull ClassifierDescriptor klass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        if (klass instanceof MissingDependencyErrorClass) {
            String string = ((MissingDependencyErrorClass)((Object)klass)).getFullFqName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"klass.fullFqName.asString()");
            return string;
        }
        if (ErrorUtils.isError(klass)) {
            return klass.getTypeConstructor().toString();
        }
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$5[this.getNameShortness().ordinal()]) {
            case 1: {
                ArrayList<Name> qualifiedNameElements = new ArrayList<Name>();
                DeclarationDescriptor current = klass;
                do {
                    DeclarationDescriptor declarationDescriptor = current;
                    if (declarationDescriptor == null) {
                        Intrinsics.throwNpe();
                    }
                    qualifiedNameElements.add(declarationDescriptor.getName());
                } while ((current = current.getContainingDeclaration()) instanceof ClassDescriptor);
                return this.renderFqName(CollectionsKt.reverse((Iterable)qualifiedNameElements));
            }
            case 2: {
                FqNameBase fqNameBase = DescriptorUtils.getFqName(klass);
                Intrinsics.checkExpressionValueIsNotNull((Object)fqNameBase, (String)"DescriptorUtils.getFqName(klass)");
                return this.renderFqName(fqNameBase);
            }
            case 3: {
                return RenderingUtilsKt.qualifiedNameForSourceCode(klass);
            }
        }
        throw (Throwable)new IllegalArgumentException();
    }

    @Override
    @NotNull
    public String renderType(@NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return this.renderNormalizedType((JetType)this.getTypeNormalizer().invoke((Object)type2));
    }

    private final String renderNormalizedType(JetType type2) {
        if (type2 instanceof LazyType && this.getDebugMode()) {
            return type2.toString();
        }
        if (DynamicTypesKt.isDynamic(type2)) {
            return "dynamic";
        }
        if (FlexibleTypesKt.isFlexible(type2)) {
            if (this.getDebugMode()) {
                return this.renderFlexibleTypeWithBothBounds(FlexibleTypesKt.flexibility(type2).getLowerBound(), FlexibleTypesKt.flexibility(type2).getUpperBound());
            }
            if (this.getFlexibleTypesForCode()) {
                String prefix = Intrinsics.areEqual((Object)((Object)this.getNameShortness()), (Object)((Object)NameShortness.SHORT)) ? "" : Flexibility.Companion.getFLEXIBLE_TYPE_CLASSIFIER().getPackageFqName().asString() + ".";
                return prefix + Flexibility.Companion.getFLEXIBLE_TYPE_CLASSIFIER().getRelativeClassName() + this.lt() + this.renderNormalizedType(FlexibleTypesKt.flexibility(type2).getLowerBound()) + ", " + this.renderNormalizedType(FlexibleTypesKt.flexibility(type2).getUpperBound()) + this.gt();
            }
            return this.renderFlexibleType(type2);
        }
        return this.renderInflexibleType(type2);
    }

    private final String renderFlexibleTypeWithBothBounds(JetType lower, JetType upper) {
        return this.renderFlexibleTypeWithBothBounds(this.renderNormalizedType(lower), this.renderNormalizedType(upper));
    }

    private final String renderFlexibleTypeWithBothBounds(String lower, String upper) {
        return "(" + lower + ".." + upper + ")";
    }

    private final String renderInflexibleType(JetType type2) {
        String customResult;
        boolean value = !FlexibleTypesKt.isFlexible(type2);
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
            String message = "Flexible types not allowed here: " + this.renderNormalizedType(type2);
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        JetType $receiver = type2;
        CustomFlexibleRendering customFlexibleRendering = $receiver.getCapability(CustomFlexibleRendering.class);
        String string = customResult = customFlexibleRendering != null ? customFlexibleRendering.renderInflexible(type2, this) : null;
        if (customResult != null) {
            return customResult;
        }
        if (Intrinsics.areEqual((Object)type2, (Object)TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE) || TypeUtils.isDontCarePlaceholder(type2)) {
            return "???";
        }
        if (ErrorUtils.isUninferredParameter(type2)) {
            if (this.getUninferredTypeParameterAsName()) {
                TypeConstructor typeConstructor2 = type2.getConstructor();
                if (typeConstructor2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.ErrorUtils.UninferredParameterTypeConstructor");
                }
                String string2 = ((ErrorUtils.UninferredParameterTypeConstructor)typeConstructor2).getTypeParameterDescriptor().getName().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(type.getConstructor() a\u2026or().getName().toString()");
                return this.renderError(string2);
            }
            return "???";
        }
        if (type2.isError()) {
            return this.renderDefaultType(type2);
        }
        if (this.shouldRenderAsPrettyFunctionType(type2)) {
            return this.renderFunctionType(type2);
        }
        return this.renderDefaultType(type2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderAsPrettyFunctionType(JetType type2) {
        Object element;
        TypeProjection it;
        if (!this.getPrettyFunctionTypes()) return false;
        if (!KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(type2)) return false;
        Iterable $receiver = type2.getArguments();
        Iterator iterator2 = $receiver.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (!(it = (TypeProjection)(element = iterator2.next())).isStarProjection());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final String renderFlexibleType(JetType type2) {
        void upperRendered;
        void lowerRendered;
        void $receiver;
        JetType lower = FlexibleTypesKt.flexibility(type2).getLowerBound();
        JetType upper = FlexibleTypesKt.flexibility(type2).getUpperBound();
        JetType jetType = type2;
        Pair<String, String> pair = $receiver.getCapability(CustomFlexibleRendering.class);
        if (pair == null || (pair = pair.renderBounds(FlexibleTypesKt.flexibility(type2), (DescriptorRenderer)this)) == null) {
            pair = new Pair((Object)this.renderInflexibleType(lower), (Object)this.renderInflexibleType(upper));
        }
        Pair<String, String> pair2 = pair;
        String string = (String)pair2.component1();
        String string2 = (String)pair2.component2();
        pair2 = null;
        if (this.differsOnlyInNullability((String)lowerRendered, (String)upperRendered)) {
            if (StringsKt.startsWith$default((String)upperRendered, (String)"(", (boolean)false, (int)2)) {
                return "(" + (String)lowerRendered + ")!";
            }
            return (String)lowerRendered + "!";
        }
        String kotlinPrefix = Intrinsics.areEqual((Object)((Object)this.getNameShortness()), (Object)((Object)NameShortness.SHORT)) ^ true ? "kotlin." : "";
        String mutablePrefix = "Mutable";
        String simpleCollection = this.replacePrefixes((String)lowerRendered, kotlinPrefix + mutablePrefix, (String)upperRendered, kotlinPrefix, kotlinPrefix + "(" + mutablePrefix + ")");
        if (simpleCollection != null) {
            return simpleCollection;
        }
        String mutableEntry = this.replacePrefixes((String)lowerRendered, kotlinPrefix + "MutableMap.MutableEntry", (String)upperRendered, kotlinPrefix + "Map.Entry", kotlinPrefix + "(Mutable)Map.(Mutable)Entry");
        if (mutableEntry != null) {
            return mutableEntry;
        }
        String array = this.replacePrefixes((String)lowerRendered, kotlinPrefix + this.escape("Array<"), (String)upperRendered, kotlinPrefix + this.escape("Array<out "), kotlinPrefix + this.escape("Array<(out) "));
        if (array != null) {
            return array;
        }
        return this.renderFlexibleTypeWithBothBounds((String)lowerRendered, (String)upperRendered);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderTypeArguments(@NotNull List<? extends TypeProjection> typeArguments) {
        void var2_2;
        StringBuilder sb;
        Intrinsics.checkParameterIsNotNull(typeArguments, (String)"typeArguments");
        if (typeArguments.isEmpty()) {
            return "";
        }
        StringBuilder $receiver = sb = new StringBuilder();
        $receiver.append(this.lt());
        this.appendTypeProjections(typeArguments, $receiver);
        $receiver.append(this.gt());
        String string = var2_2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder {\n        \u2026t())\n        }.toString()");
        return string;
    }

    private final String renderDefaultType(JetType type2) {
        StringBuilder sb = new StringBuilder();
        this.renderAnnotations(type2, sb, true);
        if (type2.isError()) {
            sb.append(type2.getConstructor().toString());
        } else {
            TypeConstructor typeConstructor2 = type2.getConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"type.getConstructor()");
            sb.append(this.renderTypeConstructor(typeConstructor2));
        }
        List<TypeProjection> list = type2.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"type.getArguments()");
        sb.append(this.renderTypeArguments(list));
        if (type2.isMarkedNullable()) {
            sb.append("?");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @Override
    @NotNull
    public String renderTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        String string;
        ClassifierDescriptor cd;
        Intrinsics.checkParameterIsNotNull((Object)typeConstructor2, (String)"typeConstructor");
        ClassifierDescriptor classifierDescriptor = cd = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            Name name = ((TypeParameterDescriptor)cd).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"cd.getName()");
            string = this.renderName(name);
        } else {
            string = classifierDescriptor instanceof ClassDescriptor ? this.renderClassifierName(cd) : (Intrinsics.areEqual((Object)classifierDescriptor, null) ? typeConstructor2.toString() : (String)((Object)PreconditionsKt.error((Object)("Unexpected classifier: " + cd.getClass()))));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderTypeProjection(@NotNull TypeProjection typeProjection) {
        void var2_2;
        StringBuilder sb;
        Intrinsics.checkParameterIsNotNull((Object)typeProjection, (String)"typeProjection");
        StringBuilder $receiver = sb = new StringBuilder();
        this.appendTypeProjections(CollectionsKt.listOf((Object)typeProjection), $receiver);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void appendTypeProjections(List<? extends TypeProjection> typeProjections, StringBuilder builder) {
        void destination;
        void $receiver;
        Iterable $receiver2 = typeProjections;
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            String string;
            void it;
            TypeProjection typeProjection = (TypeProjection)item;
            void var9_9 = destination;
            if (it.isStarProjection()) {
                string = "*";
            } else {
                JetType jetType = it.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"it.getType()");
                String type2 = this.renderType(jetType);
                string = Intrinsics.areEqual((Object)((Object)it.getProjectionKind()), (Object)((Object)Variance.INVARIANT)) ? type2 : (Object)((Object)it.getProjectionKind()) + " " + type2;
            }
            String string2 = string;
            var9_9.add(string2);
        }
        CollectionsKt.joinTo$default((Iterable)((List)destination), (Appendable)builder, (String)", ", null, null, (int)0, null, null, (int)124);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderFunctionType(JetType type2) {
        void var2_2;
        JetType receiverType;
        StringBuilder sb;
        StringBuilder $receiver = sb = new StringBuilder();
        boolean isNullable = type2.isMarkedNullable();
        if (isNullable) {
            $receiver.append("(");
        }
        if ((receiverType = KotlinBuiltIns.getReceiverType(type2)) != null) {
            boolean surroundReceiver;
            boolean bl = surroundReceiver = this.shouldRenderAsPrettyFunctionType(receiverType) && !receiverType.isMarkedNullable();
            if (surroundReceiver) {
                $receiver.append("(");
            }
            $receiver.append(this.renderNormalizedType(receiverType));
            if (surroundReceiver) {
                $receiver.append(")");
            }
            $receiver.append(".");
        }
        $receiver.append("(");
        List<TypeProjection> list = KotlinBuiltIns.getParameterTypeProjectionsFromFunctionType(type2);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"KotlinBuiltIns.getParame\u2026onsFromFunctionType(type)");
        this.appendTypeProjections(list, $receiver);
        $receiver.append(") ").append(this.arrow()).append(" ");
        JetType jetType = KotlinBuiltIns.getReturnTypeFromFunctionType(type2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"KotlinBuiltIns.getReturnTypeFromFunctionType(type)");
        $receiver.append(this.renderNormalizedType(jetType));
        if (isNullable) {
            $receiver.append(")?");
        }
        String string = var2_2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder {\n        \u2026)?\")\n        }.toString()");
        return string;
    }

    private final void appendDefinedIn(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
            return;
        }
        if (descriptor2 instanceof ModuleDescriptor) {
            builder.append(" is a module");
            return;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration != null && !(containingDeclaration instanceof ModuleDescriptor)) {
            String string;
            builder.append(" ").append(this.renderMessage("defined in")).append(" ");
            FqNameUnsafe fqName2 = DescriptorUtils.getFqName(containingDeclaration);
            if (fqName2.isRoot()) {
                string = "root package";
            } else {
                FqNameBase fqNameBase = fqName2;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqNameBase, (String)"fqName");
                string = this.renderFqName(fqNameBase);
            }
            builder.append(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderAnnotations(Annotated annotated, StringBuilder builder, boolean needBrackets) {
        void $receiver;
        StringBuilder sb;
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS) ^ true) {
            return;
        }
        Set<FqName> excluded = annotated instanceof JetType ? this.getExcludedTypeAnnotationClasses() : this.getExcludedAnnotationClasses();
        StringBuilder $receiver2 = sb = new StringBuilder();
        Object object2 = annotated.getAnnotations().getAllAnnotations();
        Iterator iterator2 = $receiver;
        Comparator comparator = new Comparator<T>(this, annotated, excluded){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ DescriptorRendererImpl this$0;
            final /* synthetic */ Annotated $annotated$inlined;
            final /* synthetic */ Set $excluded$inlined;

            static {
                $kotlinClass = Reflection.createKotlinClass(renderAnnotations$$inlined$StringBuilder$lambda$1.class);
            }

            public int compare(T a, T b) {
                AnnotationWithTarget p = (AnnotationWithTarget)a;
                Comparable comparable = Boolean.valueOf(DescriptorRendererImpl.access$isBuiltinModifier$18(this.this$0, p.getAnnotation()));
                p = (AnnotationWithTarget)b;
                Comparable comparable2 = comparable;
                Boolean bl = DescriptorRendererImpl.access$isBuiltinModifier$18(this.this$0, p.getAnnotation());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)bl);
            }
            {
                this.this$0 = descriptorRendererImpl;
                this.$annotated$inlined = annotated;
                this.$excluded$inlined = set;
            }
        };
        List sortedAnnotations = CollectionsKt.sortedWith((Iterable)((Object)iterator2), (Comparator)comparator);
        for (Object object2 : sortedAnnotations) {
            AnnotationDescriptor annotation = ((AnnotationWithTarget)object2).component1();
            AnnotationUseSiteTarget target = ((AnnotationWithTarget)object2).component2();
            ClassifierDescriptor classifierDescriptor = annotation.getType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor annotationClass = (ClassDescriptor)classifierDescriptor;
            if (excluded.contains(DescriptorUtils.getFqNameSafe(annotationClass))) continue;
            $receiver2.append(this.renderAnnotation(annotation, target)).append(" ");
        }
        StringBuilder annotationsBuilder = sb;
        builder.append((CharSequence)annotationsBuilder);
    }

    static /* synthetic */ void renderAnnotations$default(DescriptorRendererImpl descriptorRendererImpl, Annotated annotated, StringBuilder stringBuilder, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        descriptorRendererImpl.renderAnnotations(annotated, stringBuilder, bl);
    }

    private final boolean isBuiltinModifier(AnnotationDescriptor $receiver) {
        ClassifierDescriptor classifierDescriptor = $receiver.getType().getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return AnnotationUtilKt.getANNOTATION_MODIFIERS_FQ_NAMES().contains(DescriptorUtilsKt.getFqNameSafe((ClassDescriptor)classifierDescriptor));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderAnnotation(@NotNull AnnotationDescriptor annotation, @Nullable AnnotationUseSiteTarget target) {
        void var3_3;
        StringBuilder sb;
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        StringBuilder $receiver = sb = new StringBuilder();
        $receiver.append('@');
        if (target != null) {
            $receiver.append(target.getRenderName() + ":");
        }
        JetType jetType = annotation.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"annotation.getType()");
        $receiver.append(this.renderType(jetType));
        if (this.getVerbose()) {
            CollectionsKt.joinTo$default((Iterable)this.renderAndSortAnnotationArguments(annotation), (Appendable)$receiver, (String)", ", (String)"(", (String)")", (int)0, null, null, (int)112);
        }
        String string = var3_3.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder {\n        \u2026   }\n        }.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> renderAndSortAnnotationArguments(AnnotationDescriptor descriptor2) {
        void destination;
        void $receiver;
        String string;
        Collection collection;
        Iterable destination2;
        ValueParameterDescriptor it;
        Iterable $receiver2;
        List list;
        Iterable destination3;
        Object element2;
        Iterable $receiver3;
        Map<ValueParameterDescriptor, ConstantValue<?>> allValueArguments2 = descriptor2.getAllValueArguments();
        ClassDescriptor classDescriptor = this.getRenderDefaultAnnotationArguments() ? TypeUtils.getClassDescriptor(descriptor2.getType()) : (ClassDescriptor)null;
        Object object = classDescriptor;
        if (object != null && (object = object.getUnsubstitutedPrimaryConstructor()) != null && (object = object.getValueParameters()) != null) {
            void $receiver4;
            Iterable iterable = (Iterable)object;
            void var5_5 = $receiver4;
            Collection collection2 = new ArrayList();
            for (Object element2 : $receiver3) {
                ValueParameterDescriptor it2 = (ValueParameterDescriptor)element2;
                if (!it2.declaresDefaultValue()) continue;
                destination3.add(element2);
            }
            list = (List)destination3;
        } else {
            list = CollectionsKt.emptyList();
        }
        List parameterDescriptorsWithDefaultValue = list;
        $receiver3 = parameterDescriptorsWithDefaultValue;
        destination3 = $receiver3;
        Collection collection3 = new ArrayList();
        for (Object element3 : $receiver2) {
            it = (ValueParameterDescriptor)element3;
            if (!(!allValueArguments2.containsKey(it))) continue;
            destination2.add(element3);
        }
        $receiver3 = (List)destination2;
        $receiver2 = $receiver3;
        destination2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
        for (Object item : $receiver2) {
            it = (ValueParameterDescriptor)item;
            collection = destination2;
            string = it.getName().asString() + " = ...";
            collection.add(string);
        }
        List defaultList = CollectionsKt.sort((Iterable)((List)destination2));
        $receiver2 = allValueArguments2.entrySet();
        destination2 = $receiver2;
        element2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            String string2;
            void entry;
            Map.Entry entry2 = (Map.Entry)item;
            collection = destination;
            String name = ((ValueParameterDescriptor)MapsKt.getKey((Map.Entry)entry)).getName().asString();
            if (!parameterDescriptorsWithDefaultValue.contains(MapsKt.getKey((Map.Entry)entry))) {
                ConstantValue constantValue = (ConstantValue)MapsKt.getValue((Map.Entry)entry);
                Intrinsics.checkExpressionValueIsNotNull((Object)constantValue, (String)"entry.value");
                string2 = this.renderConstant(constantValue);
            } else {
                string2 = "...";
            }
            String value = string2;
            string = name + " = " + value;
            collection.add(string);
        }
        List argumentList = CollectionsKt.sort((Iterable)((List)destination));
        return CollectionsKt.sort((Iterable)CollectionsKt.plus((Collection)defaultList, (Iterable)argumentList));
    }

    /*
     * WARNING - void declaration
     */
    private final String renderConstant(ConstantValue<?> value) {
        String string;
        ConstantValue<?> constantValue = value;
        if (constantValue instanceof ArrayValue) {
            void destination;
            void $receiver;
            Iterable $receiver2 = (Iterable)((ArrayValue)value).getValue();
            Iterable iterable = $receiver2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                ConstantValue constantValue2 = (ConstantValue)item;
                void var9_9 = destination;
                String string2 = this.renderConstant(it);
                var9_9.add(string2);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination), (String)", ", (String)"{", (String)"}", (int)0, null, null, (int)56);
        } else {
            string = constantValue instanceof AnnotationValue ? StringsKt.removePrefix((String)DescriptorRenderer$$TImpl.renderAnnotation$default(this, (AnnotationDescriptor)((AnnotationValue)value).getValue(), null, 2), (String)"@") : (constantValue instanceof KClassValue ? this.renderType(((KClassValue)value).getValue()) + "::class" : value.toString());
        }
        return string;
    }

    private final void renderVisibility(Visibility visibility, StringBuilder builder) {
        Visibility visibility2 = visibility;
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.VISIBILITY) ^ true) {
            return;
        }
        if (this.getNormalizedVisibilities()) {
            visibility2 = visibility2.normalize();
        }
        if (!this.getShowInternalKeyword() && Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.DEFAULT_VISIBILITY)) {
            return;
        }
        builder.append(this.renderKeyword(visibility2.getDisplayName())).append(" ");
    }

    private final void renderModality(Modality modality, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.MODALITY) ^ true) {
            return;
        }
        String keyword = StringsKt.toLowerCase((String)modality.name());
        builder.append(this.renderKeyword(keyword)).append(" ");
    }

    private final void renderInner(boolean isInner, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.INNER) ^ true) {
            return;
        }
        if (isInner) {
            builder.append(this.renderKeyword("inner")).append(" ");
        }
    }

    private final void renderModalityForCallable(CallableMemberDescriptor callable, StringBuilder builder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callable) || Intrinsics.areEqual((Object)((Object)callable.getModality()), (Object)((Object)Modality.FINAL)) ^ true) {
            if (this.overridesSomething(callable) && Intrinsics.areEqual((Object)((Object)this.getOverrideRenderingPolicy()), (Object)((Object)OverrideRenderingPolicy.RENDER_OVERRIDE)) && Intrinsics.areEqual((Object)((Object)callable.getModality()), (Object)((Object)Modality.OPEN))) {
                return;
            }
            Modality modality = callable.getModality();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality), (String)"callable.getModality()");
            this.renderModality(modality, builder);
        }
    }

    private final void renderOverride(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.OVERRIDE) ^ true) {
            return;
        }
        if (this.overridesSomething(callableMember) && Intrinsics.areEqual((Object)((Object)this.getOverrideRenderingPolicy()), (Object)((Object)OverrideRenderingPolicy.RENDER_OPEN)) ^ true) {
            builder.append("override ");
            if (this.getVerbose()) {
                builder.append("/*").append(callableMember.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private final void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.MEMBER_KIND) ^ true) {
            return;
        }
        if (this.getVerbose() && Intrinsics.areEqual((Object)((Object)callableMember.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION)) ^ true) {
            builder.append("/*").append(StringsKt.toLowerCase((String)callableMember.getKind().name())).append("*/ ");
        }
    }

    private final void renderLateInit(PropertyDescriptor propertyDescriptor, StringBuilder builder) {
        if (propertyDescriptor.isLateInit()) {
            builder.append("lateinit ");
        }
    }

    private final void renderOperator(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        if (functionDescriptor.isOperator()) {
            boolean bl;
            block3: {
                Iterable $receiver = functionDescriptor.getOverriddenDescriptors();
                for (Object element : $receiver) {
                    FunctionDescriptor it = (FunctionDescriptor)element;
                    if (!it.isOperator()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (bl) {
                builder.append("operator ");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        void var2_2;
        StringBuilder sb;
        Intrinsics.checkParameterIsNotNull((Object)declarationDescriptor, (String)"declarationDescriptor");
        StringBuilder $receiver = sb = new StringBuilder();
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), $receiver);
        if (this.getWithDefinedIn()) {
            this.appendDefinedIn(declarationDescriptor, $receiver);
        }
        String string = var2_2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder {\n        \u2026   }\n        }.toString()");
        return string;
    }

    private final void renderTypeParameter(TypeParameterDescriptor typeParameter, StringBuilder builder, boolean topLevel) {
        String variance;
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.getVerbose()) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        if (typeParameter.isReified()) {
            builder.append(this.renderKeyword("reified")).append(" ");
        }
        if (!StringsKt.isEmpty((String)(variance = typeParameter.getVariance().getLabel()))) {
            builder.append(this.renderKeyword(variance)).append(" ");
        }
        this.renderName(typeParameter, builder);
        int upperBoundsCount = typeParameter.getUpperBounds().size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            JetType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (Intrinsics.areEqual((Object)KotlinBuiltIns.getInstance().getDefaultBound(), (Object)upperBound) ^ true) {
                StringBuilder stringBuilder = builder.append(" : ");
                JetType jetType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"upperBound");
                stringBuilder.append(this.renderType(jetType));
            }
        } else if (topLevel) {
            boolean first = true;
            for (JetType upperBound : typeParameter.getUpperBounds()) {
                if (Intrinsics.areEqual((Object)upperBound, (Object)KotlinBuiltIns.getInstance().getDefaultBound())) continue;
                if (first) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                JetType jetType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"upperBound");
                builder.append(this.renderType(jetType));
                first = false;
            }
        }
        if (topLevel) {
            builder.append(this.gt());
        }
    }

    private final void renderTypeParameters(List<? extends TypeParameterDescriptor> typeParameters, StringBuilder builder, boolean withSpace) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        if (!typeParameters.isEmpty()) {
            builder.append(this.lt());
            Iterator<? extends TypeParameterDescriptor> iterator2 = typeParameters.iterator();
            while (iterator2.hasNext()) {
                TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
                this.renderTypeParameter(typeParameterDescriptor, builder, false);
                if (!iterator2.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(this.gt());
            if (withSpace) {
                builder.append(" ");
            }
        }
    }

    private final void renderFunction(FunctionDescriptor function, StringBuilder builder) {
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, function, builder, false, 4);
            Visibility visibility = function.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"function.getVisibility()");
            this.renderVisibility(visibility, builder);
            this.renderModalityForCallable(function, builder);
            this.renderOperator(function, builder);
            this.renderOverride(function, builder);
            this.renderMemberKind(function, builder);
            builder.append(this.renderKeyword("fun")).append(" ");
            List<TypeParameterDescriptor> list = function.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"function.getTypeParameters()");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(function, builder);
        }
        this.renderName(function, builder);
        Collection collection = function.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"function.valueParameters");
        this.renderValueParameters(collection, function.hasSynthesizedParameterNames(), builder);
        this.renderReceiverAfterName(function, builder);
        JetType returnType2 = function.getReturnType();
        if (!(this.getWithoutReturnType() || !this.getUnitReturnType() && returnType2 != null && KotlinBuiltIns.isUnit(returnType2))) {
            builder.append(": ").append(returnType2 == null ? "[NULL]" : this.escape(this.renderType(returnType2)));
        }
        List<TypeParameterDescriptor> list = function.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"function.getTypeParameters()");
        this.renderWhereSuffix(list, builder);
    }

    private final void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder builder) {
        if (!this.getReceiverAfterName()) {
            return;
        }
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            StringBuilder stringBuilder = builder.append(" on ");
            JetType jetType = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"receiver.getType()");
            stringBuilder.append(this.escape(this.renderType(jetType)));
        }
    }

    private final void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder builder) {
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            JetType type2;
            JetType jetType = type2 = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"type");
            String result = this.escape(this.renderType(jetType));
            JetType jetType2 = type2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jetType2, (String)"type");
            if (this.shouldRenderAsPrettyFunctionType(jetType2) && !TypeUtils.isNullableType(type2)) {
                result = "(" + result + ")";
            }
            builder.append(result).append(".");
        }
    }

    private final void renderConstructor(ConstructorDescriptor constructor, StringBuilder builder) {
        DescriptorRendererImpl.renderAnnotations$default(this, constructor, builder, false, 4);
        Visibility visibility = constructor.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"constructor.getVisibility()");
        this.renderVisibility(visibility, builder);
        this.renderMemberKind(constructor, builder);
        builder.append(this.renderKeyword("constructor"));
        if (this.getSecondaryConstructorsAsPrimary()) {
            ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
            builder.append(" ");
            DeclarationDescriptor declarationDescriptor = classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"classDescriptor");
            this.renderName(declarationDescriptor, builder);
            List<TypeParameterDescriptor> list = classDescriptor.getTypeConstructor().getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"classDescriptor.getTypeC\u2026tructor().getParameters()");
            this.renderTypeParameters(list, builder, false);
        }
        Collection collection = constructor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"constructor.valueParameters");
        this.renderValueParameters(collection, constructor.hasSynthesizedParameterNames(), builder);
        if (this.getSecondaryConstructorsAsPrimary()) {
            List<TypeParameterDescriptor> list = constructor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"constructor.getTypeParameters()");
            this.renderWhereSuffix(list, builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderWhereSuffix(List<? extends TypeParameterDescriptor> typeParameters, StringBuilder builder) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        ArrayList upperBoundStrings = new ArrayList(0);
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            void $receiver;
            Iterable iterable = CollectionsKt.drop((Iterable)typeParameterDescriptor.getUpperBounds(), (int)1);
            for (Object item : $receiver) {
                void it;
                JetType jetType = (JetType)item;
                Collection collection = upperBoundStrings;
                StringBuilder stringBuilder = new StringBuilder();
                Name name = typeParameterDescriptor.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"typeParameter.getName()");
                StringBuilder stringBuilder2 = stringBuilder.append(this.renderName(name)).append(" : ");
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                String string = stringBuilder2.append(this.escape(this.renderType((JetType)v3))).toString();
                collection.add(string);
            }
        }
        if (!upperBoundStrings.isEmpty()) {
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            CollectionsKt.joinTo$default((Iterable)upperBoundStrings, (Appendable)builder, (String)", ", null, null, (int)0, null, null, (int)124);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderValueParameters(@NotNull Collection<? extends ValueParameterDescriptor> parameters2, boolean synthesizedParameterNames) {
        void var3_3;
        StringBuilder sb;
        Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
        StringBuilder $receiver = sb = new StringBuilder();
        this.renderValueParameters(parameters2, synthesizedParameterNames, $receiver);
        String string = var3_3.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder { renderVa\u2026Names, this) }.toString()");
        return string;
    }

    private final void renderValueParameters(Collection<? extends ValueParameterDescriptor> parameters2, boolean synthesizedParameterNames, StringBuilder builder) {
        boolean includeNames = this.shouldRenderParameterNames(synthesizedParameterNames);
        int parameterCount = parameters2.size();
        this.getValueParametersHandler().appendBeforeValueParameters(parameterCount, builder);
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)parameters2)) {
            int index = indexedValue.component1();
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)indexedValue.component2();
            this.getValueParametersHandler().appendBeforeValueParameter(parameter, index, parameterCount, builder);
            this.renderValueParameter(parameter, includeNames, builder, false);
            this.getValueParametersHandler().appendAfterValueParameter(parameter, index, parameterCount, builder);
        }
        this.getValueParametersHandler().appendAfterValueParameters(parameterCount, builder);
    }

    private final boolean shouldRenderParameterNames(boolean synthesizedParameterNames) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$6[this.getParameterNameRenderingPolicy().ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return !synthesizedParameterNames;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    private final void renderValueParameter(ValueParameterDescriptor valueParameter, boolean includeName, StringBuilder builder, boolean topLevel) {
        boolean withDefaultValue;
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.getVerbose()) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        DescriptorRendererImpl.renderAnnotations$default(this, valueParameter, builder, false, 4);
        this.renderVariable(valueParameter, includeName, builder, topLevel);
        boolean bl = this.getRenderDefaultValues() && (this.getDebugMode() ? valueParameter.declaresDefaultValue() : DescriptorUtilsKt.hasDefaultValue(valueParameter)) ? true : (withDefaultValue = false);
        if (withDefaultValue) {
            builder.append(" = ...");
        }
    }

    private final void renderValVarPrefix(VariableDescriptor variable, StringBuilder builder) {
        builder.append(this.renderKeyword(variable.isVar() ? "var" : "val")).append(" ");
    }

    private final void renderVariable(VariableDescriptor variable, boolean includeName, StringBuilder builder, boolean topLevel) {
        JetType typeToRender;
        JetType realType = variable.getType();
        VariableDescriptor variableDescriptor = variable;
        if (!(variableDescriptor instanceof ValueParameterDescriptor)) {
            variableDescriptor = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)variableDescriptor;
        JetType varargElementType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        JetType jetType = varargElementType;
        if (jetType == null) {
            jetType = typeToRender = realType;
        }
        if (varargElementType != null) {
            builder.append(this.renderKeyword("vararg")).append(" ");
        }
        if (topLevel && !this.getStartFromName()) {
            this.renderValVarPrefix(variable, builder);
        }
        if (includeName) {
            this.renderName(variable, builder);
            builder.append(": ");
        }
        JetType jetType2 = typeToRender;
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType2, (String)"typeToRender");
        builder.append(this.escape(this.renderType(jetType2)));
        this.renderInitializer(variable, builder);
        if (this.getVerbose() && varargElementType != null) {
            StringBuilder stringBuilder = builder.append(" /*");
            JetType jetType3 = realType;
            Intrinsics.checkExpressionValueIsNotNull((Object)jetType3, (String)"realType");
            stringBuilder.append(this.escape(this.renderType(jetType3))).append("*/");
        }
    }

    private final void renderProperty(PropertyDescriptor property, StringBuilder builder) {
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, property, builder, false, 4);
            Visibility visibility = property.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"property.getVisibility()");
            this.renderVisibility(visibility, builder);
            if (property.isConst()) {
                builder.append("const ");
            }
            this.renderModalityForCallable(property, builder);
            this.renderOverride(property, builder);
            this.renderLateInit(property, builder);
            this.renderMemberKind(property, builder);
            this.renderValVarPrefix(property, builder);
            List<TypeParameterDescriptor> list = property.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"property.getTypeParameters()");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(property, builder);
        }
        this.renderName(property, builder);
        StringBuilder stringBuilder = builder.append(": ");
        JetType jetType = property.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"property.getType()");
        stringBuilder.append(this.escape(this.renderType(jetType)));
        this.renderReceiverAfterName(property, builder);
        this.renderInitializer(property, builder);
        List<TypeParameterDescriptor> list = property.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"property.getTypeParameters()");
        this.renderWhereSuffix(list, builder);
    }

    private final void renderInitializer(VariableDescriptor variable, StringBuilder builder) {
        if (this.getIncludePropertyConstant()) {
            StringBuilder stringBuilder;
            ConstantValue<?> constantValue = variable.getCompileTimeInitializer();
            if (constantValue != null) {
                ConstantValue<?> $receiver = constantValue;
                ConstantValue<?> constant = $receiver;
                StringBuilder stringBuilder2 = builder.append(" = ");
                ConstantValue<?> constantValue2 = constant;
                Intrinsics.checkExpressionValueIsNotNull(constantValue2, (String)"constant");
                stringBuilder = stringBuilder2.append(this.escape(this.renderConstant(constantValue2)));
            } else {
                stringBuilder = null;
            }
        }
    }

    private final void renderClass(ClassDescriptor klass, StringBuilder builder) {
        ConstructorDescriptor primaryConstructor2;
        List<TypeParameterDescriptor> typeParameters;
        boolean isEnumEntry = Intrinsics.areEqual((Object)((Object)klass.getKind()), (Object)((Object)ClassKind.ENUM_ENTRY));
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, klass, builder, false, 4);
            if (!isEnumEntry) {
                Visibility visibility = klass.getVisibility();
                Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"klass.visibility");
                this.renderVisibility(visibility, builder);
            }
            if (!(Intrinsics.areEqual((Object)((Object)klass.getKind()), (Object)((Object)ClassKind.INTERFACE)) && Intrinsics.areEqual((Object)((Object)klass.getModality()), (Object)((Object)Modality.ABSTRACT)) || klass.getKind().isSingleton() && Intrinsics.areEqual((Object)((Object)klass.getModality()), (Object)((Object)Modality.FINAL)))) {
                Modality modality = klass.getModality();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality), (String)"klass.modality");
                this.renderModality(modality, builder);
            }
            this.renderInner(klass.isInner(), builder);
            this.renderClassKindPrefix(klass, builder);
        }
        if (!DescriptorUtils.isCompanionObject(klass)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            this.renderName(klass, builder);
        } else {
            this.renderCompanionObjectName(klass, builder);
        }
        if (isEnumEntry) {
            return;
        }
        List<TypeParameterDescriptor> list = typeParameters = klass.getTypeConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"typeParameters");
        this.renderTypeParameters(list, builder, false);
        if (!klass.getKind().isSingleton() && this.getClassWithPrimaryConstructor() && (primaryConstructor2 = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            builder.append(" ");
            this.renderAnnotations(primaryConstructor2, builder, true);
            Visibility visibility = primaryConstructor2.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"primaryConstructor.visibility");
            this.renderVisibility(visibility, builder);
            builder.append("constructor");
            Collection collection = primaryConstructor2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"primaryConstructor.valueParameters");
            this.renderValueParameters(collection, primaryConstructor2.hasSynthesizedParameterNames(), builder);
        }
        this.renderSuperTypes(klass, builder);
        List<TypeParameterDescriptor> list2 = typeParameters;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeParameters");
        this.renderWhereSuffix(list2, builder);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSuperTypes(ClassDescriptor klass, StringBuilder builder) {
        void destination;
        void $receiver;
        void $receiver2;
        if (this.getWithoutSuperTypes()) {
            return;
        }
        if (Intrinsics.areEqual((Object)klass, (Object)KotlinBuiltIns.getInstance().getNothing())) {
            return;
        }
        Collection<JetType> supertypes2 = klass.getTypeConstructor().getSupertypes();
        if (supertypes2.isEmpty() || supertypes2.size() == 1 && KotlinBuiltIns.isAnyOrNullableAny(supertypes2.iterator().next())) {
            return;
        }
        this.renderSpaceIfNeeded(builder);
        builder.append(": ");
        Iterable iterable = supertypes2;
        void var5_5 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            JetType jetType = (JetType)item;
            void var10_10 = destination;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
            String string = this.renderType((JetType)v0);
            var10_10.add(string);
        }
        CollectionsKt.joinTo$default((Iterable)((List)destination), (Appendable)builder, (String)", ", null, null, (int)0, null, null, (int)124);
    }

    private final void renderClassKindPrefix(ClassDescriptor klass, StringBuilder builder) {
        builder.append(this.renderKeyword(DescriptorRenderer.Companion.getClassKindPrefix(klass)));
    }

    private final void renderModuleOrScript(DeclarationDescriptor moduleOrScript, StringBuilder builder) {
        this.renderName(moduleOrScript, builder);
    }

    private final void renderPackageView(PackageViewDescriptor packageView, StringBuilder builder) {
        builder.append(this.renderKeyword("package")).append(" ");
        builder.append(this.renderFqName(packageView.getFqName()));
        if (this.getDebugMode()) {
            builder.append(" in context of ");
            this.renderName(packageView.getModule(), builder);
        }
    }

    private final void renderPackageFragment(PackageFragmentDescriptor fragment, StringBuilder builder) {
        builder.append(this.renderKeyword("package-fragment")).append(" ");
        builder.append(this.renderFqName(fragment.getFqName()));
        if (this.getDebugMode()) {
            builder.append(" in ");
            this.renderName(fragment.getContainingDeclaration(), builder);
        }
    }

    private final void renderSpaceIfNeeded(StringBuilder builder) {
        int length = builder.length();
        if (length == 0 || builder.charAt(length - 1) != ' ') {
            builder.append(' ');
        }
    }

    private final String replacePrefixes(String lowerRendered, String lowerPrefix, String upperRendered, String upperPrefix, String foldedPrefix) {
        if (StringsKt.startsWith$default((String)lowerRendered, (String)lowerPrefix, (boolean)false, (int)2) && StringsKt.startsWith$default((String)upperRendered, (String)upperPrefix, (boolean)false, (int)2)) {
            String lowerWithoutPrefix = StringsKt.substring((String)lowerRendered, (int)lowerPrefix.length());
            String upperWithoutPrefix = StringsKt.substring((String)upperRendered, (int)upperPrefix.length());
            String flexibleCollectionName = foldedPrefix + lowerWithoutPrefix;
            if (Intrinsics.areEqual((Object)lowerWithoutPrefix, (Object)upperWithoutPrefix)) {
                return flexibleCollectionName;
            }
            if (this.differsOnlyInNullability(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName + "!";
            }
        }
        return null;
    }

    private final boolean differsOnlyInNullability(String lower, String upper) {
        return Intrinsics.areEqual((Object)lower, (Object)StringsKt.replace$default((String)upper, (String)"?", (String)"", (boolean)false, (int)4)) || StringsKt.endsWith$default((String)upper, (String)"?", (boolean)false, (int)2) && Intrinsics.areEqual((Object)(lower + "?"), (Object)upper) || Intrinsics.areEqual((Object)("(" + lower + ")?"), (Object)upper);
    }

    private final boolean overridesSomething(CallableMemberDescriptor callable) {
        return !callable.getOverriddenDescriptors().isEmpty();
    }

    @NotNull
    public final DescriptorRendererOptionsImpl getOptions() {
        return this.options;
    }

    public DescriptorRendererImpl(@NotNull DescriptorRendererOptionsImpl options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.options = options;
        PreconditionsKt.assert((boolean)this.options.getIsLocked());
    }

    @Override
    @NotNull
    public DescriptorRenderer withOptions(@NotNull Function1<? super DescriptorRendererOptions, ? extends Unit> changeOptions) {
        Intrinsics.checkParameterIsNotNull(changeOptions, (String)"changeOptions");
        return DescriptorRenderer$$TImpl.withOptions(this, changeOptions);
    }

    @Override
    @NotNull
    public String renderFunctionParameters(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        return DescriptorRenderer$$TImpl.renderFunctionParameters(this, functionDescriptor);
    }

    @Override
    public boolean getClassWithPrimaryConstructor() {
        return this.options.getClassWithPrimaryConstructor();
    }

    @Override
    public void setClassWithPrimaryConstructor(boolean bl) {
        this.options.setClassWithPrimaryConstructor(bl);
    }

    @Override
    public boolean getDebugMode() {
        return this.options.getDebugMode();
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.options.setDebugMode(bl);
    }

    @Override
    @NotNull
    public Set<FqName> getExcludedAnnotationClasses() {
        return this.options.getExcludedAnnotationClasses();
    }

    @Override
    public void setExcludedAnnotationClasses(@NotNull Set<? extends FqName> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
        this.options.setExcludedAnnotationClasses(set);
    }

    @Override
    @NotNull
    public Set<FqName> getExcludedTypeAnnotationClasses() {
        return this.options.getExcludedTypeAnnotationClasses();
    }

    @Override
    public void setExcludedTypeAnnotationClasses(@NotNull Set<? extends FqName> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
        this.options.setExcludedTypeAnnotationClasses(set);
    }

    @Override
    public boolean getFlexibleTypesForCode() {
        return this.options.getFlexibleTypesForCode();
    }

    @Override
    public void setFlexibleTypesForCode(boolean bl) {
        this.options.setFlexibleTypesForCode(bl);
    }

    @Override
    public boolean getIncludePropertyConstant() {
        return this.options.getIncludePropertyConstant();
    }

    @Override
    public void setIncludePropertyConstant(boolean bl) {
        this.options.setIncludePropertyConstant(bl);
    }

    @Override
    @NotNull
    public Set<DescriptorRendererModifier> getModifiers() {
        return this.options.getModifiers();
    }

    @Override
    public void setModifiers(@NotNull Set<? extends DescriptorRendererModifier> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
        this.options.setModifiers(set);
    }

    @Override
    @NotNull
    public NameShortness getNameShortness() {
        return this.options.getNameShortness();
    }

    @Override
    public void setNameShortness(@NotNull NameShortness nameShortness) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)nameShortness), (String)"<set-?>");
        this.options.setNameShortness(nameShortness);
    }

    @Override
    public boolean getNormalizedVisibilities() {
        return this.options.getNormalizedVisibilities();
    }

    @Override
    public void setNormalizedVisibilities(boolean bl) {
        this.options.setNormalizedVisibilities(bl);
    }

    @Override
    @NotNull
    public OverrideRenderingPolicy getOverrideRenderingPolicy() {
        return this.options.getOverrideRenderingPolicy();
    }

    @Override
    public void setOverrideRenderingPolicy(@NotNull OverrideRenderingPolicy overrideRenderingPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)overrideRenderingPolicy), (String)"<set-?>");
        this.options.setOverrideRenderingPolicy(overrideRenderingPolicy);
    }

    @Override
    @NotNull
    public ParameterNameRenderingPolicy getParameterNameRenderingPolicy() {
        return this.options.getParameterNameRenderingPolicy();
    }

    @Override
    public void setParameterNameRenderingPolicy(@NotNull ParameterNameRenderingPolicy parameterNameRenderingPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)parameterNameRenderingPolicy), (String)"<set-?>");
        this.options.setParameterNameRenderingPolicy(parameterNameRenderingPolicy);
    }

    @Override
    public boolean getPrettyFunctionTypes() {
        return this.options.getPrettyFunctionTypes();
    }

    @Override
    public void setPrettyFunctionTypes(boolean bl) {
        this.options.setPrettyFunctionTypes(bl);
    }

    @Override
    public boolean getReceiverAfterName() {
        return this.options.getReceiverAfterName();
    }

    @Override
    public void setReceiverAfterName(boolean bl) {
        this.options.setReceiverAfterName(bl);
    }

    @Override
    public boolean getRenderAccessors() {
        return this.options.getRenderAccessors();
    }

    @Override
    public void setRenderAccessors(boolean bl) {
        this.options.setRenderAccessors(bl);
    }

    @Override
    public boolean getRenderCompanionObjectName() {
        return this.options.getRenderCompanionObjectName();
    }

    @Override
    public void setRenderCompanionObjectName(boolean bl) {
        this.options.setRenderCompanionObjectName(bl);
    }

    @Override
    public boolean getRenderDefaultAnnotationArguments() {
        return this.options.getRenderDefaultAnnotationArguments();
    }

    @Override
    public void setRenderDefaultAnnotationArguments(boolean bl) {
        this.options.setRenderDefaultAnnotationArguments(bl);
    }

    @Override
    public boolean getRenderDefaultValues() {
        return this.options.getRenderDefaultValues();
    }

    @Override
    public void setRenderDefaultValues(boolean bl) {
        this.options.setRenderDefaultValues(bl);
    }

    @Override
    public boolean getSecondaryConstructorsAsPrimary() {
        return this.options.getSecondaryConstructorsAsPrimary();
    }

    @Override
    public void setSecondaryConstructorsAsPrimary(boolean bl) {
        this.options.setSecondaryConstructorsAsPrimary(bl);
    }

    @Override
    public boolean getShowInternalKeyword() {
        return this.options.getShowInternalKeyword();
    }

    @Override
    public void setShowInternalKeyword(boolean bl) {
        this.options.setShowInternalKeyword(bl);
    }

    @Override
    public boolean getStartFromName() {
        return this.options.getStartFromName();
    }

    @Override
    public void setStartFromName(boolean bl) {
        this.options.setStartFromName(bl);
    }

    @Override
    @NotNull
    public RenderingFormat getTextFormat() {
        return this.options.getTextFormat();
    }

    @Override
    public void setTextFormat(@NotNull RenderingFormat renderingFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)renderingFormat), (String)"<set-?>");
        this.options.setTextFormat(renderingFormat);
    }

    @Override
    @NotNull
    public Function1<JetType, JetType> getTypeNormalizer() {
        return this.options.getTypeNormalizer();
    }

    @Override
    public void setTypeNormalizer(@NotNull Function1<? super JetType, ? extends JetType> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.options.setTypeNormalizer(function1);
    }

    @Override
    public boolean getUninferredTypeParameterAsName() {
        return this.options.getUninferredTypeParameterAsName();
    }

    @Override
    public void setUninferredTypeParameterAsName(boolean bl) {
        this.options.setUninferredTypeParameterAsName(bl);
    }

    @Override
    public boolean getUnitReturnType() {
        return this.options.getUnitReturnType();
    }

    @Override
    public void setUnitReturnType(boolean bl) {
        this.options.setUnitReturnType(bl);
    }

    @Override
    @NotNull
    public DescriptorRenderer.ValueParametersHandler getValueParametersHandler() {
        return this.options.getValueParametersHandler();
    }

    @Override
    public void setValueParametersHandler(@NotNull DescriptorRenderer.ValueParametersHandler valueParametersHandler) {
        Intrinsics.checkParameterIsNotNull((Object)valueParametersHandler, (String)"<set-?>");
        this.options.setValueParametersHandler(valueParametersHandler);
    }

    @Override
    public boolean getVerbose() {
        return this.options.getVerbose();
    }

    @Override
    public void setVerbose(boolean bl) {
        this.options.setVerbose(bl);
    }

    @Override
    public boolean getWithDefinedIn() {
        return this.options.getWithDefinedIn();
    }

    @Override
    public void setWithDefinedIn(boolean bl) {
        this.options.setWithDefinedIn(bl);
    }

    @Override
    public boolean getWithoutReturnType() {
        return this.options.getWithoutReturnType();
    }

    @Override
    public void setWithoutReturnType(boolean bl) {
        this.options.setWithoutReturnType(bl);
    }

    @Override
    public boolean getWithoutSuperTypes() {
        return this.options.getWithoutSuperTypes();
    }

    @Override
    public void setWithoutSuperTypes(boolean bl) {
        this.options.setWithoutSuperTypes(bl);
    }

    @Override
    public boolean getWithoutTypeParameters() {
        return this.options.getWithoutTypeParameters();
    }

    @Override
    public void setWithoutTypeParameters(boolean bl) {
        this.options.setWithoutTypeParameters(bl);
    }

    public static final /* synthetic */ boolean access$isBuiltinModifier$18(DescriptorRendererImpl $this, AnnotationDescriptor $receiver) {
        return $this.isBuiltinModifier($receiver);
    }

    private final class RenderDeclarationDescriptorVisitor
    implements DeclarationDescriptorVisitor<Unit, StringBuilder> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(RenderDeclarationDescriptorVisitor.class);
        }

        @Override
        public void visitValueParameterDescriptor(@NotNull ValueParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderValueParameter(descriptor2, true, builder, true);
        }

        @Override
        public void visitVariableDescriptor(@NotNull VariableDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderVariable(descriptor2, true, builder, true);
        }

        @Override
        public void visitPropertyDescriptor(@NotNull PropertyDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderProperty(descriptor2, builder);
        }

        @Override
        public void visitPropertyGetterDescriptor(@NotNull PropertyGetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            if (DescriptorRendererImpl.this.getRenderAccessors()) {
                builder.append("getter for ");
                PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.getCorrespondingProperty()");
                DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
            } else {
                this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
            }
        }

        @Override
        public void visitPropertySetterDescriptor(@NotNull PropertySetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            if (DescriptorRendererImpl.this.getRenderAccessors()) {
                builder.append("setter for ");
                PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.getCorrespondingProperty()");
                DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
            } else {
                this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
            }
        }

        @Override
        public void visitFunctionDescriptor(@NotNull FunctionDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderFunction(descriptor2, builder);
        }

        @Override
        public void visitReceiverParameterDescriptor(@NotNull ReceiverParameterDescriptor descriptor2, @NotNull StringBuilder data2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            throw (Throwable)new UnsupportedOperationException("Don't render receiver parameters");
        }

        @Override
        public void visitConstructorDescriptor(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)constructorDescriptor, (String)"constructorDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, builder);
        }

        @Override
        public void visitTypeParameterDescriptor(@NotNull TypeParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderTypeParameter(descriptor2, builder, true);
        }

        @Override
        public void visitPackageFragmentDescriptor(@NotNull PackageFragmentDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderPackageFragment(descriptor2, builder);
        }

        @Override
        public void visitPackageViewDescriptor(@NotNull PackageViewDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderPackageView(descriptor2, builder);
        }

        @Override
        public void visitModuleDeclaration(@NotNull ModuleDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderModuleOrScript(descriptor2, builder);
        }

        @Override
        public void visitScriptDescriptor(@NotNull ScriptDescriptor scriptDescriptor, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)scriptDescriptor, (String)"scriptDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderModuleOrScript(scriptDescriptor, builder);
        }

        @Override
        public void visitClassDescriptor(@NotNull ClassDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderClass(descriptor2, builder);
        }
    }
}

