/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.components.DescriptorResolverUtils;
import kotlin.reflect.jvm.internal.impl.load.java.components.TypeUsage;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaClassResolver;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.ModuleClassResolver;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptorKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.LazyJavaTypeResolverKt;
import kotlin.reflect.jvm.internal.impl.load.java.sources.JavaSourceElement;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationAsAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaArrayAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassObjectAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaEnumValueAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaField;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaLiteralAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$$TImpl;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.NullableLazyValue;
import kotlin.reflect.jvm.internal.impl.types.AbstractLazyType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LazyJavaAnnotationDescriptor
implements AnnotationDescriptor {
    public static final /* synthetic */ KClass $kotlinClass;
    private final NullableLazyValue<FqName> fqName;
    private final NotNullLazyValue<JetType> type;
    private final JavaSourceElement source;
    private final ConstantValueFactory factory;
    private final NotNullLazyValue<Map<ValueParameterDescriptor, ? extends ConstantValue<?>>> allValueArguments;
    private final LazyJavaResolverContext c;
    @NotNull
    private final JavaAnnotation javaAnnotation;

    static {
        $kotlinClass = Reflection.createKotlinClass(LazyJavaAnnotationDescriptor.class);
    }

    @Override
    @NotNull
    public JetType getType() {
        JetType jetType = (JetType)this.type.invoke();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"type()");
        return jetType;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ConstantValue<?>> getAllValueArguments() {
        return (Map)this.allValueArguments.invoke();
    }

    @Override
    @NotNull
    public JavaSourceElement getSource() {
        return this.source;
    }

    private final Map<ValueParameterDescriptor, ConstantValue<?>> computeValueArguments() {
        Collection<ConstructorDescriptor> constructors2 = this.getAnnotationClass().getConstructors();
        if (constructors2.isEmpty()) {
            return MapsKt.mapOf();
        }
        Map nameToArg2 = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.valuesToMap((Iterable)this.javaAnnotation.getArguments(), (Function1)computeValueArguments.nameToArg.1.INSTANCE$);
        return kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.keysToMapExceptNulls((Iterable)((ConstructorDescriptor)CollectionsKt.first((Iterable)constructors2)).getValueParameters(), (Function1)new Function1<ValueParameterDescriptor, ConstantValue<?>>(this, nameToArg2){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;
            final /* synthetic */ Map $nameToArg;

            @Nullable
            public final ConstantValue<?> invoke(ValueParameterDescriptor valueParameter) {
                JavaAnnotationArgument javaAnnotationArgument = (JavaAnnotationArgument)this.$nameToArg.get(valueParameter.getName());
                if (javaAnnotationArgument == null && Intrinsics.areEqual((Object)valueParameter.getName(), (Object)JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME)) {
                    javaAnnotationArgument = (JavaAnnotationArgument)this.$nameToArg.get(null);
                }
                return LazyJavaAnnotationDescriptor.access$resolveAnnotationArgument$1(this.this$0, javaAnnotationArgument);
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                this.$nameToArg = map2;
                super(1);
            }
        });
    }

    private final ClassDescriptor getAnnotationClass() {
        ClassifierDescriptor classifierDescriptor = this.getType().getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    private final ConstantValue<?> resolveAnnotationArgument(JavaAnnotationArgument argument) {
        ConstantValue<?> constantValue;
        JavaAnnotationArgument javaAnnotationArgument = argument;
        if (javaAnnotationArgument instanceof JavaLiteralAnnotationArgument) {
            constantValue = this.factory.createConstantValue(((JavaLiteralAnnotationArgument)argument).getValue());
        } else if (javaAnnotationArgument instanceof JavaEnumValueAnnotationArgument) {
            constantValue = this.resolveFromEnumValue(((JavaEnumValueAnnotationArgument)argument).resolve());
        } else if (javaAnnotationArgument instanceof JavaArrayAnnotationArgument) {
            Name name = ((JavaArrayAnnotationArgument)argument).getName();
            if (name == null) {
                name = JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"argument.name ?: DEFAULT_ANNOTATION_MEMBER_NAME");
            constantValue = this.resolveFromArray(name, ((JavaArrayAnnotationArgument)argument).getElements());
        } else {
            constantValue = javaAnnotationArgument instanceof JavaAnnotationAsAnnotationArgument ? this.resolveFromAnnotation(((JavaAnnotationAsAnnotationArgument)argument).getAnnotation()) : (javaAnnotationArgument instanceof JavaClassObjectAnnotationArgument ? this.resolveFromJavaClassObjectType(((JavaClassObjectAnnotationArgument)argument).getReferencedType()) : (ConstantValue<?>)null);
        }
        return constantValue;
    }

    private final ConstantValue<?> resolveFromAnnotation(JavaAnnotation javaAnnotation) {
        LazyJavaAnnotationDescriptor lazyJavaAnnotationDescriptor = LazyJavaAnnotationDescriptorKt.resolveAnnotation(this.c, javaAnnotation);
        if (lazyJavaAnnotationDescriptor == null) {
            return null;
        }
        LazyJavaAnnotationDescriptor descriptor2 = lazyJavaAnnotationDescriptor;
        return this.factory.createAnnotationValue(descriptor2);
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantValue<?> resolveFromArray(Name argumentName, List<? extends JavaAnnotationArgument> elements) {
        void destination;
        void $receiver;
        void $receiver2;
        if (this.getType().isError()) {
            return null;
        }
        ValueParameterDescriptor valueParameterDescriptor = DescriptorResolverUtils.getAnnotationParameterByName(argumentName, this.getAnnotationClass());
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor valueParameter = valueParameterDescriptor;
        Iterable iterable = elements;
        void var5_5 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void argument;
            JavaAnnotationArgument javaAnnotationArgument = (JavaAnnotationArgument)item;
            void var10_10 = destination;
            ConstantValue constantValue = this.resolveAnnotationArgument((JavaAnnotationArgument)argument);
            if (constantValue == null) {
                constantValue = this.factory.createNullValue();
            }
            ConstantValue constantValue2 = constantValue;
            var10_10.add(constantValue2);
        }
        List values = (List)destination;
        JetType jetType = valueParameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"valueParameter.getType()");
        return this.factory.createArrayValue(values, jetType);
    }

    private final ConstantValue<?> resolveFromEnumValue(JavaField element) {
        if (element == null || !element.isEnumEntry()) {
            return null;
        }
        JavaClass containingJavaClass = element.getContainingClass();
        LazyJavaClassResolver lazyJavaClassResolver = this.c.getJavaClassResolver();
        JavaClass javaClass = containingJavaClass;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaClass, (String)"containingJavaClass");
        ClassDescriptor classDescriptor = lazyJavaClassResolver.resolveClass(javaClass);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor enumClass = classDescriptor;
        JetScope jetScope = enumClass.getUnsubstitutedInnerClassesScope();
        Name name = element.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"element.getName()");
        ClassifierDescriptor classifier2 = jetScope.getClassifier(name);
        if (!(classifier2 instanceof ClassDescriptor)) {
            return null;
        }
        return this.factory.createEnumValue((ClassDescriptor)classifier2);
    }

    private final ConstantValue<?> resolveFromJavaClassObjectType(JavaType javaType) {
        JetType type2 = TypeUtils.makeNotNullable(this.c.getTypeResolver().transformJavaType(javaType, LazyJavaTypeResolverKt.toAttributes$default(TypeUsage.MEMBER_SIGNATURE_INVARIANT, false, false, null, 6)));
        ClassDescriptor classDescriptor = DescriptorUtilsKt.resolveTopLevelClass(this.c.getModule(), new FqName("java.lang.Class"), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor jlClass = classDescriptor;
        List arguments2 = CollectionsKt.listOf((Object)new TypeProjectionImpl(type2));
        AbstractLazyType javaClassObjectType2 = new AbstractLazyType(jlClass, arguments2, this.c.getStorageManager()){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ ClassDescriptor $jlClass;
            final /* synthetic */ List $arguments;

            static {
                $kotlinClass = Reflection.createKotlinClass(resolveFromJavaClassObjectType.javaClassObjectType.1.class);
            }

            @NotNull
            protected TypeConstructor computeTypeConstructor() {
                return this.$jlClass.getTypeConstructor();
            }

            @NotNull
            protected List<TypeProjectionImpl> computeArguments() {
                return this.$arguments;
            }

            @NotNull
            protected JetScope computeMemberScope() {
                return this.$jlClass.getMemberScope(this.$arguments);
            }
            {
                this.$jlClass = $captured_local_variable$0;
                this.$arguments = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        return this.factory.createKClassValue(javaClassObjectType2);
    }

    @NotNull
    public String toString() {
        return DescriptorRenderer$$TImpl.renderAnnotation$default(DescriptorRenderer.Companion.getFQ_NAMES_IN_TYPES(), this, null, 2);
    }

    @NotNull
    public final JavaAnnotation getJavaAnnotation() {
        return this.javaAnnotation;
    }

    public LazyJavaAnnotationDescriptor(@NotNull LazyJavaResolverContext c, @NotNull JavaAnnotation javaAnnotation) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)javaAnnotation, (String)"javaAnnotation");
        this.c = c;
        this.javaAnnotation = javaAnnotation;
        this.fqName = this.c.getStorageManager().createNullableLazyValue((Function0)new Function0<FqName>(this){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;

            @Nullable
            public final FqName invoke() {
                ClassId classId = this.this$0.getJavaAnnotation().getClassId();
                return classId != null ? classId.asSingleFqName() : null;
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                super(0);
            }
        });
        this.type = this.c.getStorageManager().createLazyValue((Function0)new Function0<JetType>(this){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;

            @NotNull
            public final JetType invoke() {
                ClassDescriptor annotationClass;
                Annotated annotated;
                FqName fqName2 = (FqName)LazyJavaAnnotationDescriptor.access$getFqName$3(this.this$0).invoke();
                if (fqName2 == null) {
                    return ErrorUtils.createErrorType("No fqName: " + this.this$0.getJavaAnnotation());
                }
                FqName fqName3 = fqName2;
                ClassDescriptor classDescriptor = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName3);
                if (classDescriptor == null) {
                    JavaClass javaClass = this.this$0.getJavaAnnotation().resolve();
                    if (javaClass != null) {
                        JavaClass $receiver = javaClass;
                        JavaClass javaClass2 = $receiver;
                        ModuleClassResolver moduleClassResolver = LazyJavaAnnotationDescriptor.access$getC$4(this.this$0).getComponents().getModuleClassResolver();
                        JavaClass javaClass3 = javaClass2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)javaClass3, (String)"javaClass");
                        classDescriptor = moduleClassResolver.resolveClass(javaClass3);
                    } else {
                        classDescriptor = null;
                    }
                }
                if ((annotated = (annotationClass = classDescriptor)) == null || (annotated = annotated.getDefaultType()) == null) {
                    annotated = ErrorUtils.createErrorType(fqName3.asString());
                }
                return annotated;
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                super(0);
            }
        });
        this.source = this.c.getComponents().getSourceElementFactory().source(this.javaAnnotation);
        this.factory = new ConstantValueFactory(this.c.getModule().getBuiltIns());
        this.allValueArguments = this.c.getStorageManager().createLazyValue((Function0)new Function0<Map<ValueParameterDescriptor, ? extends ConstantValue<?>>>(this){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;

            @NotNull
            public final Map<ValueParameterDescriptor, ConstantValue<?>> invoke() {
                return LazyJavaAnnotationDescriptor.access$computeValueArguments$2(this.this$0);
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                super(0);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ Map<ValueParameterDescriptor, ConstantValue<?>> access$computeValueArguments$2(LazyJavaAnnotationDescriptor $this) {
        return $this.computeValueArguments();
    }

    @NotNull
    public static final /* synthetic */ NullableLazyValue<FqName> access$getFqName$3(LazyJavaAnnotationDescriptor $this) {
        return $this.fqName;
    }

    @NotNull
    public static final /* synthetic */ LazyJavaResolverContext access$getC$4(LazyJavaAnnotationDescriptor $this) {
        return $this.c;
    }
}

