/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.VariableDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueParameterDescriptorImpl
extends VariableDescriptorImpl
implements ValueParameterDescriptor {
    private final boolean declaresDefaultValue;
    private final JetType varargElementType;
    private final int index;
    private final ValueParameterDescriptor original;

    public ValueParameterDescriptorImpl(@NotNull CallableDescriptor containingDeclaration, @Nullable ValueParameterDescriptor original, int index, @NotNull Annotations annotations2, @NotNull Name name, @NotNull JetType outType, boolean declaresDefaultValue, @Nullable JetType varargElementType, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations2, name, outType, source);
        this.original = original == null ? this : original;
        this.index = index;
        this.declaresDefaultValue = declaresDefaultValue;
        this.varargElementType = varargElementType;
    }

    @Override
    @NotNull
    public CallableDescriptor getContainingDeclaration() {
        CallableDescriptor callableDescriptor = (CallableDescriptor)super.getContainingDeclaration();
        if (callableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "getContainingDeclaration"));
        }
        return callableDescriptor;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean declaresDefaultValue() {
        return this.declaresDefaultValue && ((CallableMemberDescriptor)this.getContainingDeclaration()).getKind().isReal();
    }

    @Override
    @Nullable
    public JetType getVarargElementType() {
        return this.varargElementType;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor getOriginal() {
        ValueParameterDescriptor valueParameterDescriptor = this.original == this ? this : this.original.getOriginal();
        if (valueParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "getOriginal"));
        }
        return valueParameterDescriptor;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "substitute"));
        }
        if (substitutor2.isEmpty()) {
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = this;
            if (valueParameterDescriptorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "substitute"));
            }
            return valueParameterDescriptorImpl;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return visitor2.visitValueParameterDescriptor(this, data2);
    }

    @Override
    public boolean isVar() {
        return false;
    }

    @Override
    @Nullable
    public ConstantValue<?> getCompileTimeInitializer() {
        return null;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor copy(@NotNull CallableDescriptor newOwner, @NotNull Name newName) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(newOwner, null, this.index, this.getAnnotations(), newName, this.getType(), this.declaresDefaultValue(), this.varargElementType, SourceElement.NO_SOURCE);
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        return valueParameterDescriptorImpl;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = Visibilities.LOCAL;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @NotNull
    public Collection<? extends ValueParameterDescriptor> getOverriddenDescriptors() {
        List list = KotlinPackage.map(this.getContainingDeclaration().getOverriddenDescriptors(), (Function1)new Function1<CallableDescriptor, ValueParameterDescriptor>(){

            public ValueParameterDescriptor invoke(CallableDescriptor descriptor2) {
                return descriptor2.getValueParameters().get(ValueParameterDescriptorImpl.this.getIndex());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ValueParameterDescriptorImpl", "getOverriddenDescriptors"));
        }
        return list;
    }
}

