/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typeUtil;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.DelegatingType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypesPackage;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.JetTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeNullability;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilPackage;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilPackage__TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.UtilsPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TypeUtilPackage__TypeUtilsKt {
    @NotNull
    public static final TypeNullability nullability(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return TypesPackage.isNullabilityFlexible($receiver) ? TypeNullability.FLEXIBLE : (TypeUtils.isNullableType($receiver) ? TypeNullability.NULLABLE : TypeNullability.NOT_NULL);
    }

    @NotNull
    public static final JetType makeNullable(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return TypeUtils.makeNullable($receiver);
    }

    @NotNull
    public static final JetType makeNotNullable(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return TypeUtils.makeNotNullable($receiver);
    }

    @NotNull
    public static final Collection<JetType> immediateSupertypes(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Collection collection = TypeUtils.getImmediateSupertypes($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"TypeUtils.getImmediateSupertypes(this)");
        return collection;
    }

    @NotNull
    public static final Collection<JetType> supertypes(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Collection collection = TypeUtils.getAllSupertypes($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"TypeUtils.getAllSupertypes(this)");
        return collection;
    }

    public static final boolean isNothing(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinBuiltIns.isNothing($receiver);
    }

    public static final boolean isUnit(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinBuiltIns.isUnit($receiver);
    }

    public static final boolean isAnyOrNullableAny(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinBuiltIns.isAnyOrNullableAny($receiver);
    }

    public static final boolean isBoolean(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinBuiltIns.isBoolean($receiver);
    }

    public static final boolean isBooleanOrNullableBoolean(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinBuiltIns.isBooleanOrNullableBoolean($receiver);
    }

    @NotNull
    public static final Collection<TypeParameterDescriptor> getContainedTypeParameters(JetType $receiver) {
        Collection destination;
        Object it;
        Iterable $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor declarationDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            return KotlinPackage.listOf((Object)declarationDescriptor);
        }
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility != null) {
            return KotlinPackage.plus(TypeUtilPackage__TypeUtilsKt.getContainedTypeParameters(flexibility.getLowerBound()), (Iterable)TypeUtilPackage__TypeUtilsKt.getContainedTypeParameters(flexibility.getUpperBound()));
        }
        Iterable $receiver3 = $receiver.getArguments();
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList();
        for (Object element : $receiver2) {
            it = (TypeProjection)element;
            if (!(!it.isStarProjection())) continue;
            destination.add(element);
        }
        $receiver3 = (List)destination;
        $receiver2 = $receiver3;
        destination = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
        for (Object item : $receiver2) {
            it = (TypeProjection)item;
            Collection collection2 = destination;
            JetType jetType = it.getType();
            collection2.add(jetType);
        }
        $receiver3 = (List)destination;
        $receiver2 = $receiver3;
        destination = new ArrayList();
        for (Object element : $receiver2) {
            it = (JetType)element;
            Iterable list = TypeUtilPackage__TypeUtilsKt.getContainedTypeParameters((JetType)it);
            KotlinPackage.addAll((Collection)destination, (Iterable)list);
        }
        return (List)destination;
    }

    @NotNull
    public static final Collection<TypeParameterDescriptor> getCapturedTypeParameters(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        LinkedHashSet<TypeParameterDescriptor> result = new LinkedHashSet<TypeParameterDescriptor>();
        DeclarationDescriptor containingDeclaration = $receiver.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            result.addAll(TypeUtilPackage__TypeUtilsKt.getContainedTypeParameters(((ClassDescriptor)containingDeclaration).getDefaultType()));
        } else if (containingDeclaration instanceof CallableDescriptor) {
            Collection collection = ((CallableDescriptor)containingDeclaration).getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"containingDeclaration.getTypeParameters()");
            result.addAll(collection);
        }
        if (containingDeclaration != null) {
            result.addAll(TypeUtilPackage.getCapturedTypeParameters(containingDeclaration));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<TypeConstructor> getContainedAndCapturedTypeParameterConstructors(JetType $receiver) {
        void destination;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = $receiver.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = TypeUtilPackage.getCapturedTypeParameters((DeclarationDescriptor)object)) == null) {
            object = KotlinPackage.emptyList();
        }
        Object capturedTypeParameters = object;
        List typeParameters = KotlinPackage.plus(TypeUtilPackage__TypeUtilsKt.getContainedTypeParameters($receiver), (Iterable)((Iterable)capturedTypeParameters));
        Iterable $receiver3 = typeParameters;
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
        for (Object item : $receiver2) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item;
            void var9_9 = destination;
            TypeConstructor typeConstructor2 = it.getTypeConstructor();
            var9_9.add(typeConstructor2);
        }
        return UtilsPackage.toReadOnlyList((List)destination);
    }

    public static final boolean isSubtypeOf(JetType $receiver, @NotNull JetType superType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        return JetTypeChecker.DEFAULT.isSubtypeOf($receiver, superType);
    }

    public static final boolean cannotBeReified(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinBuiltIns.isNothingOrNullableNothing($receiver) || TypesPackage.isDynamic($receiver);
    }

    @NotNull
    public static final TypeProjection substitute(TypeProjection $receiver, @NotNull Function1<? super JetType, ? extends JetType> doSubstitute) {
        TypeProjection typeProjection;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(doSubstitute, (String)"doSubstitute");
        if ($receiver.isStarProjection()) {
            typeProjection = $receiver;
        } else {
            Variance variance = $receiver.getProjectionKind();
            JetType jetType = $receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"getType()");
            typeProjection = new TypeProjectionImpl(variance, (JetType)doSubstitute.invoke((Object)jetType));
        }
        return typeProjection;
    }

    @NotNull
    public static final JetType replaceAnnotations(JetType $receiver, @NotNull Annotations newAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)newAnnotations, (String)"newAnnotations");
        if (newAnnotations.isEmpty()) {
            return $receiver;
        }
        return new DelegatingType($receiver, newAnnotations){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ JetType receiver$0;
            final /* synthetic */ Annotations $newAnnotations;

            static {
                $kotlinClass = Reflection.createKotlinClass(replaceAnnotations.1.class);
            }

            @NotNull
            protected JetType getDelegate() {
                return this.receiver$0;
            }

            @NotNull
            public Annotations getAnnotations() {
                return this.$newAnnotations;
            }
            {
                this.receiver$0 = $receiver;
                this.$newAnnotations = $captured_local_variable$1;
            }
        };
    }

    public static final boolean equalTypesOrNulls(JetTypeChecker $receiver, @Nullable JetType type1, @Nullable JetType type2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return $receiver.equalTypes(type1, type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getNestedArguments(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ArrayList<TypeProjection> result = new ArrayList<TypeProjection>();
        ArrayDeque<TypeProjection> stack = new ArrayDeque<TypeProjection>();
        stack.push(new TypeProjectionImpl($receiver));
        while (!stack.isEmpty()) {
            void $receiver2;
            TypeProjection typeProjection = (TypeProjection)stack.pop();
            if (typeProjection.isStarProjection()) continue;
            result.add(typeProjection);
            Iterable iterable = typeProjection.getType().getArguments();
            for (Object element : $receiver2) {
                TypeProjection it = (TypeProjection)element;
                stack.add(it);
            }
        }
        return result;
    }

    public static final boolean containsError(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ErrorUtils.containsErrorType($receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> defaultProjections(List<? extends JetType> $receiver) {
        void var3_3;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable $receiver3 = $receiver;
        Iterable iterable = $receiver3;
        Collection destination = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
        for (Object item : $receiver2) {
            void it;
            JetType jetType = (JetType)item;
            Collection collection = destination;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl((JetType)it);
            collection.add(typeProjectionImpl);
        }
        return (List)var3_3;
    }

    public static final boolean isDefaultBound(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinBuiltIns.isDefaultBound(TypesPackage.getSupertypeRepresentative($receiver));
    }

    @NotNull
    public static final TypeProjection createProjection(@NotNull JetType type2, @NotNull Variance projectionKind, @Nullable TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)((Object)projectionKind), (String)"projectionKind");
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        return new TypeProjectionImpl(Intrinsics.areEqual((Object)((Object)(typeParameterDescriptor2 != null ? typeParameterDescriptor2.getVariance() : null)), (Object)((Object)projectionKind)) ? Variance.INVARIANT : projectionKind, type2);
    }
}

