/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckerProcedureCallbacksImpl;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckingProcedure;
import org.jetbrains.annotations.NotNull;

public class JetTypeChecker {
    public static final JetTypeChecker DEFAULT = new JetTypeChecker(new TypeCheckingProcedure(new TypeCheckerProcedureCallbacksImpl()));
    public static final JetTypeChecker ERROR_TYPES_ARE_EQUAL_TO_ANYTHING = new JetTypeChecker(new TypeCheckingProcedure(new TypeCheckerProcedureCallbacksImpl(){

        @Override
        public boolean assertEqualTypes(@NotNull JetType a, @NotNull JetType b, @NotNull TypeCheckingProcedure typeCheckingProcedure2) {
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker$1", "assertEqualTypes"));
            }
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker$1", "assertEqualTypes"));
            }
            if (typeCheckingProcedure2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCheckingProcedure", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker$1", "assertEqualTypes"));
            }
            return a.isError() || b.isError() || super.assertEqualTypes(a, b, typeCheckingProcedure2);
        }
    }));
    public static final JetTypeChecker FLEXIBLE_UNEQUAL_TO_INFLEXIBLE = new JetTypeChecker(new TypeCheckingProcedure(new TypeCheckerProcedureCallbacksImpl()){

        @Override
        protected boolean heterogeneousEquivalence(JetType inflexibleType, JetType flexibleType) {
            return false;
        }
    });
    private final TypeCheckingProcedure procedure;

    @NotNull
    public static JetTypeChecker withAxioms(final @NotNull TypeConstructorEquality equalityAxioms) {
        if (equalityAxioms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equalityAxioms", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker", "withAxioms"));
        }
        JetTypeChecker jetTypeChecker = new JetTypeChecker(new TypeCheckingProcedure(new TypeCheckerProcedureCallbacksImpl(){

            @Override
            public boolean assertEqualTypeConstructors(@NotNull TypeConstructor constructor1, @NotNull TypeConstructor constructor2) {
                if (constructor1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor1", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker$3", "assertEqualTypeConstructors"));
                }
                if (constructor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor2", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker$3", "assertEqualTypeConstructors"));
                }
                return constructor1.equals(constructor2) || equalityAxioms.equals(constructor1, constructor2);
            }
        }));
        if (jetTypeChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker", "withAxioms"));
        }
        return jetTypeChecker;
    }

    private JetTypeChecker(@NotNull TypeCheckingProcedure procedure) {
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker", "<init>"));
        }
        this.procedure = procedure;
    }

    public boolean isSubtypeOf(@NotNull JetType subtype, @NotNull JetType supertype) {
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker", "isSubtypeOf"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker", "isSubtypeOf"));
        }
        return this.procedure.isSubtypeOf(subtype, supertype);
    }

    public boolean equalTypes(@NotNull JetType a, @NotNull JetType b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker", "equalTypes"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "kotlin/reflect/jvm/internal/impl/types/checker/JetTypeChecker", "equalTypes"));
        }
        return this.procedure.equalTypes(a, b);
    }

    public static interface TypeConstructorEquality {
        public boolean equals(@NotNull TypeConstructor var1, @NotNull TypeConstructor var2);
    }
}

