/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class WrappedValues {
    private static final Object NULL_VALUE = new Object(){

        public String toString() {
            return "NULL_VALUE";
        }
    };

    private WrappedValues() {
    }

    @Nullable
    public static <V> V unescapeNull(@NotNull Object value) {
        if (value == NULL_VALUE) {
            return null;
        }
        return (V)value;
    }

    @NotNull
    public static <V> Object escapeNull(@Nullable V value) {
        if (value == null) {
            return NULL_VALUE;
        }
        return value;
    }

    @NotNull
    public static Object escapeThrowable(@NotNull Throwable throwable) {
        return new ThrowableWrapper(throwable);
    }

    @Nullable
    public static <V> V unescapeExceptionOrNull(@NotNull Object value) {
        return WrappedValues.unescapeNull(WrappedValues.unescapeThrowable(value));
    }

    @Nullable
    public static <V> V unescapeThrowable(@Nullable Object value) {
        if (value instanceof ThrowableWrapper) {
            throw UtilsPackage.rethrow(((ThrowableWrapper)value).getThrowable());
        }
        return (V)value;
    }

    private static final class ThrowableWrapper {
        private final Throwable throwable;

        private ThrowableWrapper(@NotNull Throwable throwable) {
            this.throwable = throwable;
        }

        @NotNull
        public Throwable getThrowable() {
            return this.throwable;
        }

        public String toString() {
            return this.throwable.toString();
        }
    }
}

