/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.TypeConstructor;

public abstract class AbstractClassTypeConstructor
implements TypeConstructor {
    public final int hashCode() {
        return AbstractClassTypeConstructor.hashCode(this);
    }

    public boolean equals(Object obj) {
        return AbstractClassTypeConstructor.equals(this, obj);
    }

    public static boolean equals(@NotNull TypeConstructor me, Object other) {
        if (!(other instanceof TypeConstructor)) {
            return false;
        }
        ClassifierDescriptor myDescriptor = me.getDeclarationDescriptor();
        ClassifierDescriptor otherDescriptor = ((TypeConstructor)other).getDeclarationDescriptor();
        if (myDescriptor != null && !AbstractClassTypeConstructor.hasMeaningfulFqName(myDescriptor) || otherDescriptor != null && !AbstractClassTypeConstructor.hasMeaningfulFqName(otherDescriptor)) {
            return me == other;
        }
        if (myDescriptor == otherDescriptor) {
            return true;
        }
        if (myDescriptor instanceof ClassDescriptor && otherDescriptor instanceof ClassDescriptor) {
            FqNameUnsafe otherFqName = DescriptorUtils.getFqName(otherDescriptor);
            FqNameUnsafe myFqName = DescriptorUtils.getFqName(myDescriptor);
            return myFqName.equals(otherFqName);
        }
        return false;
    }

    public static int hashCode(@NotNull TypeConstructor me) {
        ClassifierDescriptor descriptor2 = me.getDeclarationDescriptor();
        if (descriptor2 instanceof ClassDescriptor && AbstractClassTypeConstructor.hasMeaningfulFqName(descriptor2)) {
            return DescriptorUtils.getFqName(descriptor2).hashCode();
        }
        return System.identityHashCode(me);
    }

    private static boolean hasMeaningfulFqName(@NotNull ClassifierDescriptor descriptor2) {
        return !ErrorUtils.isError(descriptor2) && !DescriptorUtils.isLocal(descriptor2);
    }
}

