/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.kotlin.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.JetScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.StaticScopeForKotlinClass;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorImpl;
import org.jetbrains.kotlin.utils.Printer;

public class EnumEntrySyntheticClassDescriptor
extends ClassDescriptorBase {
    private final TypeConstructor typeConstructor;
    private final ConstructorDescriptor primaryConstructor;
    private final JetScope scope;
    private final JetScope staticScope = new StaticScopeForKotlinClass(this);
    private final NotNullLazyValue<Collection<Name>> enumMemberNames;

    @NotNull
    public static EnumEntrySyntheticClassDescriptor create(@NotNull StorageManager storageManager, @NotNull ClassDescriptor enumClass, @NotNull Name name, @NotNull NotNullLazyValue<Collection<Name>> enumMemberNames2, @NotNull SourceElement source) {
        JetType enumType = enumClass.getDefaultType();
        return new EnumEntrySyntheticClassDescriptor(storageManager, enumClass, enumType, name, enumMemberNames2, source);
    }

    private EnumEntrySyntheticClassDescriptor(@NotNull StorageManager storageManager, @NotNull ClassDescriptor containingClass, @NotNull JetType supertype, @NotNull Name name, @NotNull NotNullLazyValue<Collection<Name>> enumMemberNames2, @NotNull SourceElement source) {
        super(storageManager, containingClass, name, source);
        assert (containingClass.getKind() == ClassKind.ENUM_CLASS);
        this.typeConstructor = TypeConstructorImpl.createForClass(this, this.getAnnotations(), true, "enum entry", Collections.emptyList(), Collections.singleton(supertype));
        this.scope = new EnumEntryScope(storageManager);
        this.enumMemberNames = enumMemberNames2;
        ConstructorDescriptorImpl primaryConstructor2 = DescriptorFactory.createPrimaryConstructorForObject(this, source);
        primaryConstructor2.setReturnType(this.getDefaultType());
        this.primaryConstructor = primaryConstructor2;
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberLookup() {
        return this.scope;
    }

    @Override
    @NotNull
    public JetScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        return Collections.singleton(this.primaryConstructor);
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    @Nullable
    public ClassDescriptor getCompanionObjectDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return ClassKind.ENUM_ENTRY;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return Modality.FINAL;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return Visibilities.PUBLIC;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    @Override
    public boolean isCompanionObject() {
        return false;
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return Annotations.EMPTY;
    }

    public String toString() {
        return "enum entry " + this.getName();
    }

    private class EnumEntryScope
    extends JetScopeImpl {
        private final MemoizedFunctionToNotNull<Name, Collection<FunctionDescriptor>> functions;
        private final MemoizedFunctionToNotNull<Name, Collection<PropertyDescriptor>> properties;
        private final NotNullLazyValue<Collection<DeclarationDescriptor>> allDescriptors;

        public EnumEntryScope(StorageManager storageManager) {
            this.functions = storageManager.createMemoizedFunction(new Function1<Name, Collection<FunctionDescriptor>>(){

                public Collection<FunctionDescriptor> invoke(Name name) {
                    return EnumEntryScope.this.computeFunctions(name);
                }
            });
            this.properties = storageManager.createMemoizedFunction(new Function1<Name, Collection<PropertyDescriptor>>(){

                public Collection<PropertyDescriptor> invoke(Name name) {
                    return EnumEntryScope.this.computeProperties(name);
                }
            });
            this.allDescriptors = storageManager.createLazyValue(new Function0<Collection<DeclarationDescriptor>>(){

                public Collection<DeclarationDescriptor> invoke() {
                    return EnumEntryScope.this.computeAllDeclarations();
                }
            });
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
            return (Collection)this.properties.invoke(name);
        }

        @NotNull
        private Collection<PropertyDescriptor> computeProperties(@NotNull Name name) {
            return this.resolveFakeOverrides(name, this.getSupertypeScope().getProperties(name));
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
            return (Collection)this.functions.invoke(name);
        }

        @NotNull
        private Collection<FunctionDescriptor> computeFunctions(@NotNull Name name) {
            return this.resolveFakeOverrides(name, this.getSupertypeScope().getFunctions(name));
        }

        @NotNull
        private JetScope getSupertypeScope() {
            Collection<JetType> supertype = EnumEntrySyntheticClassDescriptor.this.getTypeConstructor().getSupertypes();
            assert (supertype.size() == 1) : "Enum entry and its companion object both should have exactly one supertype: " + supertype;
            return supertype.iterator().next().getMemberScope();
        }

        @NotNull
        private <D extends CallableMemberDescriptor> Collection<D> resolveFakeOverrides(@NotNull Name name, @NotNull Collection<D> fromSupertypes) {
            final HashSet result = new HashSet();
            OverridingUtil.generateOverridesInFunctionGroup(name, fromSupertypes, Collections.emptySet(), EnumEntrySyntheticClassDescriptor.this, new OverridingUtil.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, null);
                    result.add(fakeOverride);
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                }
            });
            return result;
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            return EnumEntrySyntheticClassDescriptor.this;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, ? extends Boolean> nameFilter) {
            return (Collection)this.allDescriptors.invoke();
        }

        @NotNull
        private Collection<DeclarationDescriptor> computeAllDeclarations() {
            HashSet<DeclarationDescriptor> result = new HashSet<DeclarationDescriptor>();
            for (Name name : (Collection)EnumEntrySyntheticClassDescriptor.this.enumMemberNames.invoke()) {
                result.addAll(this.getFunctions(name));
                result.addAll(this.getProperties(name));
            }
            return result;
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            p.println("enum entry scope for " + EnumEntrySyntheticClassDescriptor.this);
        }
    }
}

