/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.FunctionExpressionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.FilteringScope;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.LazyType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class DescriptorUtils {
    public static final Name ENUM_VALUES = Name.identifier("values");
    public static final Name ENUM_VALUE_OF = Name.identifier("valueOf");

    private DescriptorUtils() {
    }

    @Nullable
    public static ReceiverParameterDescriptor getDispatchReceiverParameterIfNeeded(@NotNull DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            return classDescriptor.getThisAsReceiverParameter();
        }
        if (containingDeclaration instanceof ScriptDescriptor) {
            ScriptDescriptor scriptDescriptor = (ScriptDescriptor)containingDeclaration;
            return scriptDescriptor.getThisAsReceiverParameter();
        }
        return ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
    }

    public static boolean isLocal(@NotNull DeclarationDescriptor descriptor2) {
        DeclarationDescriptor current = descriptor2;
        while (current instanceof MemberDescriptor) {
            if (DescriptorUtils.isAnonymousObject(current) || ((DeclarationDescriptorWithVisibility)current).getVisibility() == Visibilities.LOCAL) {
                return true;
            }
            current = current.getContainingDeclaration();
        }
        return false;
    }

    @NotNull
    public static FqNameUnsafe getFqName(@NotNull DeclarationDescriptor descriptor2) {
        FqName safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor2);
        return safe != null ? safe.toUnsafe() : DescriptorUtils.getFqNameUnsafe(descriptor2);
    }

    @NotNull
    public static FqName getFqNameSafe(@NotNull DeclarationDescriptor descriptor2) {
        FqName safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor2);
        return safe != null ? safe : DescriptorUtils.getFqNameUnsafe(descriptor2).toSafe();
    }

    @Nullable
    private static FqName getFqNameSafeIfPossible(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ModuleDescriptor || ErrorUtils.isError(descriptor2)) {
            return FqName.ROOT;
        }
        if (descriptor2 instanceof PackageViewDescriptor) {
            return ((PackageViewDescriptor)descriptor2).getFqName();
        }
        if (descriptor2 instanceof PackageFragmentDescriptor) {
            return ((PackageFragmentDescriptor)descriptor2).getFqName();
        }
        return null;
    }

    @NotNull
    private static FqNameUnsafe getFqNameUnsafe(@NotNull DeclarationDescriptor descriptor2) {
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        assert (containingDeclaration != null) : "Not package/module descriptor doesn't have containing declaration: " + descriptor2;
        return DescriptorUtils.getFqName(containingDeclaration).child(descriptor2.getName());
    }

    @NotNull
    public static FqName getFqNameFromTopLevelClass(@NotNull DeclarationDescriptor descriptor2) {
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        Name name = descriptor2.getName();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return FqName.topLevel(name);
        }
        return DescriptorUtils.getFqNameFromTopLevelClass(containingDeclaration).child(name);
    }

    public static boolean isTopLevelDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        return descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    public static boolean isExtension(@NotNull CallableDescriptor descriptor2) {
        return descriptor2.getExtensionReceiverParameter() != null;
    }

    public static boolean isOverride(@NotNull CallableMemberDescriptor descriptor2) {
        return !descriptor2.getOverriddenDescriptors().isEmpty();
    }

    public static boolean isStaticDeclaration(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 instanceof ConstructorDescriptor) {
            return false;
        }
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        return container instanceof PackageFragmentDescriptor || container instanceof ClassDescriptor && descriptor2.getDispatchReceiverParameter() == null;
    }

    public static boolean areInSameModule(@NotNull DeclarationDescriptor first, @NotNull DeclarationDescriptor second) {
        return DescriptorUtils.getContainingModule(first).equals(DescriptorUtils.getContainingModule(second));
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor2, @NotNull Class<D> aClass) {
        return DescriptorUtils.getParentOfType(descriptor2, aClass, true);
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor2, @NotNull Class<D> aClass, boolean strict) {
        if (descriptor2 == null) {
            return null;
        }
        if (strict) {
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        while (descriptor2 != null) {
            if (aClass.isInstance(descriptor2)) {
                return (D)descriptor2;
            }
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return null;
    }

    @NotNull
    public static ModuleDescriptor getContainingModule(@NotNull DeclarationDescriptor descriptor2) {
        ModuleDescriptor module = DescriptorUtils.getContainingModuleOrNull(descriptor2);
        assert (module != null) : "Descriptor without a containing module: " + descriptor2;
        return module;
    }

    @Nullable
    public static ModuleDescriptor getContainingModuleOrNull(@NotNull DeclarationDescriptor descriptor2) {
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getParentOfType(descriptor2, ModuleDescriptor.class, false);
        if (moduleDescriptor != null) {
            return moduleDescriptor;
        }
        PackageViewDescriptor packageViewDescriptor = DescriptorUtils.getParentOfType(descriptor2, PackageViewDescriptor.class, false);
        if (packageViewDescriptor != null) {
            return packageViewDescriptor.getModule();
        }
        return null;
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull DeclarationDescriptor descriptor2) {
        for (DeclarationDescriptor containing = descriptor2.getContainingDeclaration(); containing != null; containing = containing.getContainingDeclaration()) {
            if (!(containing instanceof ClassDescriptor) || DescriptorUtils.isCompanionObject(containing)) continue;
            return (ClassDescriptor)containing;
        }
        return null;
    }

    public static boolean isAncestor(@Nullable DeclarationDescriptor ancestor, @NotNull DeclarationDescriptor declarationDescriptor, boolean strict) {
        DeclarationDescriptor descriptor2;
        if (ancestor == null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = descriptor2 = strict ? declarationDescriptor.getContainingDeclaration() : declarationDescriptor;
        while (descriptor2 != null) {
            if (ancestor == descriptor2) {
                return true;
            }
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return false;
    }

    public static boolean isSubclass(@NotNull ClassDescriptor subClass, @NotNull ClassDescriptor superClass) {
        return DescriptorUtils.isSubtypeOfClass(subClass.getDefaultType(), superClass.getOriginal());
    }

    private static boolean isSubtypeOfClass(@NotNull JetType type2, @NotNull DeclarationDescriptor superClass) {
        DeclarationDescriptor originalDescriptor;
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (descriptor2 != null && (originalDescriptor = descriptor2.getOriginal()) instanceof ClassifierDescriptor && superClass instanceof ClassifierDescriptor && ((ClassifierDescriptor)superClass).getTypeConstructor().equals(((ClassifierDescriptor)originalDescriptor).getTypeConstructor())) {
            return true;
        }
        for (JetType superType : type2.getConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSubtypeOfClass(superType, superClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFunctionLiteral(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof AnonymousFunctionDescriptor;
    }

    public static boolean isLocalFunction(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 != null && descriptor2.getClass() == SimpleFunctionDescriptorImpl.class) {
            return ((SimpleFunctionDescriptorImpl)descriptor2).getVisibility() == Visibilities.LOCAL;
        }
        return false;
    }

    public static boolean isFunctionExpression(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof FunctionExpressionDescriptor;
    }

    public static boolean isCompanionObject(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.OBJECT) && ((ClassDescriptor)descriptor2).isCompanionObject();
    }

    public static boolean isAnonymousObject(@NotNull DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isClass(descriptor2) && descriptor2.getName().equals(SpecialNames.NO_NAME_PROVIDED);
    }

    public static boolean isNonCompanionObject(@NotNull DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.OBJECT) && !((ClassDescriptor)descriptor2).isCompanionObject();
    }

    public static boolean isObject(@NotNull DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.OBJECT);
    }

    public static boolean isEnumEntry(@NotNull DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.ENUM_ENTRY);
    }

    public static boolean isSingleton(@Nullable DeclarationDescriptor classifier2) {
        if (classifier2 instanceof ClassDescriptor) {
            ClassDescriptor clazz = (ClassDescriptor)classifier2;
            return clazz.getKind().isSingleton();
        }
        return false;
    }

    public static boolean isEnumClass(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.ENUM_CLASS);
    }

    public static boolean isAnnotationClass(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.ANNOTATION_CLASS);
    }

    public static boolean isTrait(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.INTERFACE);
    }

    public static boolean isClass(@Nullable DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.CLASS);
    }

    private static boolean isKindOf(@Nullable DeclarationDescriptor descriptor2, @NotNull ClassKind classKind) {
        return descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == classKind;
    }

    @NotNull
    public static List<ClassDescriptor> getSuperclassDescriptors(@NotNull ClassDescriptor classDescriptor) {
        Collection<JetType> superclassTypes = classDescriptor.getTypeConstructor().getSupertypes();
        ArrayList<ClassDescriptor> superClassDescriptors = new ArrayList<ClassDescriptor>();
        for (JetType type2 : superclassTypes) {
            ClassDescriptor result = DescriptorUtils.getClassDescriptorForType(type2);
            if (KotlinBuiltIns.isAny(result)) continue;
            superClassDescriptors.add(result);
        }
        return superClassDescriptors;
    }

    @NotNull
    public static JetType getSuperClassType(@NotNull ClassDescriptor classDescriptor) {
        Collection<JetType> superclassTypes = classDescriptor.getTypeConstructor().getSupertypes();
        for (JetType type2 : superclassTypes) {
            ClassDescriptor superClassDescriptor = DescriptorUtils.getClassDescriptorForType(type2);
            if (superClassDescriptor.getKind() == ClassKind.INTERFACE) continue;
            return type2;
        }
        return DescriptorUtilPackage.getBuiltIns(classDescriptor).getAnyType();
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForType(@NotNull JetType type2) {
        return DescriptorUtils.getClassDescriptorForTypeConstructor(type2.getConstructor());
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        ClassifierDescriptor descriptor2 = typeConstructor2.getDeclarationDescriptor();
        assert (descriptor2 instanceof ClassDescriptor) : "Classifier descriptor of a type should be of type ClassDescriptor: " + typeConstructor2;
        return (ClassDescriptor)descriptor2;
    }

    @NotNull
    public static Visibility getDefaultConstructorVisibility(@NotNull ClassDescriptor classDescriptor) {
        ClassKind classKind = classDescriptor.getKind();
        if (classKind == ClassKind.ENUM_CLASS || classKind.isSingleton()) {
            return Visibilities.PRIVATE;
        }
        if (DescriptorUtils.isAnonymousObject(classDescriptor)) {
            return Visibilities.INTERNAL;
        }
        assert (classKind == ClassKind.CLASS || classKind == ClassKind.INTERFACE || classKind == ClassKind.ANNOTATION_CLASS);
        return Visibilities.PUBLIC;
    }

    @Nullable
    public static ClassDescriptor getInnerClassByName(@NotNull ClassDescriptor classDescriptor, @NotNull String innerClassName) {
        ClassifierDescriptor classifier2 = classDescriptor.getDefaultType().getMemberScope().getClassifier(Name.identifier(innerClassName));
        assert (classifier2 instanceof ClassDescriptor) : "Inner class " + innerClassName + " in " + classDescriptor + " should be instance of ClassDescriptor, but was: " + (classifier2 == null ? "null" : classifier2.getClass());
        return (ClassDescriptor)classifier2;
    }

    @Nullable
    public static JetType getReceiverParameterType(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
        return receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
    }

    public static boolean isStaticNestedClass(@NotNull DeclarationDescriptor descriptor2) {
        DeclarationDescriptor containing = descriptor2.getContainingDeclaration();
        return descriptor2 instanceof ClassDescriptor && containing instanceof ClassDescriptor && !((ClassDescriptor)descriptor2).isInner();
    }

    @NotNull
    public static JetScope getStaticNestedClassesScope(@NotNull ClassDescriptor descriptor2) {
        JetScope innerClassesScope = descriptor2.getUnsubstitutedInnerClassesScope();
        return new FilteringScope(innerClassesScope, (Function1<? super DeclarationDescriptor, ? extends Boolean>)new Function1<DeclarationDescriptor, Boolean>(){

            public Boolean invoke(DeclarationDescriptor descriptor2) {
                return descriptor2 instanceof ClassDescriptor && !((ClassDescriptor)descriptor2).isInner();
            }
        });
    }

    public static boolean isTopLevelOrInnerClass(@NotNull ClassDescriptor descriptor2) {
        DeclarationDescriptor containing = descriptor2.getContainingDeclaration();
        return DescriptorUtils.isTopLevelDeclaration(descriptor2) || containing instanceof ClassDescriptor && DescriptorUtils.isTopLevelOrInnerClass((ClassDescriptor)containing);
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> D unwrapFakeOverride(@NotNull D descriptor2) {
        while (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            Set<? extends CallableMemberDescriptor> overridden = descriptor2.getOverriddenDescriptors();
            if (overridden.isEmpty()) {
                throw new IllegalStateException("Fake override should have at least one overridden descriptor: " + descriptor2);
            }
            descriptor2 = overridden.iterator().next();
        }
        return descriptor2;
    }

    public static boolean shouldRecordInitializerForProperty(@NotNull VariableDescriptor variable, @NotNull JetType type2) {
        if (variable.isVar() || type2.isError()) {
            return false;
        }
        if (type2 instanceof LazyType || type2.isMarkedNullable()) {
            return true;
        }
        KotlinBuiltIns builtIns = DescriptorUtilPackage.getBuiltIns(variable);
        return KotlinBuiltIns.isPrimitiveType(type2) || JetTypeChecker.DEFAULT.equalTypes(builtIns.getStringType(), type2) || JetTypeChecker.DEFAULT.equalTypes(builtIns.getNumber().getDefaultType(), type2) || JetTypeChecker.DEFAULT.equalTypes(builtIns.getAnyType(), type2);
    }

    public static boolean classCanHaveAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        return classDescriptor.getModality() == Modality.ABSTRACT || classDescriptor.getKind() == ClassKind.ENUM_CLASS;
    }

    public static boolean classCanHaveOpenMembers(@NotNull ClassDescriptor classDescriptor) {
        return classDescriptor.getModality() != Modality.FINAL || classDescriptor.getKind() == ClassKind.ENUM_CLASS;
    }

    @NotNull
    public static <D extends CallableDescriptor> Set<D> getAllOverriddenDescriptors(@NotNull D f) {
        LinkedHashSet result = new LinkedHashSet();
        DescriptorUtils.collectAllOverriddenDescriptors(f.getOriginal(), result);
        return result;
    }

    private static <D extends CallableDescriptor> void collectAllOverriddenDescriptors(@NotNull D current, @NotNull Set<D> result) {
        if (result.contains(current)) {
            return;
        }
        Iterator<? extends CallableDescriptor> i$ = current.getOriginal().getOverriddenDescriptors().iterator();
        while (i$.hasNext()) {
            CallableDescriptor callableDescriptor;
            CallableDescriptor descriptor2 = callableDescriptor = i$.next();
            DescriptorUtils.collectAllOverriddenDescriptors(descriptor2, result);
            result.add(descriptor2);
        }
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Set<D> getAllOverriddenDeclarations(@NotNull D memberDescriptor) {
        HashSet<CallableMemberDescriptor> result = new HashSet<CallableMemberDescriptor>();
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            CallableMemberDescriptor.Kind kind = callableMemberDescriptor.getKind();
            if (kind == CallableMemberDescriptor.Kind.DECLARATION) {
                result.add(callableMemberDescriptor);
            } else if (kind != CallableMemberDescriptor.Kind.DELEGATION && kind != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && kind != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                throw new AssertionError((Object)("Unexpected callable kind " + (Object)((Object)kind)));
            }
            result.addAll(DescriptorUtils.getAllOverriddenDeclarations(callableMemberDescriptor));
        }
        return result;
    }

    public static boolean containsReifiedTypeParameterWithName(@NotNull CallableDescriptor descriptor2, @NotNull String name) {
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor2.getTypeParameters()) {
            if (!typeParameterDescriptor.isReified() || !typeParameterDescriptor.getName().asString().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsReifiedTypeParameters(@NotNull CallableDescriptor descriptor2) {
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor2.getTypeParameters()) {
            if (!typeParameterDescriptor.isReified()) continue;
            return true;
        }
        return false;
    }

    public static boolean isSingletonOrAnonymousObject(@NotNull ClassDescriptor classDescriptor) {
        return classDescriptor.getKind().isSingleton() || DescriptorUtils.isAnonymousObject(classDescriptor);
    }

    public static boolean canHaveSecondaryConstructors(@NotNull ClassDescriptor classDescriptor) {
        return !DescriptorUtils.isSingletonOrAnonymousObject(classDescriptor) && !DescriptorUtils.isTrait(classDescriptor);
    }

    public static Set<FqName> getPackagesFqNames(ModuleDescriptor module) {
        Set<FqName> result = DescriptorUtils.getSubPackagesFqNames(module.getPackage(FqName.ROOT));
        result.add(FqName.ROOT);
        return result;
    }

    public static Set<FqName> getSubPackagesFqNames(PackageViewDescriptor packageView) {
        HashSet<FqName> result = new HashSet<FqName>();
        DescriptorUtils.getSubPackagesFqNames(packageView, result);
        return result;
    }

    private static void getSubPackagesFqNames(PackageViewDescriptor packageView, Set<FqName> result) {
        FqName fqName2 = packageView.getFqName();
        if (!fqName2.isRoot()) {
            result.add(fqName2);
        }
        for (DeclarationDescriptor descriptor2 : packageView.getMemberScope().getDescriptors(DescriptorKindFilter.PACKAGES, JetScope.ALL_NAME_FILTER)) {
            if (!(descriptor2 instanceof PackageViewDescriptor)) continue;
            DescriptorUtils.getSubPackagesFqNames((PackageViewDescriptor)descriptor2, result);
        }
    }

    public static boolean isJavaLangClass(ClassDescriptor descriptor2) {
        return "java.lang.Class".equals(DescriptorUtils.getFqName(descriptor2).asString());
    }
}

