/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.pcollections;

import kotlin.reflect.jvm.internal.pcollections.ConsPStack;
import kotlin.reflect.jvm.internal.pcollections.IntTreePMap;
import kotlin.reflect.jvm.internal.pcollections.MapEntry;
import org.jetbrains.annotations.NotNull;

public final class HashPMap<K, V> {
    private static final HashPMap<Object, Object> EMPTY = new HashPMap(IntTreePMap.empty(), 0);
    private final IntTreePMap<ConsPStack<MapEntry<K, V>>> intMap;
    private final int size;

    @NotNull
    public static <K, V> HashPMap<K, V> empty() {
        return EMPTY;
    }

    private HashPMap(IntTreePMap<ConsPStack<MapEntry<K, V>>> intMap, int size) {
        this.intMap = intMap;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(Object key) {
        return HashPMap.keyIndexIn(this.getEntries(key.hashCode()), key) != -1;
    }

    public V get(Object key) {
        ConsPStack<MapEntry<K, V>> entries = this.getEntries(key.hashCode());
        for (MapEntry<K, V> entry : entries) {
            if (!entry.key.equals(key)) continue;
            return entry.value;
        }
        return null;
    }

    @NotNull
    public HashPMap<K, V> plus(K key, V value) {
        ConsPStack<MapEntry<K, V>> entries = this.getEntries(key.hashCode());
        int size0 = entries.size();
        int i = HashPMap.keyIndexIn(entries, key);
        if (i != -1) {
            entries = entries.minus(i);
        }
        entries = entries.plus(new MapEntry<K, V>(key, value));
        return new HashPMap<K, V>(this.intMap.plus(key.hashCode(), entries), this.size - size0 + entries.size());
    }

    @NotNull
    public HashPMap<K, V> minus(Object key) {
        ConsPStack<MapEntry<K, V>> entries = this.getEntries(key.hashCode());
        int i = HashPMap.keyIndexIn(entries, key);
        if (i == -1) {
            return this;
        }
        if ((entries = entries.minus(i)).size() == 0) {
            return new HashPMap<K, V>(this.intMap.minus(key.hashCode()), this.size - 1);
        }
        return new HashPMap<K, V>(this.intMap.plus(key.hashCode(), entries), this.size - 1);
    }

    private ConsPStack<MapEntry<K, V>> getEntries(int hash) {
        ConsPStack<MapEntry<K, V>> entries = this.intMap.get(hash);
        if (entries == null) {
            return ConsPStack.empty();
        }
        return entries;
    }

    private static <K, V> int keyIndexIn(ConsPStack<MapEntry<K, V>> entries, Object key) {
        int i = 0;
        for (MapEntry<K, V> entry : entries) {
            if (entry.key.equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

