/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorUtilPackage$DescriptorUtils$b66f84e5 {
    @NotNull
    public static final ClassDescriptor getClassObjectReferenceTarget(@JetValueParameter(name="$receiver") ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassDescriptor classDescriptor = $receiver.getCompanionObjectDescriptor();
        if (classDescriptor == null) {
            classDescriptor = $receiver;
        }
        return classDescriptor;
    }

    @NotNull
    public static final DeclarationDescriptor getImportableDescriptor(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof ConstructorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            declarationDescriptor = declarationDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"getContainingDeclaration()");
        } else if ($receiver instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            declarationDescriptor = declarationDescriptor3;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor3, (String)"getCorrespondingProperty()");
        } else {
            declarationDescriptor = $receiver;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"when {\n        this is C\u2026       else -> this\n    }");
        return declarationDescriptor;
    }

    public static final boolean getIsExtension(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof CallableDescriptor && ((CallableDescriptor)$receiver).getExtensionReceiverParameter() != null;
    }

    @NotNull
    public static final ModuleDescriptor getModule(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"DescriptorUtils.getContainingModule(this)");
        return moduleDescriptor;
    }

    @Nullable
    public static final ClassDescriptor resolveTopLevelClass(@JetValueParameter(name="$receiver") ModuleDescriptor $receiver, @JetValueParameter(name="topLevelClassFqName") @NotNull FqName topLevelClassFqName) {
        ClassifierDescriptor classifierDescriptor;
        ClassifierDescriptor classifierDescriptor2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)topLevelClassFqName, (String)"topLevelClassFqName");
        KotlinPackage.assert$default((!topLevelClassFqName.isRoot() ? 1 : 0) != 0, null, (int)2);
        FqName fqName2 = topLevelClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"topLevelClassFqName.parent()");
        Object object = $receiver.getPackage(fqName2);
        if (object != null && (object = object.getMemberScope()) != null) {
            Name name = topLevelClassFqName.shortName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"topLevelClassFqName.shortName()");
            classifierDescriptor2 = object.getClassifier(name);
        } else {
            classifierDescriptor2 = classifierDescriptor = null;
        }
        if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    @NotNull
    public static final ClassId getClassId(@JetValueParameter(name="$receiver") ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptor owner = $receiver.getContainingDeclaration();
        if (owner instanceof PackageFragmentDescriptor) {
            return new ClassId(((PackageFragmentDescriptor)owner).getFqName(), $receiver.getName());
        }
        if (owner instanceof ClassDescriptor) {
            ClassId classId = DescriptorUtilPackage$DescriptorUtils$b66f84e5.getClassId((ClassDescriptor)owner).createNestedClassId($receiver.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"owner.classId.createNestedClassId(getName())");
            return classId;
        }
        throw (Throwable)new IllegalStateException("Illegal container: " + owner);
    }

    public static final boolean getHasClassObjectType(@JetValueParameter(name="$receiver") ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtilPackage$DescriptorUtils$b66f84e5.getClassObjectType($receiver) != null;
    }

    @Nullable
    public static final JetType getClassObjectType(@JetValueParameter(name="$receiver") ClassDescriptor $receiver) {
        ClassDescriptor correspondingDescriptor;
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassKind classKind = $receiver.getKind();
        if (Intrinsics.areEqual((Object)((Object)classKind), (Object)((Object)ClassKind.OBJECT))) {
            classDescriptor = $receiver;
        } else if (Intrinsics.areEqual((Object)((Object)classKind), (Object)((Object)ClassKind.ENUM_ENTRY))) {
            DeclarationDescriptor container = $receiver.getContainingDeclaration();
            KotlinPackage.assert$default((container instanceof ClassDescriptor && Intrinsics.areEqual((Object)((Object)((ClassDescriptor)container).getKind()), (Object)((Object)ClassKind.ENUM_CLASS)) ? 1 : 0) != 0, null, (int)2);
            DeclarationDescriptor declarationDescriptor = container;
            if (declarationDescriptor == null) {
                throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            classDescriptor = (ClassDescriptor)declarationDescriptor;
        } else {
            classDescriptor = $receiver.getCompanionObjectDescriptor();
        }
        ClassDescriptor classDescriptor2 = correspondingDescriptor = classDescriptor;
        return classDescriptor2 != null ? classDescriptor2.getDefaultType() : null;
    }

    public static final boolean getIsEffectivelyPublicApi(@JetValueParameter(name="$receiver") DeclarationDescriptorWithVisibility $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptorWithVisibility parent = $receiver;
        while (parent != null) {
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = parent;
            if (declarationDescriptorWithVisibility == null) {
                Intrinsics.throwNpe();
            }
            if (!declarationDescriptorWithVisibility.getVisibility().isPublicAPI()) {
                return false;
            }
            parent = DescriptorUtils.getParentOfType(parent, DeclarationDescriptorWithVisibility.class);
        }
        return true;
    }

    @Nullable
    public static final ClassDescriptor getSuperClassNotAny(@JetValueParameter(name="$receiver") ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        for (JetType supertype : $receiver.getDefaultType().getConstructor().getSupertypes()) {
            ClassifierDescriptor superClassifier = supertype.getConstructor().getDeclarationDescriptor();
            if (KotlinBuiltIns.isAnyOrNullableAny(supertype) || !DescriptorUtils.isClass(superClassifier) && !DescriptorUtils.isEnumClass(superClassifier)) continue;
            ClassifierDescriptor classifierDescriptor = superClassifier;
            if (classifierDescriptor == null) {
                throw new TypeCastException("org.jetbrains.kotlin.descriptors.ClassifierDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return (ClassDescriptor)classifierDescriptor;
        }
        return null;
    }

    @NotNull
    public static final ClassDescriptor getSuperClassOrAny(@JetValueParameter(name="$receiver") ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilPackage$DescriptorUtils$b66f84e5.getSuperClassNotAny($receiver);
        if (classDescriptor == null) {
            classDescriptor = DescriptorUtilPackage$DescriptorUtils$b66f84e5.getBuiltIns($receiver).getAny();
        }
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConstructorDescriptor> getSecondaryConstructors(@JetValueParameter(name="$receiver") ClassDescriptor $receiver) {
        void var3_3;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Iterable $receiver3 = $receiver.getConstructors();
        Iterable iterable = $receiver3;
        Collection destination = new ArrayList();
        for (Object element : $receiver2) {
            ConstructorDescriptor it = (ConstructorDescriptor)element;
            if (it.isPrimary()) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final KotlinBuiltIns getBuiltIns(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtilPackage$DescriptorUtils$b66f84e5.getModule($receiver).getBuiltIns();
    }

    @Nullable
    public static final DeclarationDescriptor getOwnerForEffectiveDispatchReceiverParameter(@JetValueParameter(name="$receiver") CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)$receiver).getKind()), (Object)((Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE))) {
            return ((CallableMemberDescriptor)$receiver).getContainingDeclaration();
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getDispatchReceiverParameter();
        return receiverParameterDescriptor != null ? receiverParameterDescriptor.getContainingDeclaration() : null;
    }
}

