/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.annotations.NotNull;

public abstract class Visibility {
    private final boolean isPublicAPI;
    private final String name;

    protected Visibility(@NotNull String name, boolean isPublicAPI) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/descriptors/Visibility", "<init>"));
        }
        this.isPublicAPI = isPublicAPI;
        this.name = name;
    }

    public boolean isPublicAPI() {
        return this.isPublicAPI;
    }

    public abstract boolean mustCheckInImports();

    protected Integer compareTo(@NotNull Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "kotlin/reflect/jvm/internal/impl/descriptors/Visibility", "compareTo"));
        }
        return Visibilities.compareLocal(this, visibility);
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public Visibility normalize() {
        Visibility visibility = this;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/Visibility", "normalize"));
        }
        return visibility;
    }

    protected abstract boolean isVisible(@NotNull ReceiverValue var1, @NotNull DeclarationDescriptorWithVisibility var2, @NotNull DeclarationDescriptor var3);
}

