/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;

@KotlinSyntheticClass(abiVersion=22, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ReflectPackage$reflectStructureUtil$712cb930 {
    @NotNull
    public static final Visibility calculateVisibility(@JetValueParameter(name="modifiers") int modifiers) {
        Visibility visibility;
        if (Modifier.isPublic(modifiers)) {
            Visibility visibility2 = Visibilities.PUBLIC;
            visibility = visibility2;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility2, (String)"Visibilities.PUBLIC");
        } else if (Modifier.isPrivate(modifiers)) {
            Visibility visibility3 = Visibilities.PRIVATE;
            visibility = visibility3;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility3, (String)"Visibilities.PRIVATE");
        } else if (Modifier.isProtected(modifiers)) {
            visibility = Modifier.isStatic(modifiers) ? JavaVisibilities.PROTECTED_STATIC_VISIBILITY : JavaVisibilities.PROTECTED_AND_PACKAGE;
        } else {
            Visibility visibility4 = JavaVisibilities.PACKAGE_VISIBILITY;
            visibility = visibility4;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility4, (String)"JavaVisibilities.PACKAGE_VISIBILITY");
        }
        return visibility;
    }

    @NotNull
    public static final ClassLoader getClassLoader(@JetValueParameter(name="$receiver") Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        ClassLoader classLoader = $receiver.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static final boolean isEnumClassOrSpecializedEnumEntryClass(@JetValueParameter(name="$receiver") Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Enum.class.isAssignableFrom($receiver);
    }

    @NotNull
    public static final FqName getFqName(@JetValueParameter(name="$receiver") Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        FqName fqName2 = ReflectPackage$reflectStructureUtil$712cb930.getClassId($receiver).asSingleFqName().toSafe();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.asSingleFqName().toSafe()");
        return fqName2;
    }

    @NotNull
    public static final ClassId getClassId(@JetValueParameter(name="$receiver") Class<?> $receiver) {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if ($receiver.isPrimitive()) {
            throw (Throwable)new IllegalArgumentException("Can't compute ClassId for primitive type: " + $receiver);
        }
        if ($receiver.isArray()) {
            throw (Throwable)new IllegalArgumentException("Can't compute ClassId for array type: " + $receiver);
        }
        if ($receiver.getEnclosingMethod() != null || $receiver.getEnclosingConstructor() != null || KotlinPackage.isEmpty((String)$receiver.getSimpleName())) {
            FqName fqName2 = new FqName($receiver.getName());
            clazz = new ClassId(fqName2.parent(), FqNameUnsafe.topLevel(fqName2.shortName()), true);
        } else {
            clazz = $receiver.getDeclaringClass();
            if (clazz == null || (clazz = ReflectPackage$reflectStructureUtil$712cb930.getClassId(clazz)) == null || (clazz = ((ClassId)((Object)clazz)).createNestedClassId(Name.identifier($receiver.getSimpleName()))) == null) {
                clazz = ClassId.topLevel(new FqName($receiver.getName()));
            }
        }
        return clazz;
    }

    @NotNull
    public static final String getDesc(@JetValueParameter(name="$receiver") Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (Intrinsics.areEqual($receiver, Void.TYPE)) {
            return "V";
        }
        return KotlinPackage.replace((String)KotlinPackage.substring((String)ReflectPackage$reflectStructureUtil$712cb930.createArrayType($receiver).getName(), (int)1), (char)'.', (char)'/');
    }

    @NotNull
    public static final Class<?> createArrayType(@JetValueParameter(name="$receiver") Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Array.newInstance($receiver, 0).getClass();
    }
}

