/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.SubstitutingScope;
import org.jetbrains.kotlin.types.DescriptorSubstitutor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorImpl;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

public class LazySubstitutingClassDescriptor
implements ClassDescriptor {
    private final ClassDescriptor original;
    private final TypeSubstitutor originalSubstitutor;
    private TypeSubstitutor newSubstitutor;
    private List<TypeParameterDescriptor> typeParameters;
    private TypeConstructor typeConstructor;

    public LazySubstitutingClassDescriptor(ClassDescriptor descriptor2, TypeSubstitutor substitutor) {
        this.original = descriptor2;
        this.originalSubstitutor = substitutor;
    }

    private TypeSubstitutor getSubstitutor() {
        if (this.newSubstitutor == null) {
            if (this.originalSubstitutor.isEmpty()) {
                this.newSubstitutor = this.originalSubstitutor;
            } else {
                List<TypeParameterDescriptor> originalTypeParameters = this.original.getTypeConstructor().getParameters();
                this.typeParameters = new ArrayList<TypeParameterDescriptor>(originalTypeParameters.size());
                this.newSubstitutor = DescriptorSubstitutor.substituteTypeParameters(originalTypeParameters, this.originalSubstitutor, this, this.typeParameters);
            }
        }
        return this.newSubstitutor;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor originalTypeConstructor = this.original.getTypeConstructor();
        if (this.originalSubstitutor.isEmpty()) {
            return originalTypeConstructor;
        }
        if (this.typeConstructor == null) {
            TypeSubstitutor substitutor = this.getSubstitutor();
            Collection<JetType> originalSupertypes = originalTypeConstructor.getSupertypes();
            ArrayList<JetType> supertypes2 = new ArrayList<JetType>(originalSupertypes.size());
            for (JetType supertype : originalSupertypes) {
                supertypes2.add(substitutor.substitute(supertype, Variance.INVARIANT));
            }
            this.typeConstructor = TypeConstructorImpl.createForClass(this, originalTypeConstructor.getAnnotations(), originalTypeConstructor.isFinal(), originalTypeConstructor.toString(), this.typeParameters, supertypes2);
        }
        return this.typeConstructor;
    }

    @Override
    @NotNull
    public JetScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments) {
        JetScope memberScope2 = this.original.getMemberScope(typeArguments);
        if (this.originalSubstitutor.isEmpty()) {
            return memberScope2;
        }
        return new SubstitutingScope(memberScope2, this.getSubstitutor());
    }

    @Override
    @NotNull
    public JetScope getStaticScope() {
        return this.original.getStaticScope();
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        List<TypeProjection> typeProjections = TypeUtils.getDefaultTypeProjections(this.getTypeConstructor().getParameters());
        return new JetTypeImpl(this.getAnnotations(), this.getTypeConstructor(), false, typeProjections, this.getMemberScope(typeProjections));
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Collection<ConstructorDescriptor> originalConstructors = this.original.getConstructors();
        ArrayList<ConstructorDescriptor> result = new ArrayList<ConstructorDescriptor>(originalConstructors.size());
        for (ConstructorDescriptor constructor2 : originalConstructors) {
            result.add((ConstructorDescriptor)constructor2.substitute(this.getSubstitutor()));
        }
        return result;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return this.original.getAnnotations();
    }

    @Override
    @NotNull
    public Name getName() {
        return this.original.getName();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this.original.getOriginal();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.original.getContainingDeclaration();
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor.isEmpty()) {
            return this;
        }
        return new LazySubstitutingClassDescriptor(this, TypeSubstitutor.create(substitutor.getSubstitution(), this.getSubstitutor().getSubstitution()));
    }

    @Override
    public JetType getClassObjectType() {
        return this.original.getClassObjectType();
    }

    @Override
    public ClassDescriptor getCompanionObjectDescriptor() {
        return this.original.getCompanionObjectDescriptor();
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return this.original.getKind();
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.original.getModality();
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.original.getVisibility();
    }

    @Override
    public boolean isInner() {
        return this.original.isInner();
    }

    @Override
    public boolean isCompanionObject() {
        return this.original.isCompanionObject();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitClassDescriptor(this, data2);
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        return this.original.getUnsubstitutedInnerClassesScope();
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.original.getUnsubstitutedPrimaryConstructor();
    }

    @Override
    @NotNull
    public SourceElement getSource() {
        return SourceElement.NO_SOURCE;
    }
}

