/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.scopes.ChainedScope;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.AbstractJetType;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.LazyType;
import org.jetbrains.kotlin.types.NullAwareness;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class TypeUtils {
    public static final JetType DONT_CARE = ErrorUtils.createErrorTypeWithCustomDebugName("DONT_CARE");
    public static final JetType PLACEHOLDER_FUNCTION_TYPE = ErrorUtils.createErrorTypeWithCustomDebugName("PLACEHOLDER_FUNCTION_TYPE");
    public static final JetType CANT_INFER_FUNCTION_PARAM_TYPE = ErrorUtils.createErrorType("Cannot be inferred");
    public static final JetType NO_EXPECTED_TYPE = new SpecialType("NO_EXPECTED_TYPE");
    public static final JetType UNIT_EXPECTED_TYPE = new SpecialType("UNIT_EXPECTED_TYPE");

    public static boolean noExpectedType(@NotNull JetType type2) {
        return type2 == NO_EXPECTED_TYPE || type2 == UNIT_EXPECTED_TYPE;
    }

    public static boolean isDontCarePlaceholder(@Nullable JetType type2) {
        return type2 != null && type2.getConstructor() == DONT_CARE.getConstructor();
    }

    @NotNull
    public static JetType makeNullable(@NotNull JetType type2) {
        return TypeUtils.makeNullableAsSpecified(type2, true);
    }

    @NotNull
    public static JetType makeNotNullable(@NotNull JetType type2) {
        return TypeUtils.makeNullableAsSpecified(type2, false);
    }

    @NotNull
    public static JetType makeNullableAsSpecified(@NotNull JetType type2, boolean nullable2) {
        NullAwareness nullAwareness = type2.getCapability(NullAwareness.class);
        if (nullAwareness != null) {
            return nullAwareness.makeNullableAsSpecified(nullable2);
        }
        if (type2 instanceof AbstractTypeWithKnownNullability) {
            return TypeUtils.makeNullableAsSpecified(((AbstractTypeWithKnownNullability)type2).delegate, nullable2);
        }
        if (!(type2 instanceof LazyType) && type2.isMarkedNullable() == nullable2) {
            return type2;
        }
        return nullable2 ? new NullableType(type2) : new NotNullType(type2);
    }

    @NotNull
    public static JetType makeNullableIfNeeded(@NotNull JetType type2, boolean nullable2) {
        if (nullable2) {
            return TypeUtils.makeNullable(type2);
        }
        return type2;
    }

    public static boolean isIntersectionEmpty(@NotNull JetType typeA, @NotNull JetType typeB) {
        return TypeUtils.intersect(JetTypeChecker.DEFAULT, new LinkedHashSet<JetType>(Arrays.asList(typeA, typeB))) == null;
    }

    @Nullable
    public static JetType intersect(@NotNull JetTypeChecker typeChecker, @NotNull Set<JetType> types) {
        if (types.isEmpty()) {
            return KotlinBuiltIns.getInstance().getNullableAnyType();
        }
        if (types.size() == 1) {
            return types.iterator().next();
        }
        boolean allNullable = true;
        boolean nothingTypePresent = false;
        ArrayList<JetType> nullabilityStripped = new ArrayList<JetType>(types.size());
        for (JetType type2 : types) {
            if (type2.isError()) continue;
            nothingTypePresent |= KotlinBuiltIns.isNothingOrNullableNothing(type2);
            allNullable &= type2.isMarkedNullable();
            nullabilityStripped.add(TypeUtils.makeNotNullable(type2));
        }
        if (nothingTypePresent) {
            return allNullable ? KotlinBuiltIns.getInstance().getNullableNothingType() : KotlinBuiltIns.getInstance().getNothingType();
        }
        if (nullabilityStripped.isEmpty()) {
            return ErrorUtils.createErrorType("Intersection of errors types: " + types);
        }
        ArrayList<JetType> resultingTypes = new ArrayList<JetType>();
        block1: for (JetType type3 : nullabilityStripped) {
            if (!TypeUtils.canHaveSubtypes(typeChecker, type3)) {
                for (JetType other : nullabilityStripped) {
                    if (TypeUnifier.mayBeEqual(type3, other) || typeChecker.isSubtypeOf(type3, other) || typeChecker.isSubtypeOf(other, type3)) continue;
                    return null;
                }
                return TypeUtils.makeNullableAsSpecified(type3, allNullable);
            }
            for (JetType other : nullabilityStripped) {
                if (((Object)type3).equals(other) || !typeChecker.isSubtypeOf(other, type3)) continue;
                continue block1;
            }
            for (JetType other : resultingTypes) {
                if (!typeChecker.equalTypes(other, type3)) continue;
                continue block1;
            }
            resultingTypes.add(type3);
        }
        if (resultingTypes.isEmpty()) {
            JetType bestRepresentative = TypesPackage.singleBestRepresentative(nullabilityStripped);
            if (bestRepresentative == null) {
                throw new AssertionError((Object)("Empty intersection for types " + types));
            }
            return TypeUtils.makeNullableAsSpecified(bestRepresentative, allNullable);
        }
        if (resultingTypes.size() == 1) {
            return TypeUtils.makeNullableAsSpecified((JetType)resultingTypes.get(0), allNullable);
        }
        IntersectionTypeConstructor constructor2 = new IntersectionTypeConstructor(Annotations.EMPTY, resultingTypes);
        JetScope[] scopes = new JetScope[resultingTypes.size()];
        int i = 0;
        for (JetType type4 : resultingTypes) {
            scopes[i] = type4.getMemberScope();
            ++i;
        }
        return new JetTypeImpl(Annotations.EMPTY, constructor2, allNullable, Collections.emptyList(), new IntersectionScope(constructor2, scopes));
    }

    public static boolean canHaveSubtypes(JetTypeChecker typeChecker, @NotNull JetType type2) {
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (!type2.getConstructor().isFinal()) {
            return true;
        }
        List<TypeParameterDescriptor> parameters2 = type2.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        int parametersSize = parameters2.size();
        block10: for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters2.get(i);
            TypeProjection typeProjection = arguments2.get(i);
            Variance projectionKind = typeProjection.getProjectionKind();
            JetType argument = typeProjection.getType();
            switch (parameterDescriptor.getVariance()) {
                case INVARIANT: {
                    switch (projectionKind) {
                        case INVARIANT: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) && !TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                        case IN_VARIANCE: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor)) break;
                            return true;
                        }
                        case OUT_VARIANCE: {
                            if (!TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                    }
                    continue block10;
                }
                case IN_VARIANCE: {
                    if (!(projectionKind != Variance.OUT_VARIANCE ? TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) : TypeUtils.canHaveSubtypes(typeChecker, argument))) continue block10;
                    return true;
                }
                case OUT_VARIANCE: {
                    if (!(projectionKind != Variance.IN_VARIANCE ? TypeUtils.canHaveSubtypes(typeChecker, argument) : TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor))) continue block10;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean lowerThanBound(JetTypeChecker typeChecker, JetType argument, TypeParameterDescriptor parameterDescriptor) {
        for (JetType bound : parameterDescriptor.getUpperBounds()) {
            if (!typeChecker.isSubtypeOf(argument, bound) || argument.getConstructor().equals(bound.getConstructor())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static JetType makeUnsubstitutedType(ClassDescriptor classDescriptor, JetScope unsubstitutedMemberScope) {
        if (ErrorUtils.isError(classDescriptor)) {
            return ErrorUtils.createErrorType("Unsubstituted type for " + classDescriptor);
        }
        TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
        List<TypeProjection> arguments2 = TypeUtils.getDefaultTypeProjections(typeConstructor2.getParameters());
        return new JetTypeImpl(Annotations.EMPTY, typeConstructor2, false, arguments2, unsubstitutedMemberScope);
    }

    @NotNull
    public static List<TypeProjection> getDefaultTypeProjections(List<TypeParameterDescriptor> parameters2) {
        ArrayList<TypeProjection> result = new ArrayList<TypeProjection>();
        for (TypeParameterDescriptor parameterDescriptor : parameters2) {
            result.add(new TypeProjectionImpl(parameterDescriptor.getDefaultType()));
        }
        return result;
    }

    @NotNull
    public static List<JetType> getImmediateSupertypes(@NotNull JetType type2) {
        boolean isNullable = type2.isMarkedNullable();
        TypeSubstitutor substitutor = TypeSubstitutor.create(type2);
        Collection<JetType> originalSupertypes = type2.getConstructor().getSupertypes();
        ArrayList<JetType> result = new ArrayList<JetType>(originalSupertypes.size());
        for (JetType supertype : originalSupertypes) {
            JetType substitutedType = substitutor.substitute(supertype, Variance.INVARIANT);
            if (substitutedType == null) continue;
            result.add(TypeUtils.makeNullableIfNeeded(substitutedType, isNullable));
        }
        return result;
    }

    private static void collectAllSupertypes(@NotNull JetType type2, @NotNull Set<JetType> result) {
        List<JetType> immediateSupertypes = TypeUtils.getImmediateSupertypes(type2);
        result.addAll(immediateSupertypes);
        for (JetType supertype : immediateSupertypes) {
            TypeUtils.collectAllSupertypes(supertype, result);
        }
    }

    @NotNull
    public static Set<JetType> getAllSupertypes(@NotNull JetType type2) {
        LinkedHashSet<JetType> result = new LinkedHashSet<JetType>(15);
        TypeUtils.collectAllSupertypes(type2, result);
        return result;
    }

    public static boolean hasNullableLowerBound(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        for (JetType bound : typeParameterDescriptor.getLowerBounds()) {
            if (!bound.isMarkedNullable()) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullableType(@NotNull JetType type2) {
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (TypesPackage.isFlexible(type2) && TypeUtils.isNullableType(TypesPackage.flexibility(type2).getUpperBound())) {
            return true;
        }
        if (TypeUtils.isTypeParameter(type2)) {
            return TypeUtils.hasNullableSuperType(type2);
        }
        return false;
    }

    public static boolean hasNullableSuperType(@NotNull JetType type2) {
        if (type2.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return false;
        }
        for (JetType supertype : TypeUtils.getImmediateSupertypes(type2)) {
            if (supertype.isMarkedNullable()) {
                return true;
            }
            if (!TypeUtils.hasNullableSuperType(supertype)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ClassDescriptor getClassDescriptor(@NotNull JetType type2) {
        ClassifierDescriptor declarationDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)declarationDescriptor;
        }
        return null;
    }

    @NotNull
    public static JetType substituteParameters(@NotNull ClassDescriptor clazz, @NotNull List<JetType> typeArguments) {
        List projections = KotlinPackage.map(typeArguments, (Function1)new Function1<JetType, TypeProjection>(){

            public TypeProjection invoke(JetType type2) {
                return new TypeProjectionImpl(type2);
            }
        });
        return TypeUtils.substituteProjectionsForParameters(clazz, projections);
    }

    @NotNull
    public static JetType substituteProjectionsForParameters(@NotNull ClassDescriptor clazz, @NotNull List<TypeProjection> projections) {
        List<TypeParameterDescriptor> clazzTypeParameters = clazz.getTypeConstructor().getParameters();
        if (clazzTypeParameters.size() != projections.size()) {
            throw new IllegalArgumentException("type parameter counts do not match: " + clazz + ", " + projections);
        }
        HashMap<TypeConstructor, TypeProjection> substitutions = UtilsPackage.newHashMapWithExpectedSize(clazzTypeParameters.size());
        for (int i = 0; i < clazzTypeParameters.size(); ++i) {
            TypeConstructor typeConstructor2 = clazzTypeParameters.get(i).getTypeConstructor();
            substitutions.put(typeConstructor2, projections.get(i));
        }
        return TypeSubstitutor.create(substitutions).substitute(clazz.getDefaultType(), Variance.INVARIANT);
    }

    public static boolean equalTypes(@NotNull JetType a, @NotNull JetType b) {
        return JetTypeChecker.DEFAULT.isSubtypeOf(a, b) && JetTypeChecker.DEFAULT.isSubtypeOf(b, a);
    }

    public static boolean dependsOnTypeParameters(@NotNull JetType type2, @NotNull Collection<TypeParameterDescriptor> typeParameters) {
        return TypeUtils.dependsOnTypeConstructors(type2, KotlinPackage.map(typeParameters, (Function1)new Function1<TypeParameterDescriptor, TypeConstructor>(){

            public TypeConstructor invoke(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                return typeParameterDescriptor.getTypeConstructor();
            }
        }));
    }

    public static boolean dependsOnTypeConstructors(@NotNull JetType type2, @NotNull Collection<TypeConstructor> typeParameterConstructors) {
        if (typeParameterConstructors.contains(type2.getConstructor())) {
            return true;
        }
        for (TypeProjection typeProjection : type2.getArguments()) {
            if (typeProjection.isStarProjection() || !TypeUtils.dependsOnTypeConstructors(typeProjection.getType(), typeParameterConstructors)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSpecialType(@Nullable JetType type2, final @NotNull JetType specialType) {
        return TypeUtils.containsSpecialType(type2, new Function1<JetType, Boolean>(){

            public Boolean invoke(JetType type2) {
                return ((Object)specialType).equals(type2);
            }
        });
    }

    public static boolean containsSpecialType(@Nullable JetType type2, @NotNull Function1<JetType, Boolean> isSpecialType) {
        if (type2 == null) {
            return false;
        }
        if (((Boolean)isSpecialType.invoke((Object)type2)).booleanValue()) {
            return true;
        }
        Flexibility flexibility = type2.getCapability(Flexibility.class);
        if (flexibility != null && (TypeUtils.containsSpecialType(flexibility.getLowerBound(), isSpecialType) || TypeUtils.containsSpecialType(flexibility.getUpperBound(), isSpecialType))) {
            return true;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !TypeUtils.containsSpecialType(projection.getType(), isSpecialType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TypeProjection makeStarProjection(@NotNull TypeParameterDescriptor parameterDescriptor) {
        return new StarProjectionImpl(parameterDescriptor);
    }

    @Nullable
    public static JetType commonSupertypeForNumberTypes(@NotNull Collection<JetType> numberLowerBounds) {
        if (numberLowerBounds.isEmpty()) {
            return null;
        }
        Set<JetType> intersectionOfSupertypes = TypeUtils.getIntersectionOfSupertypes(numberLowerBounds);
        JetType primitiveNumberType = TypeUtils.getDefaultPrimitiveNumberType(intersectionOfSupertypes);
        if (primitiveNumberType != null) {
            return primitiveNumberType;
        }
        return CommonSupertypes.commonSupertype(numberLowerBounds);
    }

    @NotNull
    private static Set<JetType> getIntersectionOfSupertypes(@NotNull Collection<JetType> types) {
        HashSet<JetType> upperBounds = new HashSet<JetType>();
        for (JetType type2 : types) {
            Collection<JetType> supertypes2 = type2.getConstructor().getSupertypes();
            if (upperBounds.isEmpty()) {
                upperBounds.addAll(supertypes2);
                continue;
            }
            upperBounds.retainAll(supertypes2);
        }
        return upperBounds;
    }

    @NotNull
    public static JetType getDefaultPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor) {
        JetType type2 = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor.getSupertypes());
        assert (type2 != null) : "Strange number value type constructor: " + numberValueTypeConstructor + ". " + "Super types doesn't contain double, int or long: " + numberValueTypeConstructor.getSupertypes();
        return type2;
    }

    @Nullable
    private static JetType getDefaultPrimitiveNumberType(@NotNull Collection<JetType> supertypes2) {
        JetType doubleType = KotlinBuiltIns.getInstance().getDoubleType();
        if (supertypes2.contains(doubleType)) {
            return doubleType;
        }
        JetType intType = KotlinBuiltIns.getInstance().getIntType();
        if (supertypes2.contains(intType)) {
            return intType;
        }
        JetType longType = KotlinBuiltIns.getInstance().getLongType();
        if (supertypes2.contains(longType)) {
            return longType;
        }
        return null;
    }

    @NotNull
    public static JetType getPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor, @NotNull JetType expectedType) {
        if (TypeUtils.noExpectedType(expectedType) || expectedType.isError()) {
            return TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
        }
        for (JetType primitiveNumberType : numberValueTypeConstructor.getSupertypes()) {
            if (!JetTypeChecker.DEFAULT.isSubtypeOf(primitiveNumberType, expectedType)) continue;
            return primitiveNumberType;
        }
        return TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
    }

    public static List<TypeConstructor> topologicallySortSuperclassesAndRecordAllInstances(@NotNull JetType type2, final @NotNull Map<TypeConstructor, Set<JetType>> constructorToAllInstances, final @NotNull Set<TypeConstructor> visited) {
        return DFS.dfs(Collections.singletonList(type2), new DFS.Neighbors<JetType>(){

            @Override
            @NotNull
            public Iterable<JetType> getNeighbors(JetType current) {
                TypeSubstitutor substitutor = TypeSubstitutor.create(current);
                Collection<JetType> supertypes2 = current.getConstructor().getSupertypes();
                ArrayList<JetType> result = new ArrayList<JetType>(supertypes2.size());
                for (JetType supertype : supertypes2) {
                    if (visited.contains(supertype.getConstructor())) continue;
                    result.add(substitutor.safeSubstitute(supertype, Variance.INVARIANT));
                }
                return result;
            }
        }, new DFS.Visited<JetType>(){

            @Override
            public boolean checkAndMarkVisited(JetType current) {
                return visited.add(current.getConstructor());
            }
        }, new DFS.NodeHandlerWithListResult<JetType, TypeConstructor>(){

            @Override
            public boolean beforeChildren(JetType current) {
                TypeConstructor constructor2 = current.getConstructor();
                HashSet<JetType> instances = (HashSet<JetType>)constructorToAllInstances.get(constructor2);
                if (instances == null) {
                    instances = new HashSet<JetType>();
                    constructorToAllInstances.put(constructor2, instances);
                }
                instances.add(current);
                return true;
            }

            @Override
            public void afterChildren(JetType current) {
                ((LinkedList)this.result).addFirst(current.getConstructor());
            }
        });
    }

    public static TypeSubstitutor makeConstantSubstitutor(Collection<TypeParameterDescriptor> typeParameterDescriptors2, JetType type2) {
        final HashSet<TypeConstructor> constructors2 = UtilsPackage.newHashSetWithExpectedSize(typeParameterDescriptors2.size());
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors2) {
            constructors2.add(typeParameterDescriptor.getTypeConstructor());
        }
        final TypeProjectionImpl projection = new TypeProjectionImpl(type2);
        return TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                if (constructors2.contains(key)) {
                    return projection;
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        });
    }

    @NotNull
    public static TypeSubstitutor makeSubstitutorForTypeParametersMap(final @NotNull Map<TypeParameterDescriptor, TypeProjection> substitutionContext) {
        return TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            @Nullable
            public TypeProjection get(TypeConstructor key) {
                ClassifierDescriptor declarationDescriptor = key.getDeclarationDescriptor();
                if (declarationDescriptor instanceof TypeParameterDescriptor) {
                    TypeParameterDescriptor descriptor2 = (TypeParameterDescriptor)declarationDescriptor;
                    return (TypeProjection)substitutionContext.get(descriptor2);
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return substitutionContext.isEmpty();
            }

            public String toString() {
                return substitutionContext.toString();
            }
        });
    }

    public static boolean isTypeParameter(@NotNull JetType type2) {
        return TypeUtils.getTypeParameterDescriptorOrNull(type2) != null;
    }

    public static boolean isNonReifiedTypeParemeter(@NotNull JetType type2) {
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        return typeParameterDescriptor != null && !typeParameterDescriptor.isReified();
    }

    @Nullable
    public static TypeParameterDescriptor getTypeParameterDescriptorOrNull(@NotNull JetType type2) {
        if (type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return (TypeParameterDescriptor)type2.getConstructor().getDeclarationDescriptor();
        }
        return null;
    }

    private static class NotNullType
    extends AbstractTypeWithKnownNullability {
        private NotNullType(@NotNull JetType delegate2) {
            super(delegate2);
        }

        @Override
        public boolean isMarkedNullable() {
            return false;
        }
    }

    private static class NullableType
    extends AbstractTypeWithKnownNullability {
        private NullableType(@NotNull JetType delegate2) {
            super(delegate2);
        }

        @Override
        public boolean isMarkedNullable() {
            return true;
        }
    }

    private static abstract class AbstractTypeWithKnownNullability
    extends AbstractJetType {
        private final JetType delegate;

        private AbstractTypeWithKnownNullability(@NotNull JetType delegate2) {
            this.delegate = delegate2;
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            return this.delegate.getConstructor();
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            return this.delegate.getArguments();
        }

        @Override
        public abstract boolean isMarkedNullable();

        @Override
        @NotNull
        public JetScope getMemberScope() {
            return this.delegate.getMemberScope();
        }

        @Override
        public boolean isError() {
            return this.delegate.isError();
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            return this.delegate.getAnnotations();
        }
    }

    private static class TypeUnifier {
        private TypeUnifier() {
        }

        public static boolean mayBeEqual(@NotNull JetType type2, @NotNull JetType other) {
            return TypeUnifier.unify(type2, other);
        }

        private static boolean unify(JetType withParameters, JetType expected) {
            final HashMap parameters2 = new HashMap();
            Function1<TypeParameterUsage, Unit> processor = new Function1<TypeParameterUsage, Unit>(){

                public Unit invoke(TypeParameterUsage parameterUsage) {
                    Variance howTheTypeIsUsedBefore = (Variance)((Object)parameters2.get(parameterUsage.typeParameterDescriptor));
                    if (howTheTypeIsUsedBefore == null) {
                        howTheTypeIsUsedBefore = Variance.INVARIANT;
                    }
                    parameters2.put(parameterUsage.typeParameterDescriptor, parameterUsage.howTheTypeParameterIsUsed.superpose(howTheTypeIsUsedBefore));
                    return Unit.INSTANCE$;
                }
            };
            TypeUnifier.processAllTypeParameters(withParameters, Variance.INVARIANT, processor);
            TypeUnifier.processAllTypeParameters(expected, Variance.INVARIANT, processor);
            ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl();
            constraintSystem.registerTypeVariables(parameters2);
            constraintSystem.addSubtypeConstraint(withParameters, expected, ConstraintPositionKind.SPECIAL.position());
            return constraintSystem.getStatus().isSuccessful();
        }

        private static void processAllTypeParameters(JetType type2, Variance howThisTypeIsUsed, Function1<TypeParameterUsage, Unit> result) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (descriptor2 instanceof TypeParameterDescriptor) {
                result.invoke((Object)new TypeParameterUsage((TypeParameterDescriptor)descriptor2, howThisTypeIsUsed));
            }
            for (TypeProjection projection : type2.getArguments()) {
                TypeUnifier.processAllTypeParameters(projection.getType(), projection.getProjectionKind(), result);
            }
        }

        private static class TypeParameterUsage {
            private final TypeParameterDescriptor typeParameterDescriptor;
            private final Variance howTheTypeParameterIsUsed;

            public TypeParameterUsage(TypeParameterDescriptor typeParameterDescriptor, Variance howTheTypeParameterIsUsed) {
                this.typeParameterDescriptor = typeParameterDescriptor;
                this.howTheTypeParameterIsUsed = howTheTypeParameterIsUsed;
            }
        }
    }

    public static class IntersectionScope
    extends ChainedScope {
        public IntersectionScope(@NotNull TypeConstructor constructor2, @NotNull JetScope[] scopes) {
            super(null, "member scope for intersection type " + constructor2, scopes);
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            throw new UnsupportedOperationException("Should not call getContainingDeclaration on intersection scope " + this);
        }
    }

    public static class SpecialType
    implements JetType {
        private final String name;

        public SpecialType(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            throw new IllegalStateException(this.name);
        }

        @Override
        public boolean isMarkedNullable() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            throw new IllegalStateException(this.name);
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @Nullable
        public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

