/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class NameResolver {
    private final ProtoBuf.StringTable strings;
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    @NotNull
    public static NameResolver read(@NotNull InputStream in) {
        try {
            ProtoBuf.StringTable simpleNames = ProtoBuf.StringTable.parseDelimitedFrom(in);
            ProtoBuf.QualifiedNameTable qualifiedNames = ProtoBuf.QualifiedNameTable.parseDelimitedFrom(in);
            return new NameResolver(simpleNames, qualifiedNames);
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
    }

    public NameResolver(@NotNull ProtoBuf.StringTable strings2, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        this.strings = strings2;
        this.qualifiedNames = qualifiedNames;
    }

    @NotNull
    public ProtoBuf.StringTable getStringTable() {
        return this.strings;
    }

    @NotNull
    public ProtoBuf.QualifiedNameTable getQualifiedNameTable() {
        return this.qualifiedNames;
    }

    @NotNull
    public String getString(int index) {
        return this.strings.getString(index);
    }

    @NotNull
    public Name getName(int index) {
        String name = this.strings.getString(index);
        return Name.guess(name);
    }

    @NotNull
    public ClassId getClassId(int index) {
        LinkedList<String> packageFqName = new LinkedList<String>();
        LinkedList<String> relativeClassName = new LinkedList<String>();
        boolean local = false;
        while (index != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName proto = this.qualifiedNames.getQualifiedName(index);
            String shortName = this.strings.getString(proto.getShortName());
            switch (proto.getKind()) {
                case CLASS: {
                    relativeClassName.addFirst(shortName);
                    break;
                }
                case PACKAGE: {
                    packageFqName.addFirst(shortName);
                    break;
                }
                case LOCAL: {
                    relativeClassName.addFirst(shortName);
                    local = true;
                }
            }
            index = proto.getParentQualifiedName();
        }
        return new ClassId(FqName.fromSegments(packageFqName), FqNameUnsafe.fromSegments(relativeClassName), local);
    }

    @NotNull
    public FqName getFqName(int index) {
        ProtoBuf.QualifiedNameTable.QualifiedName qualifiedName = this.qualifiedNames.getQualifiedName(index);
        Name shortName = this.getName(qualifiedName.getShortName());
        if (!qualifiedName.hasParentQualifiedName()) {
            return FqName.topLevel(shortName);
        }
        return this.getFqName(qualifiedName.getParentQualifiedName()).child(shortName);
    }
}

