/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.Interner;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;

public class StringTable {
    private final Interner<String> strings = new Interner();
    private final Interner<FqNameProto> qualifiedNames = new Interner();
    private final SerializerExtension extension;

    public StringTable(@NotNull SerializerExtension extension) {
        this.extension = extension;
    }

    public int getSimpleNameIndex(@NotNull Name name) {
        return this.getStringIndex(name.asString());
    }

    public int getStringIndex(@NotNull String string) {
        return this.strings.intern(string);
    }

    public int getFqNameIndex(@NotNull ClassOrPackageFragmentDescriptor descriptor2) {
        int shortName;
        DeclarationDescriptor containingDeclaration;
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
        if (descriptor2 instanceof ClassDescriptor) {
            builder.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        }
        if ((containingDeclaration = descriptor2.getContainingDeclaration()) instanceof PackageFragmentDescriptor) {
            shortName = this.getSimpleNameIndex(descriptor2.getName());
            PackageFragmentDescriptor fragment = (PackageFragmentDescriptor)containingDeclaration;
            if (!fragment.getFqName().isRoot()) {
                builder.setParentQualifiedName(this.getFqNameIndex(fragment.getFqName()));
            }
        } else if (containingDeclaration instanceof ClassDescriptor) {
            shortName = this.getSimpleNameIndex(descriptor2.getName());
            ClassDescriptor outerClass = (ClassDescriptor)containingDeclaration;
            builder.setParentQualifiedName(this.getFqNameIndex(outerClass));
        } else if (descriptor2 instanceof ClassDescriptor) {
            builder.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.LOCAL);
            shortName = this.getStringIndex(this.extension.getLocalClassName((ClassDescriptor)descriptor2));
        } else {
            throw new IllegalStateException("Package container should be a package: " + descriptor2);
        }
        builder.setShortName(shortName);
        return this.qualifiedNames.intern(new FqNameProto(builder));
    }

    public int getFqNameIndex(@NotNull FqName fqName2) {
        int result = -1;
        for (Name segment : fqName2.pathSegments()) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
            builder.setShortName(this.getSimpleNameIndex(segment));
            if (result != -1) {
                builder.setParentQualifiedName(result);
            }
            result = this.qualifiedNames.intern(new FqNameProto(builder));
        }
        return result;
    }

    @NotNull
    public ProtoBuf.StringTable serializeSimpleNames() {
        ProtoBuf.StringTable.Builder builder = ProtoBuf.StringTable.newBuilder();
        for (String simpleName : this.strings.getAllInternedObjects()) {
            builder.addString(simpleName);
        }
        return builder.build();
    }

    @NotNull
    public ProtoBuf.QualifiedNameTable serializeQualifiedNames() {
        ProtoBuf.QualifiedNameTable.Builder builder = ProtoBuf.QualifiedNameTable.newBuilder();
        for (FqNameProto fqName2 : this.qualifiedNames.getAllInternedObjects()) {
            builder.addQualifiedName(fqName2.fqName);
        }
        return builder.build();
    }

    private static final class FqNameProto {
        public final ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName;

        public FqNameProto(@NotNull ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName2) {
            this.fqName = fqName2;
        }

        public int hashCode() {
            int result = 13;
            result = 31 * result + this.fqName.getParentQualifiedName();
            result = 31 * result + this.fqName.getShortName();
            result = 31 * result + this.fqName.getKind().hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder other = ((FqNameProto)obj).fqName;
            return this.fqName.getParentQualifiedName() == other.getParentQualifiedName() && this.fqName.getShortName() == other.getShortName() && this.fqName.getKind() == other.getKind();
        }
    }
}

