/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;

public class IntegerValueTypeConstructor
implements TypeConstructor {
    private final long value;
    private final Collection<JetType> supertypes = new ArrayList<JetType>(4);

    public IntegerValueTypeConstructor(long value) {
        this.value = value;
        this.checkBoundsAndAddSuperType(value, Integer.MIN_VALUE, Integer.MAX_VALUE, KotlinBuiltIns.getInstance().getIntType());
        this.checkBoundsAndAddSuperType(value, -128L, 127L, KotlinBuiltIns.getInstance().getByteType());
        this.checkBoundsAndAddSuperType(value, -32768L, 32767L, KotlinBuiltIns.getInstance().getShortType());
        this.supertypes.add(KotlinBuiltIns.getInstance().getLongType());
    }

    private void checkBoundsAndAddSuperType(long value, long minValue, long maxValue, JetType kotlinType) {
        if (value >= minValue && value <= maxValue) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        return this.supertypes;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return Annotations.EMPTY;
    }

    public Long getValue() {
        return this.value;
    }

    public String toString() {
        return "IntegerValueType(" + this.value + ")";
    }
}

