/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;

public final class ClassId {
    private final FqName packageFqName;
    private final FqNameUnsafe relativeClassName;
    private final boolean local;

    @NotNull
    public static ClassId topLevel(@NotNull FqName topLevelFqName) {
        return new ClassId(topLevelFqName.parent(), topLevelFqName.shortName());
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull FqNameUnsafe relativeClassName, boolean local) {
        this.packageFqName = packageFqName;
        assert (!relativeClassName.isRoot()) : "Class name must not be root: " + packageFqName + (local ? " (local)" : "");
        this.relativeClassName = relativeClassName;
        this.local = local;
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull Name topLevelName) {
        this(packageFqName, FqNameUnsafe.topLevel(topLevelName), false);
    }

    @NotNull
    public FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public FqNameUnsafe getRelativeClassName() {
        return this.relativeClassName;
    }

    @NotNull
    public Name getShortClassName() {
        return this.relativeClassName.shortName();
    }

    public boolean isLocal() {
        return this.local;
    }

    @NotNull
    public ClassId createNestedClassId(@NotNull Name name) {
        return new ClassId(this.getPackageFqName(), this.relativeClassName.child(name), this.local);
    }

    @NotNull
    public ClassId getOuterClassId() {
        return new ClassId(this.getPackageFqName(), this.relativeClassName.parent(), this.local);
    }

    public boolean isNestedClass() {
        return !this.relativeClassName.parent().isRoot();
    }

    @NotNull
    public FqNameUnsafe asSingleFqName() {
        if (this.packageFqName.isRoot()) {
            return this.relativeClassName;
        }
        return new FqNameUnsafe(this.packageFqName.asString() + "." + this.relativeClassName.asString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassId id = (ClassId)o;
        return this.packageFqName.equals(id.packageFqName) && this.relativeClassName.equals(id.relativeClassName) && this.local == id.local;
    }

    public int hashCode() {
        int result = this.packageFqName.hashCode();
        result = 31 * result + this.relativeClassName.hashCode();
        result = 31 * result + Boolean.valueOf(this.local).hashCode();
        return result;
    }

    public String toString() {
        if (this.packageFqName.isRoot()) {
            return "/" + this.relativeClassName;
        }
        return this.packageFqName.toString().replace('.', '/') + "/" + this.relativeClassName;
    }

    @NotNull
    public static ClassId fromString(@NotNull String string) {
        int lastSlash = string.lastIndexOf("/");
        if (lastSlash == -1) {
            throw new IllegalArgumentException("Class id should contain slash: " + string);
        }
        FqNameUnsafe relativeClassName = new FqNameUnsafe(string.substring(lastSlash + 1));
        FqName packageFqName = new FqName(string.substring(0, lastSlash).replace('/', '.'));
        return new ClassId(packageFqName, relativeClassName, false);
    }
}

