/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.jvm;

import com.google.protobuf.ExtensionRegistryLite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;

public class JvmProtoBufUtil {
    private JvmProtoBufUtil() {
    }

    @NotNull
    public static ExtensionRegistryLite getExtensionRegistry() {
        ExtensionRegistryLite registry = ExtensionRegistryLite.newInstance();
        JvmProtoBuf.registerAllExtensions(registry);
        return registry;
    }

    @NotNull
    public static ClassData readClassDataFrom(@NotNull String[] encodedData) {
        return ClassData.read(BitEncoding.decodeBytes(encodedData), JvmProtoBufUtil.getExtensionRegistry());
    }

    @NotNull
    public static PackageData readPackageDataFrom(@NotNull String[] encodedData) {
        return JvmProtoBufUtil.readPackageDataFrom(BitEncoding.decodeBytes(encodedData));
    }

    @NotNull
    public static PackageData readPackageDataFrom(@NotNull byte[] data) {
        return PackageData.read(data, JvmProtoBufUtil.getExtensionRegistry());
    }
}

