/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collections;
import java.util.Set;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public abstract class AbstractTypeParameterDescriptor
extends DeclarationDescriptorNonRootImpl
implements TypeParameterDescriptor {
    private final Variance variance;
    private final boolean reified;
    private final int index;
    private final NotNullLazyValue<TypeConstructor> typeConstructor;
    private final NotNullLazyValue<JetType> defaultType;
    private final NotNullLazyValue<Set<JetType>> upperBounds;
    private final NotNullLazyValue<JetType> upperBoundsAsType;

    protected AbstractTypeParameterDescriptor(final @NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name, @NotNull Variance variance, boolean isReified, int index, @NotNull SourceElement source) {
        super(containingDeclaration, annotations2, name, source);
        this.variance = variance;
        this.reified = isReified;
        this.index = index;
        this.typeConstructor = storageManager.createLazyValue(new Function0<TypeConstructor>(){

            public TypeConstructor invoke() {
                return AbstractTypeParameterDescriptor.this.createTypeConstructor();
            }
        });
        this.defaultType = storageManager.createLazyValue(new Function0<JetType>(){

            public JetType invoke() {
                return new JetTypeImpl(Annotations.EMPTY, AbstractTypeParameterDescriptor.this.getTypeConstructor(), false, Collections.emptyList(), new LazyScopeAdapter(storageManager.createLazyValue(new Function0<JetScope>(){

                    public JetScope invoke() {
                        return AbstractTypeParameterDescriptor.this.getUpperBoundsAsType().getMemberScope();
                    }
                })));
            }
        });
        this.upperBounds = storageManager.createLazyValue(new Function0<Set<JetType>>(){

            public Set<JetType> invoke() {
                return AbstractTypeParameterDescriptor.this.resolveUpperBounds();
            }
        });
        this.upperBoundsAsType = storageManager.createLazyValue(new Function0<JetType>(){

            public JetType invoke() {
                return AbstractTypeParameterDescriptor.this.computeUpperBoundsAsType();
            }
        });
    }

    @NotNull
    @ReadOnly
    protected abstract Set<JetType> resolveUpperBounds();

    @NotNull
    protected abstract TypeConstructor createTypeConstructor();

    @Override
    @NotNull
    public Variance getVariance() {
        return this.variance;
    }

    @Override
    public boolean isReified() {
        return this.reified;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public Set<JetType> getUpperBounds() {
        return (Set)this.upperBounds.invoke();
    }

    @Override
    @NotNull
    public JetType getUpperBoundsAsType() {
        return (JetType)this.upperBoundsAsType.invoke();
    }

    @NotNull
    private JetType computeUpperBoundsAsType() {
        Set<JetType> upperBounds = this.getUpperBounds();
        assert (!upperBounds.isEmpty()) : "Upper bound list is empty in " + this.getName();
        JetType upperBoundsAsType = TypeUtils.intersect(JetTypeChecker.DEFAULT, upperBounds);
        return upperBoundsAsType != null ? upperBoundsAsType : KotlinBuiltIns.getInstance().getNothingType();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return (TypeConstructor)this.typeConstructor.invoke();
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        return (JetType)this.defaultType.invoke();
    }

    @Override
    public JetType getClassObjectType() {
        return null;
    }

    @Override
    @NotNull
    public Set<JetType> getLowerBounds() {
        return Collections.singleton(KotlinBuiltIns.getInstance().getNothingType());
    }

    @Override
    @Deprecated
    @NotNull
    public TypeParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        throw new UnsupportedOperationException("Don't call substitute() on type parameters");
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitTypeParameterDescriptor(this, data2);
    }
}

