/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.List;
import java.util.Map;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LazyClassReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LazySubstitutingClassDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.scopes.InnerClassesScopeWrapper;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.SubstitutingScope;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;

public abstract class AbstractClassDescriptor
implements ClassDescriptor {
    private final Name name;
    protected final NotNullLazyValue<JetType> defaultType;
    private final NotNullLazyValue<JetScope> unsubstitutedInnerClassesScope;
    private final NotNullLazyValue<ReceiverParameterDescriptor> thisAsReceiverParameter;

    public AbstractClassDescriptor(@NotNull StorageManager storageManager, @NotNull Name name) {
        this.name = name;
        this.defaultType = storageManager.createLazyValue(new Function0<JetType>(){

            public JetType invoke() {
                return TypeUtils.makeUnsubstitutedType(AbstractClassDescriptor.this, AbstractClassDescriptor.this.getScopeForMemberLookup());
            }
        });
        this.unsubstitutedInnerClassesScope = storageManager.createLazyValue(new Function0<JetScope>(){

            public JetScope invoke() {
                return new InnerClassesScopeWrapper(AbstractClassDescriptor.this.getScopeForMemberLookup());
            }
        });
        this.thisAsReceiverParameter = storageManager.createLazyValue(new Function0<ReceiverParameterDescriptor>(){

            public ReceiverParameterDescriptor invoke() {
                return new LazyClassReceiverParameterDescriptor(AbstractClassDescriptor.this);
            }
        });
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    @NotNull
    protected abstract JetScope getScopeForMemberLookup();

    @Override
    @Nullable
    public JetType getClassObjectType() {
        ClassDescriptor classObject = DescriptorUtilPackage.getClassObjectDescriptor(this);
        return classObject == null ? null : classObject.getDefaultType();
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        return (JetScope)this.unsubstitutedInnerClassesScope.invoke();
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        return (ReceiverParameterDescriptor)this.thisAsReceiverParameter.invoke();
    }

    @Override
    @NotNull
    public JetScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments) {
        assert (typeArguments.size() == this.getTypeConstructor().getParameters().size()) : "Illegal number of type arguments: expected " + this.getTypeConstructor().getParameters().size() + " but was " + typeArguments.size() + " for " + this.getTypeConstructor() + " " + this.getTypeConstructor().getParameters();
        if (typeArguments.isEmpty()) {
            return this.getScopeForMemberLookup();
        }
        List<TypeParameterDescriptor> typeParameters = this.getTypeConstructor().getParameters();
        Map<TypeConstructor, TypeProjection> substitutionContext = TypeSubstitutor.buildSubstitutionContext(typeParameters, typeArguments);
        TypeSubstitutor substitutor = TypeSubstitutor.create(substitutionContext);
        return new SubstitutingScope(this.getScopeForMemberLookup(), substitutor);
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor.isEmpty()) {
            return this;
        }
        return new LazySubstitutingClassDescriptor(this, substitutor);
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        return (JetType)this.defaultType.invoke();
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        visitor.visitClassDescriptor(this, null);
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitClassDescriptor(this, data2);
    }
}

