/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.annotations;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public class AnnotationsImpl
implements Annotations {
    private final List<AnnotationDescriptor> annotations;

    public AnnotationsImpl(@NotNull List<AnnotationDescriptor> annotations2) {
        this.annotations = annotations2;
    }

    @NotNull
    public List<AnnotationDescriptor> getAnnotationDescriptors() {
        return this.annotations;
    }

    @Override
    public boolean isEmpty() {
        return this.getAnnotationDescriptors().isEmpty();
    }

    @Override
    @Nullable
    public AnnotationDescriptor findAnnotation(@NotNull FqName fqName2) {
        for (AnnotationDescriptor annotation : this.annotations) {
            ClassifierDescriptor descriptor2 = annotation.getType().getConstructor().getDeclarationDescriptor();
            if (!(descriptor2 instanceof ClassDescriptor) || !fqName2.toUnsafe().equals(DescriptorUtils.getFqName(descriptor2))) continue;
            return annotation;
        }
        return null;
    }

    @Override
    @NotNull
    public Iterator<AnnotationDescriptor> iterator() {
        return this.getAnnotationDescriptors().iterator();
    }
}

