/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.kotlin.MemberSignature;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;

public class SignatureDeserializer {
    private static final char[] PRIMITIVE_TYPES = new char[]{'V', 'Z', 'C', 'B', 'S', 'I', 'F', 'J', 'D'};
    private final NameResolver nameResolver;

    public SignatureDeserializer(@NotNull NameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    @NotNull
    public String methodSignatureString(@NotNull JvmProtoBuf.JvmMethodSignature signature) {
        Name name = this.nameResolver.getName(signature.getName());
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int length = signature.getParameterTypeCount();
        for (int i = 0; i < length; ++i) {
            this.typeDescriptor(signature.getParameterType(i), sb);
        }
        sb.append(')');
        this.typeDescriptor(signature.getReturnType(), sb);
        return name.asString() + sb.toString();
    }

    @NotNull
    public MemberSignature methodSignature(@NotNull JvmProtoBuf.JvmMethodSignature signature) {
        return MemberSignature.fromMethodNameAndDesc(this.methodSignatureString(signature));
    }

    @NotNull
    public String typeDescriptor(@NotNull JvmProtoBuf.JvmType type2) {
        return this.typeDescriptor(type2, new StringBuilder()).toString();
    }

    @NotNull
    private StringBuilder typeDescriptor(@NotNull JvmProtoBuf.JvmType type2, @NotNull StringBuilder sb) {
        for (int i = 0; i < type2.getArrayDimension(); ++i) {
            sb.append('[');
        }
        if (type2.hasPrimitiveType()) {
            sb.append(PRIMITIVE_TYPES[type2.getPrimitiveType().ordinal()]);
        } else {
            sb.append("L");
            sb.append(SignatureDeserializer.fqNameToInternalName(this.nameResolver.getFqName(type2.getClassFqName())));
            sb.append(";");
        }
        return sb;
    }

    @NotNull
    private static String fqNameToInternalName(@NotNull FqName fqName2) {
        return fqName2.asString().replace('.', '/');
    }
}

