/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.LazyType;

public abstract class VariableDescriptorImpl
extends DeclarationDescriptorNonRootImpl
implements VariableDescriptor {
    private JetType outType;
    private NullableLazyValue<CompileTimeConstant<?>> compileTimeInitializer;

    public VariableDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name, @Nullable JetType outType, @NotNull SourceElement source) {
        super(containingDeclaration, annotations2, name, source);
        this.outType = outType;
    }

    @Override
    @NotNull
    public JetType getType() {
        return this.outType;
    }

    public void setOutType(JetType outType) {
        assert (this.outType == null);
        this.outType = outType;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> getCompileTimeInitializer() {
        if (this.compileTimeInitializer == null && this.outType instanceof LazyType) {
            this.outType.getConstructor();
        }
        if (this.compileTimeInitializer != null) {
            return (CompileTimeConstant)this.compileTimeInitializer.invoke();
        }
        return null;
    }

    public void setCompileTimeInitializer(@NotNull NullableLazyValue<CompileTimeConstant<?>> compileTimeInitializer) {
        assert (!this.isVar()) : "Compile-time value for property initializer should be recorded only for final variables " + this.getName();
        this.compileTimeInitializer = compileTimeInitializer;
    }

    @Override
    @NotNull
    public VariableDescriptor getOriginal() {
        return (VariableDescriptor)super.getOriginal();
    }

    @Override
    @NotNull
    public List<ValueParameterDescriptor> getValueParameters() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasStableParameterNames() {
        return false;
    }

    @Override
    public boolean hasSynthesizedParameterNames() {
        return false;
    }

    @Override
    @NotNull
    public Set<? extends CallableDescriptor> getOverriddenDescriptors() {
        return Collections.emptySet();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public ReceiverParameterDescriptor getExtensionReceiverParameter() {
        return ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
    }

    @Override
    public ReceiverParameterDescriptor getDispatchReceiverParameter() {
        return ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
    }

    @Override
    @NotNull
    public JetType getReturnType() {
        return this.getType();
    }
}

