/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmNames;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ResolveUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.AbstractSerialGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationErrors;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationPluginDeclarationChecker;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationPluginDeclarationCheckerKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.VersionReader;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010!\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0002J:\u0010%\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020$H\u0002J \u0010+\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010/\u001a\u00020\n2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J2\u00100\u001a\u00020\n2\u0006\u0010&\u001a\u00020'2\u0006\u00101\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u0001022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020$H\u0002J\u0018\u00103\u001a\u00020\n2\u0006\u0010\u0015\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u00105\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u00106\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J6\u00107\u001a\u00020\n*\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00109\u001a\u00020'2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020$H\u0002J6\u0010<\u001a\u00020\n*\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00109\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u0001022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020$H\u0002J\f\u0010=\u001a\u00020\u0004*\u00020\u0007H\u0002J\f\u0010>\u001a\u00020\u0004*\u00020'H\u0002J!\u0010?\u001a\u00020\n*\u00020\u00072\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020\n0AH\u0082\bJ$\u0010C\u001a\u00020\n*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u000e\u0010D\u001a\n\u0012\u0006\b\u0000\u0012\u00020B0EH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0018\u0010\u0006\u001a\u00020\u0004*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationPluginDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "isIde", "", "()Z", "isAnonymousObjectOrContained", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Z", "analyzePropertiesSerializers", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "serializableClass", "props", "", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "buildSerializableProperties", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "descriptor", "canBeSerializedInternally", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canSupportInlineClasses", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "check", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkClassWithCustomSerializer", "checkCorrectTransientAnnotationIsUsed", "properties", "checkCustomSerializerIsNotLocal", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "declarationElement", "Lcom/intellij/psi/PsiElement;", "checkCustomSerializerMatch", "classType", "Lorg/jetbrains/kotlin/types/KotlinType;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "fallbackElement", "checkInheritedAnnotations", "checkMinKotlin", "versions", "Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/VersionReader$RuntimeVersions;", "checkMinRuntime", "checkSerializerNullability", "serializerType", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "checkTransients", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "declarationHasInitializer", "serializationPluginEnabledOn", "checkType", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/AbstractSerialGenerator;", "type", "ktType", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "checkTypeArguments", "isSerializableEnumWithMissingSerializer", "isUnsupportedInlineType", "onSerializableAnnotation", "report", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "reportOnSerializableAnnotation", "error", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "kotlin-maven-serialization"})
public class SerializationPluginDeclarationChecker
implements DeclarationChecker {
    public final void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor instanceof ClassDescriptor)) {
            return;
        }
        if (!this.canBeSerializedInternally((ClassDescriptor)descriptor, declaration, context.getTrace())) {
            return;
        }
        if (!(declaration instanceof KtPureClassOrObject)) {
            return;
        }
        if (!this.isIde()) {
            VersionReader.RuntimeVersions runtimeVersions = VersionReader.INSTANCE.getVersionsForCurrentModuleFromTrace(DescriptorUtilsKt.getModule((DeclarationDescriptor)descriptor), context.getTrace());
            if (runtimeVersions != null) {
                VersionReader.RuntimeVersions it = runtimeVersions;
                boolean bl = false;
                this.checkMinKotlin(it, (ClassDescriptor)descriptor, context.getTrace());
                this.checkMinRuntime(it, (ClassDescriptor)descriptor, context.getTrace());
            }
        }
        SerializableProperties serializableProperties = this.buildSerializableProperties((ClassDescriptor)descriptor, context.getTrace());
        if (serializableProperties == null) {
            return;
        }
        SerializableProperties props = serializableProperties;
        this.checkCorrectTransientAnnotationIsUsed((ClassDescriptor)descriptor, props.getSerializableProperties(), context.getTrace());
        this.checkTransients((KtPureClassOrObject)declaration, context.getTrace());
        this.analyzePropertiesSerializers(context.getTrace(), (ClassDescriptor)descriptor, props.getSerializableProperties());
        this.checkInheritedAnnotations((ClassDescriptor)descriptor, declaration, context.getTrace());
    }

    private final void checkInheritedAnnotations(ClassDescriptor descriptor, KtDeclaration declaration, BindingTrace trace) {
        Function1 annotationsFilter2 = checkInheritedAnnotations.annotationsFilter.1.INSTANCE;
        Map annotationByFq = new LinkedHashMap();
        Set reported = new LinkedHashSet();
        MapsKt.putAll((Map)annotationByFq, (Iterable)((Iterable)annotationsFilter2.invoke((Object)descriptor.getAnnotations())));
        for (ClassifierDescriptor clazz : DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)((ClassifierDescriptor)descriptor))) {
            List annotations = (List)annotationsFilter2.invoke((Object)clazz.getAnnotations());
            Iterable $this$forEach$iv = annotations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnnotationDescriptor existing;
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                FqName fqname = (FqName)pair.component1();
                AnnotationDescriptor call = (AnnotationDescriptor)pair.component2();
                if (!annotationByFq.containsKey(fqname) || Intrinsics.areEqual((Object)(existing = (AnnotationDescriptor)MapsKt.getValue((Map)annotationByFq, (Object)fqname)).getAllValueArguments(), (Object)call.getAllValueArguments()) || !reported.add(fqname)) continue;
                LazyAnnotationDescriptor lazyAnnotationDescriptor = existing instanceof LazyAnnotationDescriptor ? (LazyAnnotationDescriptor)existing : null;
                KtElement entry = lazyAnnotationDescriptor != null && (lazyAnnotationDescriptor = lazyAnnotationDescriptor.getAnnotationEntry()) != null ? (KtElement)lazyAnnotationDescriptor : (KtElement)declaration;
                trace.report((Diagnostic)SerializationErrors.INCONSISTENT_INHERITABLE_SERIALINFO.on((PsiElement)entry, (Object)existing.getType(), (Object)clazz.getDefaultType()));
            }
        }
    }

    private final void checkMinRuntime(VersionReader.RuntimeVersions versions, ClassDescriptor descriptor, BindingTrace trace) {
        block3: {
            if (versions.implementationVersionMatchSupported()) break block3;
            SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
            ClassDescriptor $this$onSerializableAnnotation$iv = descriptor;
            boolean $i$f$onSerializableAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
            if (ktAnnotationEntry != null) {
                String string;
                KtAnnotationEntry it = ktAnnotationEntry;
                boolean bl = false;
                PsiElement psiElement = (PsiElement)it;
                Object object = versions.getImplementationVersion();
                if (object == null || (object = object.toString()) == null) {
                    object = "too low";
                }
                if ((string = KotlinCompilerVersion.getVersion()) == null) {
                    string = "unknown";
                }
                trace.report((Diagnostic)SerializationErrors.PROVIDED_RUNTIME_TOO_LOW.on(psiElement, object, (Object)string, (Object)VersionReader.INSTANCE.getMINIMAL_SUPPORTED_VERSION().toString()));
            }
        }
    }

    private final void checkMinKotlin(VersionReader.RuntimeVersions versions, ClassDescriptor descriptor, BindingTrace trace) {
        block4: {
            Object object;
            Object object2;
            if (versions.currentCompilerMatchRequired()) {
                return;
            }
            SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
            ClassDescriptor $this$onSerializableAnnotation$iv = descriptor;
            boolean $i$f$onSerializableAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
            if (ktAnnotationEntry == null) break block4;
            KtAnnotationEntry it = ktAnnotationEntry;
            boolean bl = false;
            PsiElement psiElement = (PsiElement)it;
            String string = KotlinCompilerVersion.getVersion();
            if (string == null) {
                string = "too low";
            }
            if ((object2 = versions.getImplementationVersion()) == null || (object2 = object2.toString()) == null) {
                object2 = "unknown";
            }
            if ((object = versions.getRequireKotlinVersion()) == null || (object = object.toString()) == null) {
                object = "N/A";
            }
            trace.report((Diagnostic)SerializationErrors.REQUIRED_KOTLIN_TOO_HIGH.on(psiElement, (Object)string, object2, object));
        }
    }

    protected boolean isIde() {
        return false;
    }

    private final void checkCorrectTransientAnnotationIsUsed(ClassDescriptor descriptor, List<SerializableProperty> properties, BindingTrace trace) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = DescriptorUtilsKt.getSuperInterfaces((ClassDescriptor)descriptor);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it)).asString(), (Object)"java.io.Serializable")) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        for (SerializableProperty prop : properties) {
            PsiElement psiElement;
            FieldDescriptor fieldDescriptor;
            AnnotationDescriptor incorrectTransient;
            if (prop.getTransient() || (incorrectTransient = (fieldDescriptor = prop.getDescriptor().getBackingField()) != null && (fieldDescriptor = fieldDescriptor.getAnnotations()) != null ? fieldDescriptor.findAnnotation(JvmNames.TRANSIENT_ANNOTATION_FQ_NAME) : null) == null || (psiElement = PsiSourceElementKt.getPsi((SourceElement)incorrectTransient.getSource())) == null && (psiElement = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)prop.getDescriptor()))) == null) continue;
            PsiElement elementToReport = psiElement;
            trace.report((Diagnostic)SerializationErrors.INCORRECT_TRANSIENT.on(elementToReport));
        }
    }

    private final boolean canBeSerializedInternally(ClassDescriptor descriptor, KtDeclaration declaration, BindingTrace trace) {
        ClassDescriptor superClass;
        if (this.isSerializableEnumWithMissingSerializer(descriptor)) {
            KtModifierList ktModifierList = declaration.getModifierList();
            KtElement declarationToReport = ktModifierList == null ? (KtElement)declaration : (KtElement)ktModifierList;
            trace.report((Diagnostic)SerializationErrors.EXPLICIT_SERIALIZABLE_IS_REQUIRED.on((PsiElement)declarationToReport));
            return false;
        }
        if (!descriptor.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
            return false;
        }
        if (!this.serializationPluginEnabledOn(descriptor)) {
            DiagnosticFactory0<PsiElement> diagnosticFactory0 = SerializationErrors.PLUGIN_IS_NOT_ENABLED;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"PLUGIN_IS_NOT_ENABLED");
            this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
            return false;
        }
        if (this.isAnonymousObjectOrContained(descriptor)) {
            DiagnosticFactory0<PsiElement> diagnosticFactory0 = SerializationErrors.ANONYMOUS_OBJECTS_NOT_SUPPORTED;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"ANONYMOUS_OBJECTS_NOT_SUPPORTED");
            this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
            return false;
        }
        if (descriptor.isInner()) {
            DiagnosticFactory0<PsiElement> diagnosticFactory0 = SerializationErrors.INNER_CLASSES_NOT_SUPPORTED;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"INNER_CLASSES_NOT_SUPPORTED");
            this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
            return false;
        }
        if (InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)((DeclarationDescriptor)descriptor)) && !this.canSupportInlineClasses(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor)), trace)) {
            SerializationPluginDeclarationChecker declarationToReport = this;
            ClassDescriptor $this$onSerializableAnnotation$iv = descriptor;
            boolean $i$f$onSerializableAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
            if (ktAnnotationEntry != null) {
                KtAnnotationEntry it = ktAnnotationEntry;
                boolean bl = false;
                VersionReader.RuntimeVersions runtimeVersions = VersionReader.INSTANCE.getVersionsForCurrentModuleFromTrace(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor)), trace);
                trace.report((Diagnostic)SerializationErrors.INLINE_CLASSES_NOT_SUPPORTED.on((PsiElement)it, (Object)VersionReader.INSTANCE.getMinVersionForInlineClasses$kotlin_maven_serialization().toString(), (Object)String.valueOf(runtimeVersions != null ? runtimeVersions.getImplementationVersion() : null)));
            }
            return false;
        }
        if (!KSerializationUtilKt.getHasSerializableAnnotationWithoutArgs(descriptor)) {
            this.checkClassWithCustomSerializer(descriptor, declaration, trace);
            return false;
        }
        if (SerializationPluginDeclarationCheckerKt.getSerializableAnnotationIsUseless(descriptor)) {
            DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = SerializationErrors.SERIALIZABLE_ANNOTATION_IGNORED;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"SERIALIZABLE_ANNOTATION_IGNORED");
            this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
            return false;
        }
        if (!KSerializationUtilKt.isSerializableEnum(descriptor) && !KSerializationUtilKt.isInternalSerializable(superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)descriptor))) {
            Object v8;
            block13: {
                Collection collection = superClass.getConstructors();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"superClass.constructors");
                Iterable $this$singleOrNull$iv = collection;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv;
                    boolean bl = false;
                    if (!(it.getValueParameters().size() == 0)) continue;
                    if (found$iv) {
                        v8 = null;
                        break block13;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v8 = !found$iv ? null : single$iv;
            }
            if (v8 == null) {
                DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = SerializationErrors.NON_SERIALIZABLE_PARENT_MUST_HAVE_NOARG_CTOR;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"NON_SERIALIZABLE_PARENT_MUST_HAVE_NOARG_CTOR");
                this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
                return false;
            }
        }
        return true;
    }

    private final void checkClassWithCustomSerializer(ClassDescriptor descriptor, KtDeclaration declaration, BindingTrace trace) {
        KtAnnotationEntry annotationPsi = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)descriptor);
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor));
        SimpleType simpleType = descriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"descriptor.defaultType");
        this.checkCustomSerializerMatch(moduleDescriptor, (KotlinType)simpleType, (Annotated)descriptor, (KtElement)annotationPsi, trace, (PsiElement)declaration);
        this.checkCustomSerializerIsNotLocal(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor)), (Annotated)descriptor, trace, (PsiElement)declaration);
    }

    private final boolean isAnonymousObjectOrContained(ClassDescriptor $this$isAnonymousObjectOrContained) {
        for (DeclarationDescriptor current = (DeclarationDescriptor)$this$isAnonymousObjectOrContained; current != null; current = current.getContainingDeclaration()) {
            if (!DescriptorUtils.isAnonymousObject((DeclarationDescriptor)current)) continue;
            return true;
        }
        return false;
    }

    private final boolean isSerializableEnumWithMissingSerializer(ClassDescriptor $this$isSerializableEnumWithMissingSerializer) {
        boolean bl;
        block6: {
            if ($this$isSerializableEnumWithMissingSerializer.getKind() != ClassKind.ENUM_CLASS) {
                return false;
            }
            if ($this$isSerializableEnumWithMissingSerializer.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
                return false;
            }
            if (KSerializationUtilKt.getHasAnySerialAnnotation($this$isSerializableEnumWithMissingSerializer.getAnnotations())) {
                return true;
            }
            Iterable $this$any$iv = KSerializationUtilKt.enumEntries($this$isSerializableEnumWithMissingSerializer);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!KSerializationUtilKt.getHasAnySerialAnnotation(it.getAnnotations())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean serializationPluginEnabledOn(@NotNull ClassDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return true;
    }

    private final SerializableProperties buildSerializableProperties(ClassDescriptor descriptor, BindingTrace trace) {
        if (!descriptor.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
            return null;
        }
        if (!KSerializationUtilKt.isInternalSerializable(descriptor)) {
            return null;
        }
        if (KSerializationUtilKt.getHasCompanionObjectAsSerializer(descriptor)) {
            return null;
        }
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        SerializableProperties props = new SerializableProperties(descriptor, bindingContext);
        if (!props.isExternallySerializable()) {
            DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = SerializationErrors.PRIMARY_CONSTRUCTOR_PARAMETER_IS_NOT_A_PROPERTY;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"PRIMARY_CONSTRUCTOR_PARAMETER_IS_NOT_A_PROPERTY");
            this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
        }
        Set namesSet = new LinkedHashSet();
        Iterable $this$forEach$iv = props.getSerializableProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtAnnotationEntry a;
            SerializableProperty it = (SerializableProperty)element$iv;
            boolean bl = false;
            if (namesSet.add(it.getName())) continue;
            SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
            ClassDescriptor $this$onSerializableAnnotation$iv = descriptor;
            boolean $i$f$onSerializableAnnotation = false;
            if (KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv) == null) continue;
            boolean bl2 = false;
            trace.report((Diagnostic)SerializationErrors.DUPLICATE_SERIAL_NAME.on((PsiElement)a, (Object)it.getName()));
        }
        trace.record(SerializationPluginDeclarationCheckerKt.getSERIALIZABLE_PROPERTIES(), (Object)descriptor, (Object)props);
        return props;
    }

    private final void checkTransients(KtPureClassOrObject declaration, BindingTrace trace) {
        Map propertiesMap;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        Map<PropertyDescriptor, KtProperty> map = TypeUtilKt.bodyPropertiesDescriptorsMap(declaration, bindingContext, false);
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"trace.bindingContext");
        Map $this$forEach$iv = propertiesMap = MapsKt.plus(map, TypeUtilKt.primaryConstructorPropertiesDescriptorsMap(declaration, bindingContext2));
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            KtDeclaration declaration2 = (KtDeclaration)entry.getValue();
            boolean isInitialized = this.declarationHasInitializer(declaration2) || descriptor.isLateInit();
            boolean isMarkedTransient = KSerializationUtilKt.getSerialTransient(descriptor.getAnnotations());
            boolean hasBackingField = ResolveUtilKt.hasBackingField((PropertyDescriptor)descriptor, (BindingContext)trace.getBindingContext());
            if (!hasBackingField && isMarkedTransient) {
                KtAnnotationEntry transientPsi;
                AnnotationDescriptor annotationDescriptor = descriptor.getAnnotations().findAnnotation(SerializationAnnotations.INSTANCE.getSerialTransientFqName());
                LazyAnnotationDescriptor lazyAnnotationDescriptor = annotationDescriptor instanceof LazyAnnotationDescriptor ? (LazyAnnotationDescriptor)annotationDescriptor : null;
                KtAnnotationEntry ktAnnotationEntry = transientPsi = lazyAnnotationDescriptor != null ? lazyAnnotationDescriptor.getAnnotationEntry() : null;
                trace.report((Diagnostic)SerializationErrors.TRANSIENT_IS_REDUNDANT.on((PsiElement)(ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration2)));
            }
            if (!isMarkedTransient || isInitialized || !hasBackingField) continue;
            trace.report((Diagnostic)SerializationErrors.TRANSIENT_MISSING_INITIALIZER.on((PsiElement)declaration2));
        }
    }

    private final boolean declarationHasInitializer(KtDeclaration declaration) {
        KtDeclaration ktDeclaration = declaration;
        return ktDeclaration instanceof KtParameter ? ((KtParameter)declaration).hasDefaultValue() : (ktDeclaration instanceof KtProperty ? ((KtProperty)declaration).hasDelegateExpressionOrInitializer() : false);
    }

    private final void analyzePropertiesSerializers(BindingTrace trace, ClassDescriptor serializableClass, List<SerializableProperty> props) {
        BindingContext bindingContext = trace.getBindingContext();
        AbstractSerialGenerator generatorContextForAnalysis2 = new AbstractSerialGenerator(serializableClass, bindingContext){
            {
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$1, (String)"bindingContext");
                super($super_call_param$1, $serializableClass);
            }
        };
        Iterable $this$forEach$iv = props;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtTypeReference ktType;
            PsiElement propertyPsi;
            ClassDescriptor serializer;
            SerializableProperty it = (SerializableProperty)element$iv;
            boolean bl = false;
            KotlinType kotlinType = it.getSerializableWith();
            Object object = serializer = kotlinType != null ? KSerializationUtilKt.toClassDescriptor(kotlinType) : null;
            if (SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)it.getDescriptor())) == null) continue;
            KtCallableDeclaration ktCallableDeclaration = propertyPsi instanceof KtCallableDeclaration ? (KtCallableDeclaration)propertyPsi : null;
            Object object2 = ktType = ktCallableDeclaration != null ? ktCallableDeclaration.getTypeReference() : null;
            if (serializer != null) {
                KtTypeReference ktTypeReference = ktType;
                KtTypeElement element = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
                this.checkCustomSerializerMatch(it.getModule(), it.getType(), (Annotated)it.getDescriptor(), (KtElement)element, trace, propertyPsi);
                this.checkCustomSerializerIsNotLocal(it.getModule(), (Annotated)it.getDescriptor(), trace, propertyPsi);
                KotlinType kotlinType2 = it.getType();
                SimpleType simpleType = serializer.getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"serializer.defaultType");
                this.checkSerializerNullability(kotlinType2, (KotlinType)simpleType, element, trace, propertyPsi);
                this.checkTypeArguments(generatorContextForAnalysis2, it.getModule(), it.getType(), element, trace, propertyPsi);
                continue;
            }
            this.checkType(generatorContextForAnalysis2, it.getModule(), it.getType(), ktType, trace, propertyPsi);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeArguments(AbstractSerialGenerator $this$checkTypeArguments, ModuleDescriptor module, KotlinType type, KtTypeElement element, BindingTrace trace, PsiElement fallbackElement) {
        Iterable $this$forEachIndexed$iv = type.getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection = (TypeProjection)item$iv;
            int i = n;
            boolean bl = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
            Object object = element;
            this.checkType($this$checkTypeArguments, module, kotlinType, object != null && (object = object.getTypeArgumentsAsTypes()) != null ? (KtTypeReference)CollectionsKt.getOrNull((List)object, (int)i) : null, trace, fallbackElement);
        }
    }

    private final boolean isUnsupportedInlineType(KotlinType $this$isUnsupportedInlineType) {
        return InlineClassesUtilsKt.isInlineClassType((KotlinType)$this$isUnsupportedInlineType) && !KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType((KotlinType)$this$isUnsupportedInlineType);
    }

    private final boolean canSupportInlineClasses(ModuleDescriptor module, BindingTrace trace) {
        if (this.isIde()) {
            return true;
        }
        return VersionReader.INSTANCE.canSupportInlineClasses(module, trace);
    }

    private final void checkType(AbstractSerialGenerator $this$checkType, ModuleDescriptor module, KotlinType type, KtTypeReference ktType, BindingTrace trace, PsiElement fallbackElement) {
        ClassDescriptor serializer;
        KtTypeElement element;
        if (KSerializationUtilKt.getGenericIndex(type) != null) {
            return;
        }
        KtTypeReference ktTypeReference = ktType;
        Object object = element = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        if (this.isUnsupportedInlineType(type) && !this.canSupportInlineClasses(module, trace)) {
            KtTypeElement ktTypeElement = element;
            VersionReader.RuntimeVersions runtimeVersions = VersionReader.INSTANCE.getVersionsForCurrentModuleFromTrace(module, trace);
            trace.report((Diagnostic)SerializationErrors.INLINE_CLASSES_NOT_SUPPORTED.on(ktTypeElement != null ? (PsiElement)ktTypeElement : fallbackElement, (Object)VersionReader.INSTANCE.getMinVersionForInlineClasses$kotlin_maven_serialization().toString(), (Object)String.valueOf(runtimeVersions != null ? runtimeVersions.getImplementationVersion() : null)));
        }
        if ((serializer = TypeUtilKt.findTypeSerializerOrContextUnchecked($this$checkType, module, type)) != null) {
            this.checkCustomSerializerMatch(module, type, (Annotated)type, (KtElement)element, trace, fallbackElement);
            this.checkCustomSerializerIsNotLocal(module, (Annotated)type, trace, fallbackElement);
            SimpleType simpleType = serializer.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"serializer.defaultType");
            this.checkSerializerNullability(type, (KotlinType)simpleType, element, trace, fallbackElement);
            this.checkTypeArguments($this$checkType, module, type, element, trace, fallbackElement);
        } else {
            KtTypeElement ktTypeElement = element;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_NOT_FOUND.on(ktTypeElement != null ? (PsiElement)ktTypeElement : fallbackElement, (Object)type));
        }
    }

    private final void checkCustomSerializerMatch(ModuleDescriptor module, KotlinType classType, Annotated descriptor, KtElement element, BindingTrace trace, PsiElement fallbackElement) {
        Object object;
        Object v1;
        KotlinType serializerType;
        block4: {
            KotlinType kotlinType = KSerializationUtilKt.serializableWith(descriptor.getAnnotations(), module);
            if (kotlinType == null) {
                return;
            }
            serializerType = kotlinType;
            Iterable iterable = TypeUtilsKt.supertypes((KotlinType)serializerType);
            for (Object t : iterable) {
                KotlinType it = (KotlinType)t;
                boolean bl = false;
                if (!KSerializationUtilKt.isKSerializer(it)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        if ((object = (KotlinType)v1) == null || (object = object.getArguments()) == null || (object = (TypeProjection)CollectionsKt.first((List)object)) == null || (object = object.getType()) == null) {
            return;
        }
        Object serializerForType = object;
        if (!Intrinsics.areEqual((Object)classType.getConstructor(), (Object)serializerForType.getConstructor())) {
            KtElement ktElement = element;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_TYPE_INCOMPATIBLE.on(ktElement != null ? (PsiElement)ktElement : fallbackElement, (Object)classType, (Object)serializerType, serializerForType));
        }
    }

    private final void checkCustomSerializerIsNotLocal(ModuleDescriptor module, Annotated declaration, BindingTrace trace, PsiElement declarationElement) {
        KotlinType kotlinType = KSerializationUtilKt.serializableWith(declaration.getAnnotations(), module);
        if (kotlinType == null) {
            return;
        }
        KotlinType serializerType = kotlinType;
        ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor(serializerType);
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor serializerDescriptor = classDescriptor;
        if (DescriptorUtils.isLocal((DeclarationDescriptor)((DeclarationDescriptor)serializerDescriptor))) {
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration(declaration);
            PsiElement element = ktAnnotationEntry != null ? (PsiElement)ktAnnotationEntry : declarationElement;
            trace.report((Diagnostic)SerializationErrors.LOCAL_SERIALIZER_USAGE.on(element, (Object)serializerType));
        }
    }

    private final void checkSerializerNullability(KotlinType classType, KotlinType serializerType, KtTypeElement element, BindingTrace trace, PsiElement fallbackElement) {
        Object v0;
        block3: {
            Iterable iterable = TypeUtilsKt.supertypes((KotlinType)serializerType);
            for (Object t : iterable) {
                KotlinType it = (KotlinType)t;
                boolean bl = false;
                if (!KSerializationUtilKt.isKSerializer(it)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        KotlinType kotlinType = v0;
        if (kotlinType == null) {
            return;
        }
        KotlinType castedToKSerial = kotlinType;
        KotlinType kotlinType2 = ((TypeProjection)CollectionsKt.first((List)castedToKSerial.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"castedToKSerial.arguments.first().type");
        KotlinType serializerForType = kotlinType2;
        if (!classType.isMarkedNullable() && serializerForType.isMarkedNullable()) {
            KtTypeElement ktTypeElement = element;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_NULLABILITY_INCOMPATIBLE.on(ktTypeElement != null ? (PsiElement)ktTypeElement : fallbackElement, (Object)serializerType, (Object)classType));
        }
    }

    private final void onSerializableAnnotation(ClassDescriptor $this$onSerializableAnnotation, Function1<? super KtAnnotationEntry, Unit> report) {
        block0: {
            boolean $i$f$onSerializableAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation);
            if (ktAnnotationEntry == null) break block0;
            report.invoke((Object)ktAnnotationEntry);
        }
    }

    private final void reportOnSerializableAnnotation(BindingTrace $this$reportOnSerializableAnnotation, ClassDescriptor descriptor, DiagnosticFactory0<? super KtAnnotationEntry> error) {
        block0: {
            SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
            ClassDescriptor $this$onSerializableAnnotation$iv = descriptor;
            boolean $i$f$onSerializableAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
            if (ktAnnotationEntry == null) break block0;
            KtAnnotationEntry e = ktAnnotationEntry;
            boolean bl = false;
            $this$reportOnSerializableAnnotation.report((Diagnostic)error.on((PsiElement)e));
        }
    }
}

