/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.maven.KotlinCompilationFailureException;

public class MavenPluginLogMessageCollector
implements MessageCollector {
    private final Log log;
    private final ArrayList<Pair<CompilerMessageSourceLocation, String>> collectedErrors = new ArrayList();

    public MavenPluginLogMessageCollector(Log log) {
        this.log = (Log)Preconditions.checkNotNull((Object)log, (Object)"log shouldn't be null");
    }

    public boolean hasErrors() {
        return !this.collectedErrors.isEmpty();
    }

    @NotNull
    public List<Pair<CompilerMessageSourceLocation, String>> getCollectedErrors() {
        return Collections.unmodifiableList(this.collectedErrors);
    }

    public void clear() {
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        String position = location == null ? "" : location.getPath() + ": (" + location.getLine() + ", " + location.getColumn() + ") ";
        String text = position + message;
        switch (severity) {
            case EXCEPTION: 
            case ERROR: {
                this.collectedErrors.add((Pair<CompilerMessageSourceLocation, String>)new Pair((Object)location, (Object)message));
                this.log.error((CharSequence)text);
                break;
            }
            case STRONG_WARNING: 
            case WARNING: {
                this.log.warn((CharSequence)text);
                break;
            }
            case INFO: {
                this.log.info((CharSequence)text);
                break;
            }
            case LOGGING: 
            case OUTPUT: {
                this.log.debug((CharSequence)text);
                break;
            }
            default: {
                this.log.warn((CharSequence)("[Unknown severity " + severity + "] " + text));
            }
        }
    }

    public void throwKotlinCompilerException() throws KotlinCompilationFailureException {
        throw new KotlinCompilationFailureException(this.getCollectedErrors().stream().map(pair -> {
            CompilerMessageSourceLocation location = (CompilerMessageSourceLocation)pair.getFirst();
            String message = (String)pair.getSecond();
            if (location == null) {
                return new CompilerMessage(null, CompilerMessage.Kind.ERROR, 0, 0, 0, 0, message);
            }
            String lineContent = location.getLineContent();
            int lineContentLength = lineContent == null ? 0 : lineContent.length();
            return new CompilerMessage(location.getPath(), CompilerMessage.Kind.ERROR, MavenPluginLogMessageCollector.fixLocation(location.getLine()), MavenPluginLogMessageCollector.fixLocation(location.getColumn()), MavenPluginLogMessageCollector.fixLocation(location.getLine()), Math.min(MavenPluginLogMessageCollector.fixLocation(location.getColumn()), lineContentLength), message);
        }).collect(Collectors.toList()));
    }

    private static int fixLocation(int n) {
        if (n < 0) {
            return 0;
        }
        return n;
    }
}

