/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.impl.schema.DataFrameSchemaImpl;
import org.jetbrains.kotlinx.dataframe.impl.schema.UtilsKt;
import org.jetbrains.kotlinx.dataframe.schema.ColumnSchema;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0001\u001a(\u0010\u0005\u001a\u00020\u0006*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\bH\u0000\u001a(\u0010\f\u001a\u00020\u0001*\u00020\u00012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000b\u001a\u00020\bH\u0000\u00a8\u0006\u000f"}, d2={"compileTimeSchemaImpl", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "runtimeSchema", "klass", "Lkotlin/reflect/KClass;", "putColumnsOrder", "", "", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "", "schema", "path", "sortedBy", "order", "", "core"})
@SourceDebugExtension(value={"SMAP\nschema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 schema.kt\norg/jetbrains/kotlinx/dataframe/impl/api/SchemaKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,51:1\n1878#2,3:52\n1056#2:59\n126#3:55\n153#3,3:56\n*S KotlinDebug\n*F\n+ 1 schema.kt\norg/jetbrains/kotlinx/dataframe/impl/api/SchemaKt\n*L\n22#1:52,3\n46#1:59\n34#1:55\n34#1:56,3\n*E\n"})
public final class SchemaKt {
    @PublishedApi
    @NotNull
    public static final DataFrameSchema compileTimeSchemaImpl(@Nullable DataFrameSchema runtimeSchema, @NotNull KClass<?> klass) {
        Map map2;
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        DataFrameSchema compileSchema = UtilsKt.getSchema(klass);
        if (runtimeSchema == null) {
            return compileSchema;
        }
        ColumnPath root = new ColumnPath(CollectionsKt.emptyList());
        Map $this$compileTimeSchemaImpl_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        SchemaKt.putColumnsOrder($this$compileTimeSchemaImpl_u24lambda_u240, runtimeSchema, root);
        Map order = MapsKt.build((Map)map2);
        return SchemaKt.sortedBy(compileSchema, order, root);
    }

    public static final void putColumnsOrder(@NotNull Map<ColumnPath, Integer> $this$putColumnsOrder, @NotNull DataFrameSchema schema, @NotNull ColumnPath path) {
        Intrinsics.checkNotNullParameter($this$putColumnsOrder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Iterable $this$forEachIndexed$iv = schema.getColumns().entrySet();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry = (Map.Entry)item$iv;
            int i = n;
            boolean bl = false;
            String name = (String)entry.getKey();
            ColumnSchema column2 = (ColumnSchema)entry.getValue();
            ColumnPath columnPath = path.plus(name);
            $this$putColumnsOrder.put(columnPath, i);
            ColumnSchema columnSchema = column2;
            if (columnSchema instanceof ColumnSchema.Frame) {
                SchemaKt.putColumnsOrder($this$putColumnsOrder, ((ColumnSchema.Frame)column2).getSchema(), columnPath);
                continue;
            }
            if (columnSchema instanceof ColumnSchema.Group) {
                SchemaKt.putColumnsOrder($this$putColumnsOrder, ((ColumnSchema.Group)column2).getSchema(), columnPath);
                continue;
            }
            if (columnSchema instanceof ColumnSchema.Value) continue;
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DataFrameSchema sortedBy(@NotNull DataFrameSchema $this$sortedBy, @NotNull Map<ColumnPath, Integer> order, @NotNull ColumnPath path) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sortedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter(order, (String)"order");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object $this$map$iv = $this$sortedBy.getColumns();
        boolean $i$f$map = false;
        Map<String, ColumnSchema> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            ColumnSchema columnSchema;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)entry.getKey();
            ColumnSchema column2 = (ColumnSchema)entry.getValue();
            ColumnSchema columnSchema2 = column2;
            if (columnSchema2 instanceof ColumnSchema.Frame) {
                columnSchema = new ColumnSchema.Frame(SchemaKt.sortedBy(((ColumnSchema.Frame)column2).getSchema(), order, path.plus(name)), ((ColumnSchema.Frame)column2).getNullable(), ((ColumnSchema.Frame)column2).getContentType());
            } else if (columnSchema2 instanceof ColumnSchema.Group) {
                columnSchema = new ColumnSchema.Group(SchemaKt.sortedBy(((ColumnSchema.Group)column2).getSchema(), order, path.plus(name)), ((ColumnSchema.Group)column2).getContentType());
            } else if (columnSchema2 instanceof ColumnSchema.Value) {
                columnSchema = column2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(TuplesKt.to((Object)name, (Object)columnSchema));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Map sorted = MapsKt.toMap((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(order, path){
            final /* synthetic */ Map $order$inlined;
            final /* synthetic */ ColumnPath $path$inlined;
            {
                this.$order$inlined = map2;
                this.$path$inlined = columnPath;
            }

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                String name = (String)pair.component1();
                pair = (Pair)b;
                Comparable comparable = (Integer)this.$order$inlined.get(this.$path$inlined.plus(name));
                bl = false;
                name = (String)pair.component1();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Integer)this.$order$inlined.get(this.$path$inlined.plus(name))));
            }
        }));
        return new DataFrameSchemaImpl(sorted);
    }
}

