/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.api.DefaultsKt;
import org.jetbrains.kotlinx.dataframe.math.BasicStats;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"calculateBasicStatsOrNull", "Lorg/jetbrains/kotlinx/dataframe/math/BasicStats;", "Lkotlin/sequences/Sequence;", "", "skipNaN", "", "core"})
public final class BasicStatsKt {
    @Nullable
    public static final BasicStats calculateBasicStatsOrNull(@NotNull Sequence<Double> $this$calculateBasicStatsOrNull, boolean skipNaN) {
        Intrinsics.checkNotNullParameter($this$calculateBasicStatsOrNull, (String)"<this>");
        int count2 = 0;
        double sum = 0.0;
        Iterator iterator2 = $this$calculateBasicStatsOrNull.iterator();
        while (iterator2.hasNext()) {
            double element = ((Number)iterator2.next()).doubleValue();
            if (Double.isNaN(element)) {
                if (skipNaN) continue;
                return null;
            }
            sum += element;
            ++count2;
        }
        double mean = sum / (double)count2;
        double variance = 0.0;
        Iterator iterator3 = $this$calculateBasicStatsOrNull.iterator();
        while (iterator3.hasNext()) {
            double element = ((Number)iterator3.next()).doubleValue();
            if (Double.isNaN(element)) continue;
            double diff = element - mean;
            variance += diff * diff;
        }
        return new BasicStats(count2, mean, variance);
    }

    public static /* synthetic */ BasicStats calculateBasicStatsOrNull$default(Sequence sequence, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = DefaultsKt.getSkipNaNDefault();
        }
        return BasicStatsKt.calculateBasicStatsOrNull((Sequence<Double>)sequence, bl);
    }
}

