/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Collection;
import java.util.TreeSet;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;

public class GAVNameMapper
implements NameMapper {
    private final boolean fileSystemFriendly;
    private final String artifactPrefix;
    private final String artifactSuffix;
    private final String metadataPrefix;
    private final String metadataSuffix;
    private final String fieldSeparator;

    public GAVNameMapper(boolean fileSystemFriendly, String artifactPrefix, String artifactSuffix, String metadataPrefix, String metadataSuffix, String fieldSeparator) {
        this.fileSystemFriendly = fileSystemFriendly;
        String string = artifactPrefix;
        string.getClass();
        this.artifactPrefix = string;
        String string2 = artifactSuffix;
        string2.getClass();
        this.artifactSuffix = string2;
        String string3 = metadataPrefix;
        string3.getClass();
        this.metadataPrefix = string3;
        String string4 = metadataSuffix;
        string4.getClass();
        this.metadataSuffix = string4;
        String string5 = fieldSeparator;
        string5.getClass();
        this.fieldSeparator = string5;
    }

    @Override
    public boolean isFileSystemFriendly() {
        return this.fileSystemFriendly;
    }

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        TreeSet<String> keys = new TreeSet<String>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                keys.add(this.getArtifactName(artifact));
            }
        }
        if (metadatas != null) {
            for (Metadata metadata : metadatas) {
                keys.add(this.getMetadataName(metadata));
            }
        }
        return keys;
    }

    private String getArtifactName(Artifact artifact) {
        return this.artifactPrefix + artifact.getGroupId() + this.fieldSeparator + artifact.getArtifactId() + this.fieldSeparator + artifact.getBaseVersion() + this.artifactSuffix;
    }

    private String getMetadataName(Metadata metadata) {
        String name = this.metadataPrefix;
        if (!metadata.getGroupId().isEmpty()) {
            name = name + metadata.getGroupId();
            if (!metadata.getArtifactId().isEmpty()) {
                name = name + this.fieldSeparator + metadata.getArtifactId();
                if (!metadata.getVersion().isEmpty()) {
                    name = name + this.fieldSeparator + metadata.getVersion();
                }
            }
        }
        return name + this.metadataSuffix;
    }

    public static NameMapper gav() {
        return new GAVNameMapper(false, "artifact:", "", "metadata:", "", ":");
    }

    public static NameMapper fileGav() {
        return new GAVNameMapper(true, "", ".lock", "", ".lock", "~");
    }
}

