/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.metadata;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirDeclaration;
import org.jetbrains.kotlin.commonizer.cir.CirEntityId;
import org.jetbrains.kotlin.commonizer.cir.CirName;
import org.jetbrains.kotlin.commonizer.cir.CirPackageName;
import org.jetbrains.kotlin.commonizer.mergedtree.CirNode;
import org.jetbrains.kotlin.commonizer.mergedtree.CirNodeWithLiftingUp;
import org.jetbrains.kotlin.commonizer.mergedtree.CirRootNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\b\u0018\u0000 .2\u00020\u0001:\u0002./B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0003J\u0018\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J,\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020 2\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"H\u0086\b\u00a2\u0006\u0002\u0010#J,\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020 2\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$H\u0086\b\u00a2\u0006\u0002\u0010%J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0012J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext;", "", "targetIndex", "", "isCommon", "", "typeParameterIndexOffset", "currentPath", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path;", "(IZILorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path;)V", "getCurrentPath", "()Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path;", "()Z", "getTargetIndex", "()I", "getTypeParameterIndexOffset", "callableMemberContext", "memberName", "Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "ownerClassTypeParametersCount", "classifierContext", "classifierName", "outerClassTypeParametersCount", "component1", "component2", "component3", "component4", "copy", "equals", "other", "get", "T", "Lorg/jetbrains/kotlin/commonizer/cir/CirDeclaration;", "node", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirNode;", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirNode;)Lorg/jetbrains/kotlin/commonizer/cir/CirDeclaration;", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirNodeWithLiftingUp;", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirNodeWithLiftingUp;)Lorg/jetbrains/kotlin/commonizer/cir/CirDeclaration;", "hashCode", "moduleContext", "moduleName", "packageContext", "packageName", "Lorg/jetbrains/kotlin/commonizer/cir/CirPackageName;", "toString", "", "Companion", "Path", "kotlin-klib-commonizer"})
public final class CirTreeSerializationContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int targetIndex;
    private final boolean isCommon;
    private final int typeParameterIndexOffset;
    @NotNull
    private final Path currentPath;

    public CirTreeSerializationContext(int targetIndex, boolean isCommon, int typeParameterIndexOffset, @NotNull Path currentPath) {
        Intrinsics.checkNotNullParameter((Object)currentPath, (String)"currentPath");
        this.targetIndex = targetIndex;
        this.isCommon = isCommon;
        this.typeParameterIndexOffset = typeParameterIndexOffset;
        this.currentPath = currentPath;
    }

    public final int getTargetIndex() {
        return this.targetIndex;
    }

    public final boolean isCommon() {
        return this.isCommon;
    }

    public final int getTypeParameterIndexOffset() {
        return this.typeParameterIndexOffset;
    }

    @NotNull
    public final Path getCurrentPath() {
        return this.currentPath;
    }

    @NotNull
    public final CirTreeSerializationContext moduleContext(@NotNull CirName moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        if (!(this.currentPath instanceof Path.Empty)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        return new CirTreeSerializationContext(this.targetIndex, this.isCommon, 0, new Path.Module(moduleName));
    }

    @NotNull
    public final CirTreeSerializationContext packageContext(@NotNull CirPackageName packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (!(this.currentPath instanceof Path.Module)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        return new CirTreeSerializationContext(this.targetIndex, this.isCommon, 0, new Path.Package(packageName));
    }

    @NotNull
    public final CirTreeSerializationContext classifierContext(@NotNull CirName classifierName, int outerClassTypeParametersCount) {
        Path.Classifier classifier;
        Intrinsics.checkNotNullParameter((Object)classifierName, (String)"classifierName");
        Path path = this.currentPath;
        if (path instanceof Path.Package) {
            if (!(outerClassTypeParametersCount == 0)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            classifier = ((Path.Package)this.currentPath).nestedClassifier(classifierName);
        } else if (path instanceof Path.Classifier) {
            if (!(outerClassTypeParametersCount >= 0)) {
                String string3 = "Check failed.";
                throw new IllegalStateException(string3.toString());
            }
            classifier = ((Path.Classifier)this.currentPath).nestedClassifier(classifierName);
        } else {
            throw new IllegalStateException("Illegal state".toString());
        }
        Path.Classifier newPath = classifier;
        return new CirTreeSerializationContext(this.targetIndex, this.isCommon, this.typeParameterIndexOffset + outerClassTypeParametersCount, newPath);
    }

    public static /* synthetic */ CirTreeSerializationContext classifierContext$default(CirTreeSerializationContext cirTreeSerializationContext, CirName cirName, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return cirTreeSerializationContext.classifierContext(cirName, n);
    }

    @NotNull
    public final CirTreeSerializationContext callableMemberContext(@NotNull CirName memberName, int ownerClassTypeParametersCount) {
        Path.CallableMember callableMember;
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        Path path = this.currentPath;
        if (path instanceof Path.Package) {
            if (!(ownerClassTypeParametersCount == 0)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            callableMember = ((Path.Package)this.currentPath).nestedCallableMember(memberName);
        } else if (path instanceof Path.Classifier) {
            if (!(ownerClassTypeParametersCount >= 0)) {
                String string3 = "Check failed.";
                throw new IllegalStateException(string3.toString());
            }
            callableMember = ((Path.Classifier)this.currentPath).nestedCallableMember(memberName);
        } else {
            throw new IllegalStateException("Illegal state".toString());
        }
        Path.CallableMember newPath = callableMember;
        return new CirTreeSerializationContext(this.targetIndex, this.isCommon, this.typeParameterIndexOffset + ownerClassTypeParametersCount, newPath);
    }

    public static /* synthetic */ CirTreeSerializationContext callableMemberContext$default(CirTreeSerializationContext cirTreeSerializationContext, CirName cirName, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return cirTreeSerializationContext.callableMemberContext(cirName, n);
    }

    public final /* synthetic */ <T extends CirDeclaration> T get(CirNode<?, ?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        boolean $i$f$get = false;
        CirDeclaration cirDeclaration = this.isCommon() ? (CirDeclaration)node.getCommonDeclaration().invoke() : (CirDeclaration)node.getTargetDeclarations().get(this.getTargetIndex());
        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
        return (T)cirDeclaration;
    }

    public final /* synthetic */ <T extends CirDeclaration> T get(CirNodeWithLiftingUp<?, ?> node) {
        CirDeclaration cirDeclaration;
        Intrinsics.checkNotNullParameter(node, (String)"node");
        boolean $i$f$get = false;
        if (this.isCommon()) {
            Object object = node.getCommonDeclaration().invoke();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            cirDeclaration = (CirDeclaration)object;
        } else if (node.isLiftedUp()) {
            cirDeclaration = null;
        } else {
            Object t = node.getTargetDeclarations().get(this.getTargetIndex());
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            cirDeclaration = (CirDeclaration)t;
        }
        return (T)cirDeclaration;
    }

    public final int component1() {
        return this.targetIndex;
    }

    public final boolean component2() {
        return this.isCommon;
    }

    public final int component3() {
        return this.typeParameterIndexOffset;
    }

    @NotNull
    public final Path component4() {
        return this.currentPath;
    }

    @NotNull
    public final CirTreeSerializationContext copy(int targetIndex, boolean isCommon, int typeParameterIndexOffset, @NotNull Path currentPath) {
        Intrinsics.checkNotNullParameter((Object)currentPath, (String)"currentPath");
        return new CirTreeSerializationContext(targetIndex, isCommon, typeParameterIndexOffset, currentPath);
    }

    public static /* synthetic */ CirTreeSerializationContext copy$default(CirTreeSerializationContext cirTreeSerializationContext, int n, boolean bl, int n2, Path path, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = cirTreeSerializationContext.targetIndex;
        }
        if ((n3 & 2) != 0) {
            bl = cirTreeSerializationContext.isCommon;
        }
        if ((n3 & 4) != 0) {
            n2 = cirTreeSerializationContext.typeParameterIndexOffset;
        }
        if ((n3 & 8) != 0) {
            path = cirTreeSerializationContext.currentPath;
        }
        return cirTreeSerializationContext.copy(n, bl, n2, path);
    }

    @NotNull
    public String toString() {
        return "CirTreeSerializationContext(targetIndex=" + this.targetIndex + ", isCommon=" + this.isCommon + ", typeParameterIndexOffset=" + this.typeParameterIndexOffset + ", currentPath=" + this.currentPath + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.targetIndex);
        int n = this.isCommon ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + Integer.hashCode(this.typeParameterIndexOffset);
        result = result * 31 + this.currentPath.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CirTreeSerializationContext)) {
            return false;
        }
        CirTreeSerializationContext cirTreeSerializationContext = (CirTreeSerializationContext)other;
        if (this.targetIndex != cirTreeSerializationContext.targetIndex) {
            return false;
        }
        if (this.isCommon != cirTreeSerializationContext.isCommon) {
            return false;
        }
        if (this.typeParameterIndexOffset != cirTreeSerializationContext.typeParameterIndexOffset) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.currentPath, (Object)cirTreeSerializationContext.currentPath);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0005\b\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path;", "", "()V", "CallableMember", "Classifier", "Empty", "Module", "Package", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$Empty;", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$Module;", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$Package;", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$Classifier;", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$CallableMember;", "kotlin-klib-commonizer"})
    public static abstract class Path {
        private Path() {
        }

        public /* synthetic */ Path(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$Empty;", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path;", "()V", "toString", "", "kotlin-klib-commonizer"})
        public static final class Empty
        extends Path {
            @NotNull
            public static final Empty INSTANCE = new Empty();

            private Empty() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "";
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$Module;", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path;", "moduleName", "Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "(Lorg/jetbrains/kotlin/commonizer/cir/CirName;)V", "getModuleName", "()Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "toString", "", "kotlin-klib-commonizer"})
        public static final class Module
        extends Path {
            @NotNull
            private final CirName moduleName;

            public Module(@NotNull CirName moduleName) {
                Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
                super(null);
                this.moduleName = moduleName;
            }

            @NotNull
            public final CirName getModuleName() {
                return this.moduleName;
            }

            @NotNull
            public String toString() {
                return this.moduleName.toStrippedString();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$Package;", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path;", "packageName", "Lorg/jetbrains/kotlin/commonizer/cir/CirPackageName;", "(Lorg/jetbrains/kotlin/commonizer/cir/CirPackageName;)V", "getPackageName", "()Lorg/jetbrains/kotlin/commonizer/cir/CirPackageName;", "nestedCallableMember", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$CallableMember;", "memberName", "Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "nestedClassifier", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$Classifier;", "classifierName", "toString", "", "kotlin-klib-commonizer"})
        public static final class Package
        extends Path {
            @NotNull
            private final CirPackageName packageName;

            public Package(@NotNull CirPackageName packageName) {
                Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                super(null);
                this.packageName = packageName;
            }

            @NotNull
            public final CirPackageName getPackageName() {
                return this.packageName;
            }

            @NotNull
            public final Classifier nestedClassifier(@NotNull CirName classifierName) {
                Intrinsics.checkNotNullParameter((Object)classifierName, (String)"classifierName");
                return new Classifier(CirEntityId.Companion.create(this.packageName, classifierName));
            }

            @NotNull
            public final CallableMember nestedCallableMember(@NotNull CirName memberName) {
                Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
                return new CallableMember(CirEntityId.Companion.create(this.packageName, memberName));
            }

            @NotNull
            public String toString() {
                return this.packageName.toString();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\nJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$Classifier;", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path;", "classifierId", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "(Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;)V", "getClassifierId", "()Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "nestedCallableMember", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$CallableMember;", "memberName", "Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "nestedClassifier", "classifierName", "toString", "", "kotlin-klib-commonizer"})
        public static final class Classifier
        extends Path {
            @NotNull
            private final CirEntityId classifierId;

            public Classifier(@NotNull CirEntityId classifierId) {
                Intrinsics.checkNotNullParameter((Object)classifierId, (String)"classifierId");
                super(null);
                this.classifierId = classifierId;
            }

            @NotNull
            public final CirEntityId getClassifierId() {
                return this.classifierId;
            }

            @NotNull
            public final Classifier nestedClassifier(@NotNull CirName classifierName) {
                Intrinsics.checkNotNullParameter((Object)classifierName, (String)"classifierName");
                return new Classifier(this.classifierId.createNestedEntityId(classifierName));
            }

            @NotNull
            public final CallableMember nestedCallableMember(@NotNull CirName memberName) {
                Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
                return new CallableMember(this.classifierId.createNestedEntityId(memberName));
            }

            @NotNull
            public String toString() {
                return this.classifierId.toString();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path$CallableMember;", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Path;", "memberId", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "(Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;)V", "getMemberId", "()Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "toString", "", "kotlin-klib-commonizer"})
        public static final class CallableMember
        extends Path {
            @NotNull
            private final CirEntityId memberId;

            public CallableMember(@NotNull CirEntityId memberId) {
                Intrinsics.checkNotNullParameter((Object)memberId, (String)"memberId");
                super(null);
                this.memberId = memberId;
            }

            @NotNull
            public final CirEntityId getMemberId() {
                return this.memberId;
            }

            @NotNull
            public String toString() {
                return this.memberId.toString();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext$Companion;", "", "()V", "rootContext", "Lorg/jetbrains/kotlin/commonizer/metadata/CirTreeSerializationContext;", "rootNode", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirRootNode;", "targetIndex", "", "kotlin-klib-commonizer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CirTreeSerializationContext rootContext(@NotNull CirRootNode rootNode, int targetIndex) {
            Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
            CirNode.Companion companion = CirNode.Companion;
            CirNode $this$indexOfCommon$iv = rootNode;
            boolean $i$f$getIndexOfCommon = false;
            return new CirTreeSerializationContext(targetIndex, $this$indexOfCommon$iv.getTargetDeclarations().size() == targetIndex, 0, Path.Empty.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

