/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinPathsFromBaseDirectory;", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "basePath", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getBasePath", "()Ljava/io/File;", "homePath", "getHomePath", "libPath", "getLibPath", "jar", "Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;", "klib", "sourcesJar", "util"})
public class KotlinPathsFromBaseDirectory
implements KotlinPaths {
    @NotNull
    private final File basePath;

    public KotlinPathsFromBaseDirectory(@NotNull File basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.basePath = basePath;
    }

    @NotNull
    public final File getBasePath() {
        return this.basePath;
    }

    @Override
    @NotNull
    public File getHomePath() {
        throw new IllegalStateException("No home path defined");
    }

    @Override
    @NotNull
    public File getLibPath() {
        return this.basePath;
    }

    @Override
    @NotNull
    public File jar(@NotNull KotlinPaths.Jar jar) {
        Intrinsics.checkNotNullParameter((Object)((Object)jar), (String)"jar");
        return FilesKt.resolve((File)this.basePath, (String)(jar.getBaseName() + ".jar"));
    }

    @Override
    @NotNull
    public File klib(@NotNull KotlinPaths.Jar jar) {
        Intrinsics.checkNotNullParameter((Object)((Object)jar), (String)"jar");
        return FilesKt.resolve((File)this.basePath, (String)(jar.getBaseName() + ".klib"));
    }

    @Override
    @Nullable
    public File sourcesJar(@NotNull KotlinPaths.Jar jar) {
        Intrinsics.checkNotNullParameter((Object)((Object)jar), (String)"jar");
        return FilesKt.resolve((File)this.basePath, (String)(jar.getBaseName() + "-sources.jar"));
    }
}

