/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.UpperBoundChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.jvm.checkers.EnhancedNullabilityInfo;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.WarningAwareUpperBoundChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.AbstractNullabilityChecker;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.NotNullTypeParameter;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerState;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerStateKt;
import org.jetbrains.kotlin.types.checker.KotlinTypePreparator;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerImpl;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 12\u00020\u0001:\u00011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J$\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J,\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J,\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016Jf\u0010\u001f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\"\u001a\u00020#26\u0010$\u001a2\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\t0%H\u0002J&\u0010)\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\"\u001a\u00020#H\u0002JI\u0010*\u001a\u0004\u0018\u0001H+\"\b\b\u0000\u0010+*\u00020,2\u0006\u0010-\u001a\u00020\r2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H+0\u0015H\u0002\u00a2\u0006\u0002\u00100R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00062\u00b2\u0006\n\u0010.\u001a\u00020\u0016X\u008a\u0084\u0002\u00b2\u0006\n\u0010.\u001a\u00020\u0016X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "upperBoundChecker", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "<init>", "(Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "getUpperBoundChecker", "()Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkTypeParameterBounds", "findTypeParameterWithWrongBoundsNullability", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "dataFlowValueForWholeExpression", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "checkReceiver", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "safeAccess", "", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "doCheckType", "expectedType", "expressionTypeDataFlowValue", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "reportWarning", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "actualType", "exactedExpressionTypeByDataFlowNullability", "doIfNotNull", "T", "", "type", "dataFlowValue", "body", "(Lorg/jetbrains/kotlin/types/KotlinType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "frontend.java"})
public final class JavaNullabilityChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UpperBoundChecker upperBoundChecker;
    @NotNull
    private static final NewKotlinTypeCheckerImpl typeCheckerForEnhancedTypes = new NewKotlinTypeCheckerImpl(KotlinTypeRefiner.Default.INSTANCE, new KotlinTypePreparator(){

        public UnwrappedType prepareType(KotlinTypeMarker type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            UnwrappedType it = super.prepareType(type);
            boolean bl = false;
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(it);
            if (kotlinType == null) {
                kotlinType = it;
            }
            return kotlinType.unwrap();
        }
    });
    @NotNull
    private static final NewKotlinTypeCheckerImpl typeCheckerForBaseTypes = new NewKotlinTypeCheckerImpl(KotlinTypeRefiner.Default.INSTANCE, null, 2, null);

    public JavaNullabilityChecker(@NotNull UpperBoundChecker upperBoundChecker) {
        Intrinsics.checkNotNullParameter((Object)upperBoundChecker, (String)"upperBoundChecker");
        this.upperBoundChecker = upperBoundChecker;
    }

    @NotNull
    public final UpperBoundChecker getUpperBoundChecker() {
        return this.upperBoundChecker;
    }

    public void checkType(@NotNull KtExpression expression, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        IElementType iElementType;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        this.checkTypeParameterBounds(expression, expressionType, c);
        Lazy dataFlowValue$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> JavaNullabilityChecker.checkType$lambda$0(c, expression, expressionType));
        TypeParameterDescriptor typeParameterDescriptor = this.findTypeParameterWithWrongBoundsNullability(expressionType, c, (Function0<DataFlowValue>)((Function0)() -> JavaNullabilityChecker.checkType$lambda$2(dataFlowValue$delegate)));
        if (typeParameterDescriptor != null) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            boolean bl = false;
            c.trace.report((Diagnostic)ErrorsJvm.NULLABLE_TYPE_PARAMETER_AGAINST_NOT_NULL_TYPE_PARAMETER.on((PsiElement)expression, (Object)typeParameterDescriptor2));
        }
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        Function0 function0 = () -> JavaNullabilityChecker.checkType$lambda$4(dataFlowValue$delegate);
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
        this.doCheckType(expressionType, kotlinType, (Function0<DataFlowValue>)function0, dataFlowInfo, (Function2<? super KotlinType, ? super KotlinType, Unit>)((Function2)(arg_0, arg_1) -> JavaNullabilityChecker.checkType$lambda$5(c, expression, arg_0, arg_1)));
        KtExpression ktExpression = expression;
        if (ktExpression instanceof KtWhenExpression) {
            if (((KtWhenExpression)expression).getElseExpression() == null) {
                KtExpression ktExpression2 = ((KtWhenExpression)expression).getSubjectExpression();
                if (ktExpression2 == null) {
                    return;
                }
                KtExpression subjectExpression = ktExpression2;
                KotlinType kotlinType2 = c.trace.getType(subjectExpression);
                if (kotlinType2 == null) {
                    return;
                }
                KotlinType type = kotlinType2;
                if (FlexibleTypesKt.isFlexible(type) && TypeUtils.isNullableType(FlexibleTypesKt.asFlexibleType(type).getUpperBound())) {
                    ClassDescriptor classDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum((KotlinType)type);
                    if (classDescriptor == null) {
                        return;
                    }
                    ClassDescriptor enumClassDescriptor = classDescriptor;
                    BindingContext bindingContext = c.trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                    BindingContext context = bindingContext;
                    if (WhenChecker.getEnumMissingCases((KtWhenExpression)((KtWhenExpression)expression), (BindingContext)context, (ClassDescriptor)enumClassDescriptor).isEmpty() && !WhenChecker.INSTANCE.containsNullCase((KtWhenExpression)expression, context)) {
                        DataFlowInfo dataFlowInfo2;
                        DataFlowValue subjectDataFlowValue = c.dataFlowValueFactory.createDataFlowValue(subjectExpression, type, c);
                        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)c.trace.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)subjectExpression);
                        Object object = dataFlowInfo2 = kotlinTypeInfo != null ? kotlinTypeInfo.getDataFlowInfo() : null;
                        if (dataFlowInfo2 != null && !dataFlowInfo2.getStableNullability(subjectDataFlowValue).canBeNull()) {
                            return;
                        }
                        BindingTrace bindingTrace = c.trace;
                        KtExpression ktExpression3 = ((KtWhenExpression)expression).getSubjectExpression();
                        Intrinsics.checkNotNull((Object)ktExpression3);
                        bindingTrace.report((Diagnostic)ErrorsJvm.WHEN_ENUM_CAN_BE_NULL_IN_JAVA.on((PsiElement)ktExpression3));
                    }
                }
            }
        } else if (ktExpression instanceof KtPostfixExpression) {
            if (Intrinsics.areEqual((Object)((KtPostfixExpression)expression).getOperationToken(), (Object)KtTokens.EXCLEXCL)) {
                KtExpression ktExpression4 = ((KtPostfixExpression)expression).getBaseExpression();
                if (ktExpression4 == null) {
                    return;
                }
                KtExpression baseExpression = ktExpression4;
                KotlinType kotlinType3 = c.trace.getType(baseExpression);
                if (kotlinType3 == null) {
                    return;
                }
                KotlinType baseExpressionType = kotlinType3;
                this.doIfNotNull(baseExpressionType, (Function0<DataFlowValue>)((Function0)() -> JavaNullabilityChecker.checkType$lambda$6(c, baseExpression, baseExpressionType)), c, () -> JavaNullabilityChecker.checkType$lambda$7(c, expression, baseExpressionType));
            }
        } else if (ktExpression instanceof KtBinaryExpression && (Intrinsics.areEqual((Object)(iElementType = ((KtBinaryExpression)expression).getOperationToken()), (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ)) && ((KtBinaryExpression)expression).getLeft() != null && ((KtBinaryExpression)expression).getRight() != null) {
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)expression;
            KtExpression ktExpression5 = ((KtBinaryExpression)expression).getLeft();
            Intrinsics.checkNotNull((Object)ktExpression5);
            KtExpression ktExpression6 = ((KtBinaryExpression)expression).getRight();
            Intrinsics.checkNotNull((Object)ktExpression6);
            SenselessComparisonChecker.checkSenselessComparisonWithNull((KtBinaryExpression)ktBinaryExpression, (KtExpression)ktExpression5, (KtExpression)ktExpression6, c, arg_0 -> JavaNullabilityChecker.checkType$lambda$8(c, arg_0), arg_0 -> JavaNullabilityChecker.checkType$lambda$11(this, c, arg_0));
        }
    }

    private final void checkTypeParameterBounds(KtExpression expression, KotlinType expressionType, ResolutionContext<?> c) {
        if (expressionType instanceof AbbreviatedType) {
            KotlinType kotlinType = ((AbbreviatedType)expressionType).getExpandedType();
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            this.upperBoundChecker.checkBoundsOfExpandedTypeAlias(kotlinType, expression, bindingTrace);
        }
        if (!(this.upperBoundChecker instanceof WarningAwareUpperBoundChecker)) {
            return;
        }
        BasicCallResolutionContext basicCallResolutionContext = c instanceof BasicCallResolutionContext ? (BasicCallResolutionContext)c : null;
        if (basicCallResolutionContext == null || (basicCallResolutionContext = basicCallResolutionContext.call) == null) {
            KtCallExpression ktCallExpression = expression instanceof KtCallExpression ? (KtCallExpression)expression : null;
            basicCallResolutionContext = (Call)c.trace.getBindingContext().get((ReadOnlySlice)BindingContext.CALL, ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null);
            if (basicCallResolutionContext == null) {
                return;
            }
        }
        BasicCallResolutionContext call = basicCallResolutionContext;
        ResolvedCall resolvedCall = (ResolvedCall)c.trace.getBindingContext().get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call);
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        Iterable typeArguments = resolvedCall2 instanceof NewResolvedCallImpl ? (Iterable)((NewResolvedCallImpl)resolvedCall2).getResolvedCallAtom().getTypeArgumentMappingByOriginal() : (Iterable)resolvedCall2.getTypeArguments().entrySet();
        for (Map.Entry entry : typeArguments) {
            TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)entry.getKey();
            KotlinType typeArgument = (KotlinType)entry.getValue();
            List list = call.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeArguments(...)");
            KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.getOrNull((List)list, (int)typeParameter.getIndex());
            if (ktTypeProjection == null || (ktTypeProjection = ktTypeProjection.getTypeReference()) == null) continue;
            KtTypeProjection typeReference = ktTypeProjection;
            if (typeArgument == null) continue;
            WarningAwareUpperBoundChecker warningAwareUpperBoundChecker = (WarningAwareUpperBoundChecker)this.upperBoundChecker;
            TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(typeArgument);
            Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(...)");
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            WarningAwareUpperBoundChecker.checkBounds$default(warningAwareUpperBoundChecker, (KtTypeReference)typeReference, typeArgument, typeParameter, typeSubstitutor2, bindingTrace, null, true, null, 160, null);
        }
    }

    private final TypeParameterDescriptor findTypeParameterWithWrongBoundsNullability(KotlinType expressionType, ResolutionContext<?> c, Function0<DataFlowValue> dataFlowValueForWholeExpression) {
        if (c.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitUsingNullableTypeParameterAgainstNotNullAnnotated)) {
            return null;
        }
        if (TypeUtils.noExpectedType(c.expectedType)) {
            return null;
        }
        Ref.ObjectRef foundSubtypeTypeParameter = new Ref.ObjectRef();
        TypeCheckerState typeState2 = new ClassicTypeCheckerState(c, dataFlowValueForWholeExpression, (Ref.ObjectRef<TypeParameterDescriptor>)foundSubtypeTypeParameter){
            private boolean expectsTypeArgument;
            final /* synthetic */ ResolutionContext<?> $c;
            final /* synthetic */ Function0<DataFlowValue> $dataFlowValueForWholeExpression;
            final /* synthetic */ Ref.ObjectRef<TypeParameterDescriptor> $foundSubtypeTypeParameter;
            {
                this.$c = $c;
                this.$dataFlowValueForWholeExpression = $dataFlowValueForWholeExpression;
                this.$foundSubtypeTypeParameter = $foundSubtypeTypeParameter;
                super(true, false, null, null, null, 30, null);
            }

            public boolean customIsSubtypeOf(KotlinTypeMarker subType, KotlinTypeMarker superType) {
                Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
                Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
                if (JavaNullabilityChecker.Companion.isNullableTypeAgainstNotNullTypeParameter((KotlinType)subType, (KotlinType)superType) && (this.expectsTypeArgument || this.$c.dataFlowInfo.getStableNullability((DataFlowValue)this.$dataFlowValueForWholeExpression.invoke()) != Nullability.NOT_NULL)) {
                    ClassifierDescriptor classifierDescriptor = ((KotlinType)subType).getConstructor().getDeclarationDescriptor();
                    this.$foundSubtypeTypeParameter.element = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
                    return false;
                }
                if (!this.expectsTypeArgument) {
                    this.expectsTypeArgument = true;
                }
                return true;
            }
        };
        KotlinTypeMarker kotlinTypeMarker = expressionType;
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeState2, kotlinTypeMarker, (KotlinTypeMarker)kotlinType, false, 8, null);
        return (TypeParameterDescriptor)foundSubtypeTypeParameter.element;
    }

    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)receiverParameter, (String)"receiverParameter");
        Intrinsics.checkNotNullParameter((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Lazy dataFlowValue$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> JavaNullabilityChecker.checkReceiver$lambda$12(c, receiverArgument));
        if (safeAccess) {
            ASTNode aSTNode = c.call.getCallOperationNode();
            if (aSTNode == null || (aSTNode = aSTNode.getPsi()) == null) {
                return;
            }
            ASTNode safeAccessElement = aSTNode;
            KotlinType kotlinType = receiverArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            this.doIfNotNull(kotlinType, (Function0<DataFlowValue>)((Function0)() -> JavaNullabilityChecker.checkReceiver$lambda$14(dataFlowValue$delegate)), (ResolutionContext)c, () -> JavaNullabilityChecker.checkReceiver$lambda$15(c, (PsiElement)safeAccessElement, receiverArgument));
            return;
        }
        KotlinType kotlinType = receiverArgument.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType kotlinType2 = receiverParameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        Function0 function0 = () -> JavaNullabilityChecker.checkReceiver$lambda$16(dataFlowValue$delegate);
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
        this.doCheckType(kotlinType, kotlinType2, (Function0<DataFlowValue>)function0, dataFlowInfo, (Function2<? super KotlinType, ? super KotlinType, Unit>)((Function2)(arg_0, arg_1) -> JavaNullabilityChecker.checkReceiver$lambda$17(receiverArgument, c, arg_0, arg_1)));
    }

    private final void doCheckType(KotlinType expressionType, KotlinType expectedType, Function0<DataFlowValue> expressionTypeDataFlowValue, DataFlowInfo dataFlowInfo, Function2<? super KotlinType, ? super KotlinType, Unit> reportWarning) {
        if (TypeUtils.noExpectedType(expectedType)) {
            return;
        }
        KotlinType expressionType2 = this.exactedExpressionTypeByDataFlowNullability(expressionType, expressionTypeDataFlowValue, dataFlowInfo);
        boolean isEnhancedExpectedTypeSubtypeOfExpressionType = typeCheckerForEnhancedTypes.isSubtypeOf(expressionType2, expectedType);
        if (isEnhancedExpectedTypeSubtypeOfExpressionType) {
            return;
        }
        boolean isExpectedTypeSubtypeOfExpressionType = typeCheckerForBaseTypes.isSubtypeOf(expressionType2, expectedType);
        if (!isEnhancedExpectedTypeSubtypeOfExpressionType && isExpectedTypeSubtypeOfExpressionType) {
            reportWarning.invoke((Object)TypeWithEnhancementKt.unwrapEnhancementDeeply(expectedType), (Object)TypeWithEnhancementKt.unwrapEnhancementDeeply(expressionType2));
        }
    }

    private final KotlinType exactedExpressionTypeByDataFlowNullability(KotlinType expressionType, Function0<DataFlowValue> expressionTypeDataFlowValue, DataFlowInfo dataFlowInfo) {
        boolean isNotNullByDataFlowInfo = dataFlowInfo.getStableNullability((DataFlowValue)expressionTypeDataFlowValue.invoke()) == Nullability.NOT_NULL;
        return KotlinTypeKt.isNullable(expressionType) && isNotNullByDataFlowInfo ? TypeUtilsKt.makeNotNullable(expressionType) : expressionType;
    }

    private final <T> T doIfNotNull(KotlinType type, Function0<DataFlowValue> dataFlowValue, ResolutionContext<?> c, Function0<? extends T> body) {
        EnhancedNullabilityInfo enhancedNullabilityInfo = JavaNullabilityCheckerKt.mustNotBeNull(type);
        return (T)((enhancedNullabilityInfo != null ? enhancedNullabilityInfo.isFromJava() : false) && c.dataFlowInfo.getStableNullability((DataFlowValue)dataFlowValue.invoke()).canBeNull() ? body.invoke() : null);
    }

    private static final DataFlowValue checkType$lambda$0(ResolutionContext $c, KtExpression $expression, KotlinType $expressionType) {
        return $c.dataFlowValueFactory.createDataFlowValue($expression, $expressionType, $c);
    }

    private static final DataFlowValue checkType$lambda$1(Lazy<DataFlowValue> $dataFlowValue$delegate) {
        Lazy<DataFlowValue> lazy = $dataFlowValue$delegate;
        return (DataFlowValue)lazy.getValue();
    }

    private static final DataFlowValue checkType$lambda$2(Lazy $dataFlowValue$delegate) {
        return JavaNullabilityChecker.checkType$lambda$1((Lazy<DataFlowValue>)$dataFlowValue$delegate);
    }

    private static final DataFlowValue checkType$lambda$4(Lazy $dataFlowValue$delegate) {
        return JavaNullabilityChecker.checkType$lambda$1((Lazy<DataFlowValue>)$dataFlowValue$delegate);
    }

    private static final Unit checkType$lambda$5(ResolutionContext $c, KtExpression $expression, KotlinType expectedType, KotlinType actualType) {
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
        $c.trace.report((Diagnostic)ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((PsiElement)$expression, (Object)expectedType, (Object)actualType));
        return Unit.INSTANCE;
    }

    private static final DataFlowValue checkType$lambda$6(ResolutionContext $c, KtExpression $baseExpression, KotlinType $baseExpressionType) {
        return $c.dataFlowValueFactory.createDataFlowValue($baseExpression, $baseExpressionType, $c);
    }

    private static final Unit checkType$lambda$7(ResolutionContext $c, KtExpression $expression, KotlinType $baseExpressionType) {
        $c.trace.report((Diagnostic)Errors.UNNECESSARY_NOT_NULL_ASSERTION.on((PsiElement)((KtPostfixExpression)$expression).getOperationReference(), (Object)$baseExpressionType));
        return Unit.INSTANCE;
    }

    private static final KotlinType checkType$lambda$8(ResolutionContext $c, KtExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $c.trace.getType(it);
    }

    private static final DataFlowValue checkType$lambda$11$lambda$9(DataFlowValue $value) {
        return $value;
    }

    private static final Nullability checkType$lambda$11$lambda$10() {
        return Nullability.NOT_NULL;
    }

    private static final Nullability checkType$lambda$11(JavaNullabilityChecker this$0, ResolutionContext $c, DataFlowValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Nullability nullability = (Nullability)this$0.doIfNotNull(value2.getType(), (Function0<DataFlowValue>)((Function0)() -> JavaNullabilityChecker.checkType$lambda$11$lambda$9(value2)), $c, JavaNullabilityChecker::checkType$lambda$11$lambda$10);
        if (nullability == null) {
            nullability = Nullability.UNKNOWN;
        }
        return nullability;
    }

    private static final DataFlowValue checkReceiver$lambda$12(CallResolutionContext $c, ReceiverValue $receiverArgument) {
        return $c.dataFlowValueFactory.createDataFlowValue($receiverArgument, (ResolutionContext)$c);
    }

    private static final DataFlowValue checkReceiver$lambda$13(Lazy<DataFlowValue> $dataFlowValue$delegate) {
        Lazy<DataFlowValue> lazy = $dataFlowValue$delegate;
        return (DataFlowValue)lazy.getValue();
    }

    private static final DataFlowValue checkReceiver$lambda$14(Lazy $dataFlowValue$delegate) {
        return JavaNullabilityChecker.checkReceiver$lambda$13((Lazy<DataFlowValue>)$dataFlowValue$delegate);
    }

    private static final Unit checkReceiver$lambda$15(CallResolutionContext $c, PsiElement $safeAccessElement, ReceiverValue $receiverArgument) {
        $c.trace.report((Diagnostic)Errors.UNNECESSARY_SAFE_CALL.on($safeAccessElement, (Object)$receiverArgument.getType()));
        return Unit.INSTANCE;
    }

    private static final DataFlowValue checkReceiver$lambda$16(Lazy $dataFlowValue$delegate) {
        return JavaNullabilityChecker.checkReceiver$lambda$13((Lazy<DataFlowValue>)$dataFlowValue$delegate);
    }

    private static final Unit checkReceiver$lambda$17(ReceiverValue $receiverArgument, CallResolutionContext $c, KotlinType expectedType, KotlinType actualType) {
        KtExpression receiverExpression;
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
        ExpressionReceiver expressionReceiver = $receiverArgument instanceof ExpressionReceiver ? (ExpressionReceiver)$receiverArgument : null;
        Object object = receiverExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (receiverExpression != null) {
            $c.trace.report((Diagnostic)ErrorsJvm.RECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((PsiElement)receiverExpression, (Object)actualType));
        } else {
            KtExpression ktExpression = $c.call.getCalleeExpression();
            KtElement ktElement = ktExpression != null ? (KtElement)ktExpression : $c.call.getCallElement();
            Intrinsics.checkNotNull((Object)ktElement);
            KtElement reportOn = ktElement;
            $c.trace.report((Diagnostic)ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((PsiElement)reportOn, (Object)expectedType, (Object)actualType));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker$Companion;", "", "<init>", "()V", "typeCheckerForEnhancedTypes", "Lorg/jetbrains/kotlin/types/checker/NewKotlinTypeCheckerImpl;", "getTypeCheckerForEnhancedTypes", "()Lorg/jetbrains/kotlin/types/checker/NewKotlinTypeCheckerImpl;", "typeCheckerForBaseTypes", "getTypeCheckerForBaseTypes", "isNullableTypeAgainstNotNullTypeParameter", "", "subType", "Lorg/jetbrains/kotlin/types/KotlinType;", "superType", "frontend.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NewKotlinTypeCheckerImpl getTypeCheckerForEnhancedTypes() {
            return typeCheckerForEnhancedTypes;
        }

        @NotNull
        public final NewKotlinTypeCheckerImpl getTypeCheckerForBaseTypes() {
            return typeCheckerForBaseTypes;
        }

        public final boolean isNullableTypeAgainstNotNullTypeParameter(@NotNull KotlinType subType, @NotNull KotlinType superType) {
            Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
            Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
            if (!(superType instanceof NotNullTypeParameter) || subType instanceof NotNullTypeParameter) {
                return false;
            }
            return !AbstractNullabilityChecker.INSTANCE.isSubtypeOfAny(ClassicTypeCheckerStateKt.createClassicTypeCheckerState$default(true, false, null, null, null, 30, null), (KotlinTypeMarker)subType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

