/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.diagnostics;

import com.android.build.gradle.BaseExtension;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.AndroidGradlePluginVersion;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollectorKt;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.utils.AndroidPluginIdsKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ#\u0010\r\u001a\u00020\b*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0014\u0010\u0013\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck;", "", "()V", "minimalBuiltInKotlinSupportedAgpVersion", "Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "getMinimalBuiltInKotlinSupportedAgpVersion", "()Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "checkIfNewDslIsUsed", "", "Lorg/gradle/api/Project;", "isKmpProject", "", "checkIfNewDslIsUsed$kotlin_gradle_plugin_common", "reportKotlinAndroidDeprecation", "diagnostic", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "agpVersionProvider", "Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck$AndroidGradlePluginVersionProvider;", "reportKotlinAndroidDeprecation$kotlin_gradle_plugin_common", "runAgpWithBuiltInKotlinIfAppliedCheck", "AndroidGradlePluginVersionProvider", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nAgpWithBuiltInKotlinAppliedCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgpWithBuiltInKotlinAppliedCheck.kt\norg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1851#2,2:107\n1851#2,2:109\n*S KotlinDebug\n*F\n+ 1 AgpWithBuiltInKotlinAppliedCheck.kt\norg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck\n*L\n55#1:107,2\n79#1:109,2\n*E\n"})
public final class AgpWithBuiltInKotlinAppliedCheck {
    @NotNull
    public static final AgpWithBuiltInKotlinAppliedCheck INSTANCE = new AgpWithBuiltInKotlinAppliedCheck();
    @NotNull
    private static final AndroidGradlePluginVersion minimalBuiltInKotlinSupportedAgpVersion = new AndroidGradlePluginVersion(9, 0, 0, "alpha01");

    private AgpWithBuiltInKotlinAppliedCheck() {
    }

    @NotNull
    public final AndroidGradlePluginVersion getMinimalBuiltInKotlinSupportedAgpVersion() {
        return minimalBuiltInKotlinSupportedAgpVersion;
    }

    public final void runAgpWithBuiltInKotlinIfAppliedCheck(@NotNull Project $this$runAgpWithBuiltInKotlinIfAppliedCheck, @NotNull AndroidGradlePluginVersionProvider agpVersionProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$runAgpWithBuiltInKotlinIfAppliedCheck, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)agpVersionProvider, (String)"agpVersionProvider");
        boolean isKotlinAndroidExtensionExists = KotlinProjectExtensionKt.getKotlinAndroidExtensionOrNull($this$runAgpWithBuiltInKotlinIfAppliedCheck) != null;
        AndroidGradlePluginVersion agpVersion = agpVersionProvider.get();
        if (isKotlinAndroidExtensionExists && agpVersion != null && agpVersion.compareTo(minimalBuiltInKotlinSupportedAgpVersion) >= 0) {
            Project project = $this$runAgpWithBuiltInKotlinIfAppliedCheck.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            File file2 = $this$runAgpWithBuiltInKotlinIfAppliedCheck.getProject().getBuildFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.buildFile");
            File file3 = $this$runAgpWithBuiltInKotlinIfAppliedCheck.getProject().getRootDir();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"project.rootDir");
            KotlinToolingDiagnosticsCollectorKt.reportDiagnostic(project, KotlinToolingDiagnostics.AgpWithBuiltInKotlinIsAlreadyApplied.INSTANCE.invoke(FilesKt.relativeTo((File)file2, (File)file3), new Throwable()));
        }
        this.checkIfNewDslIsUsed$kotlin_gradle_plugin_common($this$runAgpWithBuiltInKotlinIfAppliedCheck, false);
        String string = $this$runAgpWithBuiltInKotlinIfAppliedCheck.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        this.reportKotlinAndroidDeprecation$kotlin_gradle_plugin_common($this$runAgpWithBuiltInKotlinIfAppliedCheck, KotlinToolingDiagnostics.DeprecatedKotlinAndroidPlugin.INSTANCE.invoke(string), agpVersionProvider);
    }

    public static /* synthetic */ void runAgpWithBuiltInKotlinIfAppliedCheck$default(AgpWithBuiltInKotlinAppliedCheck agpWithBuiltInKotlinAppliedCheck, Project project, AndroidGradlePluginVersionProvider androidGradlePluginVersionProvider, int n, Object object) {
        if ((n & 1) != 0) {
            androidGradlePluginVersionProvider = AndroidGradlePluginVersionProvider.Default.INSTANCE;
        }
        agpWithBuiltInKotlinAppliedCheck.runAgpWithBuiltInKotlinIfAppliedCheck(project, androidGradlePluginVersionProvider);
    }

    public final void checkIfNewDslIsUsed$kotlin_gradle_plugin_common(@NotNull Project $this$checkIfNewDslIsUsed, boolean isKmpProject) {
        Intrinsics.checkNotNullParameter((Object)$this$checkIfNewDslIsUsed, (String)"<this>");
        AtomicBoolean wasChecked = new AtomicBoolean(false);
        Iterable $this$forEach$iv = AndroidPluginIdsKt.getAndroidPluginIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String agpPluginId = (String)element$iv;
            boolean bl = false;
            $this$checkIfNewDslIsUsed.getPlugins().withId(agpPluginId, new Action(wasChecked, $this$checkIfNewDslIsUsed, isKmpProject, agpPluginId){
                final /* synthetic */ AtomicBoolean $wasChecked;
                final /* synthetic */ Project $this_checkIfNewDslIsUsed;
                final /* synthetic */ boolean $isKmpProject;
                final /* synthetic */ String $agpPluginId;
                {
                    this.$wasChecked = $wasChecked;
                    this.$this_checkIfNewDslIsUsed = $receiver;
                    this.$isKmpProject = $isKmpProject;
                    this.$agpPluginId = $agpPluginId;
                }

                public final void execute(Plugin it) {
                    if (!this.$wasChecked.getAndSet(true)) {
                        try {
                            Object object = this.$this_checkIfNewDslIsUsed.getProject().getExtensions().getByName("android");
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
                            BaseExtension cfr_ignored_0 = (BaseExtension)object;
                        }
                        catch (ClassCastException e) {
                            Project project = this.$this_checkIfNewDslIsUsed.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                            KotlinToolingDiagnosticsCollectorKt.reportDiagnostic(project, this.$isKmpProject ? KotlinToolingDiagnostics.KMPIsIncompatibleWithTheNewAgpDsl.INSTANCE.invoke(this.$agpPluginId, e) : KotlinToolingDiagnostics.KotlinAndroidIsIncompatibleWithTheNewAgpDsl.INSTANCE.invoke(e));
                        }
                    }
                }
            });
        }
    }

    public final void reportKotlinAndroidDeprecation$kotlin_gradle_plugin_common(@NotNull Project $this$reportKotlinAndroidDeprecation, @NotNull ToolingDiagnostic diagnostic, @NotNull AndroidGradlePluginVersionProvider agpVersionProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$reportKotlinAndroidDeprecation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)agpVersionProvider, (String)"agpVersionProvider");
        AtomicBoolean wasChecked = new AtomicBoolean(false);
        Iterable $this$forEach$iv = AndroidPluginIdsKt.getAndroidPluginIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String agpPluginId = (String)element$iv;
            boolean bl = false;
            $this$reportKotlinAndroidDeprecation.getPlugins().withId(agpPluginId, new Action(wasChecked, agpVersionProvider, $this$reportKotlinAndroidDeprecation, diagnostic){
                final /* synthetic */ AtomicBoolean $wasChecked;
                final /* synthetic */ AndroidGradlePluginVersionProvider $agpVersionProvider;
                final /* synthetic */ Project $this_reportKotlinAndroidDeprecation;
                final /* synthetic */ ToolingDiagnostic $diagnostic;
                {
                    this.$wasChecked = $wasChecked;
                    this.$agpVersionProvider = $agpVersionProvider;
                    this.$this_reportKotlinAndroidDeprecation = $receiver;
                    this.$diagnostic = $diagnostic;
                }

                public final void execute(Plugin it) {
                    AndroidGradlePluginVersion androidVersion;
                    if (!this.$wasChecked.getAndSet(true) && (androidVersion = this.$agpVersionProvider.get()) != null && androidVersion.compareTo(AgpWithBuiltInKotlinAppliedCheck.INSTANCE.getMinimalBuiltInKotlinSupportedAgpVersion()) >= 0) {
                        Project project = this.$this_reportKotlinAndroidDeprecation.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                        KotlinToolingDiagnosticsCollectorKt.reportDiagnosticOncePerProject$default(project, this.$diagnostic, null, 2, null);
                    }
                }
            });
        }
    }

    public static /* synthetic */ void reportKotlinAndroidDeprecation$kotlin_gradle_plugin_common$default(AgpWithBuiltInKotlinAppliedCheck agpWithBuiltInKotlinAppliedCheck, Project project, ToolingDiagnostic toolingDiagnostic, AndroidGradlePluginVersionProvider androidGradlePluginVersionProvider, int n, Object object) {
        if ((n & 2) != 0) {
            androidGradlePluginVersionProvider = AndroidGradlePluginVersionProvider.Default.INSTANCE;
        }
        agpWithBuiltInKotlinAppliedCheck.reportKotlinAndroidDeprecation$kotlin_gradle_plugin_common(project, toolingDiagnostic, androidGradlePluginVersionProvider);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u0004J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck$AndroidGradlePluginVersionProvider;", "", "get", "Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "Default", "kotlin-gradle-plugin_common"})
    public static interface AndroidGradlePluginVersionProvider {
        @Nullable
        public AndroidGradlePluginVersion get();

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck$AndroidGradlePluginVersionProvider$Default;", "Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck$AndroidGradlePluginVersionProvider;", "()V", "get", "Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "kotlin-gradle-plugin_common"})
        public static final class Default
        implements AndroidGradlePluginVersionProvider {
            @NotNull
            public static final Default INSTANCE = new Default();

            private Default() {
            }

            @Override
            @Nullable
            public AndroidGradlePluginVersion get() {
                return AndroidGradlePluginVersion.Companion.getCurrentOrNull();
            }
        }
    }
}

