/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.gradle.internal.utils.Printer;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.CompilationTransactionKt;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.TrackedLookupMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.FileToIdMap;
import org.jetbrains.kotlin.incremental.storage.IdToFileMap;
import org.jetbrains.kotlin.incremental.storage.LookupMap;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;

@Metadata(k=1, mv={2, 0, 0}, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u0000 F2\u00020\u0001:\u0001FB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ/\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0017\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b \u0010\u001aJ\r\u0010!\u001a\u00020\u0012\u00a2\u0006\u0004\b!\u0010\u001aJ\u001b\u0010#\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u0010\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%R\u001c\u0010(\u001a\u00070&\u00a2\u0006\u0002\b'8\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u0014\u0010/\u001a\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u00100\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0014\u00103\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00106\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0014\u00109\u001a\u0002088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010;\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0016\u0010=\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010<R\u0017\u0010A\u001a\b\u0012\u0004\u0012\u00020>0\u00108F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0017\u0010C\u001a\b\u0012\u0004\u0012\u00020>0\u00108F\u00a2\u0006\u0006\u001a\u0004\bB\u0010@R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020>0\n8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "Ljava/io/File;", "targetDataDir", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "icContext", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "lookupSymbol", "", "", "get", "(Lorg/jetbrains/kotlin/incremental/LookupSymbol;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/com/intellij/util/containers/MultiMap;", "lookups", "", "allPaths", "", "addAll", "(Lorg/jetbrains/kotlin/com/intellij/util/containers/MultiMap;Ljava/util/Set;)V", "Lkotlin/sequences/Sequence;", "files", "removeLookupsFrom", "(Lkotlin/sequences/Sequence;)V", "deleteStorageFiles", "()V", "close", "file", "", "addFileIfNeeded", "(Ljava/io/File;)I", "removeGarbageForTests", "forceGC", "lookupSymbols", "dump", "(Ljava/util/Set;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "", "getTrackChanges", "()Z", "trackChanges", "countersFile", "Ljava/io/File;", "Lorg/jetbrains/kotlin/incremental/storage/IdToFileMap;", "idToFile", "Lorg/jetbrains/kotlin/incremental/storage/IdToFileMap;", "Lorg/jetbrains/kotlin/incremental/storage/FileToIdMap;", "fileToId", "Lorg/jetbrains/kotlin/incremental/storage/FileToIdMap;", "Lorg/jetbrains/kotlin/incremental/TrackedLookupMap;", "lookupMap", "Lorg/jetbrains/kotlin/incremental/TrackedLookupMap;", "size", "I", "oldSize", "Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;", "getAddedLookupSymbols", "()Ljava/util/Set;", "addedLookupSymbols", "getRemovedLookupSymbols", "removedLookupSymbols", "getLookupSymbols", "()Ljava/util/Collection;", "Companion", "kotlin-build-common"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
@SourceDebugExtension(value={"SMAP\nLookupStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookupStorage.kt\norg/jetbrains/kotlin/incremental/LookupStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,343:1\n1#2:344\n1#2:368\n1634#3,3:345\n774#3:348\n865#3,2:349\n1285#3,2:351\n1299#3,4:353\n1056#3:357\n1617#3,9:358\n1869#3:367\n1870#3:369\n1626#3:370\n1491#3:371\n1516#3,3:372\n1519#3,3:382\n1563#3:385\n1634#3,3:386\n1563#3:389\n1634#3,3:390\n382#4,7:375\n*S KotlinDebug\n*F\n+ 1 LookupStorage.kt\norg/jetbrains/kotlin/incremental/LookupStorage\n*L\n186#1:368\n122#1:345,3\n171#1:348\n171#1:349,2\n174#1:351,2\n174#1:353,4\n180#1:357\n186#1:358,9\n186#1:367\n186#1:369\n186#1:370\n216#1:371\n216#1:372,3\n216#1:382,3\n222#1:385\n222#1:386,3\n227#1:389\n227#1:390,3\n216#1:375,7\n*E\n"})
public class LookupStorage
extends BasicMapsOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IncrementalCompilationContext icContext;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final File countersFile;
    @NotNull
    private final IdToFileMap idToFile;
    @NotNull
    private final FileToIdMap fileToId;
    @NotNull
    private final TrackedLookupMap lookupMap;
    private volatile int size;
    private int oldSize;
    private static final double DELETED_TO_SIZE_THRESHOLD = 0.5;
    private static final int MINIMUM_GARBAGE_COLLECTIBLE_SIZE = 10000;

    public LookupStorage(@NotNull File targetDataDir, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)targetDataDir, (String)"targetDataDir");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(targetDataDir);
        this.icContext = icContext;
        Logger logger2 = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.LOG = logger2;
        this.countersFile = this.getStorageFile("counters");
        this.idToFile = (IdToFileMap)this.registerMap((BasicMap)new IdToFileMap(this.getStorageFile("id-to-file"), this.icContext));
        this.fileToId = (FileToIdMap)this.registerMap((BasicMap)new FileToIdMap(this.getStorageFile("file-to-id"), this.icContext));
        this.lookupMap = new TrackedLookupMap((LookupMap)this.registerMap((BasicMap)new LookupMap(this.getStorageFile("lookups"), this.icContext)), this.getTrackChanges());
        try {
            if (this.countersFile.exists()) {
                List lines = FilesKt.readLines$default((File)this.countersFile, null, (int)1, null);
                Object object = (String)CollectionsKt.firstOrNull((List)lines);
                if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                    throw new IOException(this.countersFile + " exists, but it is empty. Counters file is corrupted");
                }
                this.oldSize = this.size = ((Integer)object).intValue();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Could not read " + this.countersFile, e);
        }
    }

    @NotNull
    public final Logger getLOG() {
        return this.LOG;
    }

    private final boolean getTrackChanges() {
        return this.icContext.getTrackChangesInLookupCache();
    }

    @NotNull
    public final Set<LookupSymbolKey> getAddedLookupSymbols() {
        LookupStorage $this$_get_addedLookupSymbols__u24lambda_u240 = this;
        boolean bl = false;
        if (!$this$_get_addedLookupSymbols__u24lambda_u240.getTrackChanges()) {
            boolean bl2 = false;
            String string = "trackChanges is not enabled";
            throw new IllegalStateException(string.toString());
        }
        Set<LookupSymbolKey> set = $this$_get_addedLookupSymbols__u24lambda_u240.lookupMap.getAddedKeys();
        Intrinsics.checkNotNull(set);
        return set;
    }

    @NotNull
    public final Set<LookupSymbolKey> getRemovedLookupSymbols() {
        LookupStorage $this$_get_removedLookupSymbols__u24lambda_u240 = this;
        boolean bl = false;
        if (!$this$_get_removedLookupSymbols__u24lambda_u240.getTrackChanges()) {
            boolean bl2 = false;
            String string = "trackChanges is not enabled";
            throw new IllegalStateException(string.toString());
        }
        Set<LookupSymbolKey> set = $this$_get_removedLookupSymbols__u24lambda_u240.lookupMap.getRemovedKeys();
        Intrinsics.checkNotNull(set);
        return set;
    }

    @NotNull
    public final Collection<LookupSymbolKey> getLookupSymbols() {
        return this.lookupMap.getKeys();
    }

    @NotNull
    public final synchronized Collection<String> get(@NotNull LookupSymbol lookupSymbol) {
        Intrinsics.checkNotNullParameter((Object)lookupSymbol, (String)"lookupSymbol");
        LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
        Set<Integer> set = this.lookupMap.get(key);
        if (set == null) {
            return SetsKt.emptySet();
        }
        Set<Integer> fileIds = set;
        Set paths = new LinkedHashSet();
        Set filtered = new LinkedHashSet();
        Iterator<Integer> iterator2 = fileIds.iterator();
        while (iterator2.hasNext()) {
            int fileId = ((Number)iterator2.next()).intValue();
            File file2 = (File)this.idToFile.get(fileId);
            String path = file2 != null ? file2.getPath() : null;
            if (path == null) continue;
            paths.add(path);
            filtered.add(fileId);
        }
        if (this.size > 10000 && (double)filtered.size() / (double)fileIds.size() < 0.5) {
            this.lookupMap.set(key, filtered);
        }
        return paths;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void addAll(@NotNull MultiMap<LookupSymbol, String> lookups, @NotNull Set<String> allPaths) {
        Intrinsics.checkNotNullParameter(lookups, (String)"lookups");
        Intrinsics.checkNotNullParameter(allPaths, (String)"allPaths");
        Map pathToId = org.jetbrains.kotlin.gradle.internal.utils.CollectionsKt.keysToMap(CollectionsKt.sorted((Iterable)allPaths), arg_0 -> LookupStorage.addAll$lambda$0(this, arg_0));
        Set set = lookups.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        for (LookupSymbol lookupSymbol : CollectionsKt.sorted((Iterable)set)) {
            void $this$mapTo$iv;
            Collection paths;
            LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
            Intrinsics.checkNotNullExpressionValue((Object)lookups.get((Object)lookupSymbol), (String)"get(...)");
            Iterable iterable = paths;
            Collection destination$iv = new TreeSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string = (String)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                Object v = pathToId.get(it);
                Intrinsics.checkNotNull(v);
                collection.add(((Number)v).intValue());
            }
            TreeSet fileIds = (TreeSet)destination$iv;
            this.lookupMap.append(key, fileIds);
        }
    }

    public final synchronized void removeLookupsFrom(@NotNull Sequence<? extends File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        for (File file2 : files2) {
            Integer n = (Integer)this.fileToId.get(file2);
            if (n == null) {
                continue;
            }
            int id = n;
            this.idToFile.remove(id);
            this.fileToId.remove(file2);
        }
    }

    @Override
    public synchronized void deleteStorageFiles() {
        CompilationTransaction compilationTransaction = this.icContext.getTransaction();
        Path path = this.countersFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        compilationTransaction.deleteFile(path);
        this.size = 0;
        super.deleteStorageFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            if (this.size != this.oldSize && this.size > 0) {
                CompilationTransaction compilationTransaction = this.icContext.getTransaction();
                Path path = this.countersFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                CompilationTransactionKt.writeText(compilationTransaction, path, this.size + "\n0");
            }
        }
        finally {
            super.close();
        }
    }

    private final int addFileIfNeeded(File file2) {
        Integer existing = (Integer)this.fileToId.get(file2);
        if (existing != null) {
            return existing;
        }
        int n = this.size;
        this.size = n + 1;
        int id = n;
        this.fileToId.set(file2, id);
        this.idToFile.set(id, file2);
        return id;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeGarbageForTests() {
        void $this$associateWithTo$iv$iv;
        Object object;
        Iterable $this$filterTo$iv$iv;
        Object destination$iv$iv;
        Object object2;
        LookupSymbolKey lookupSymbolKey;
        for (LookupSymbolKey hash : this.lookupMap.getKeys()) {
            void $this$filter$iv;
            Set<Integer> set = this.lookupMap.get(hash);
            Intrinsics.checkNotNull(set);
            Iterable iterable = set;
            lookupSymbolKey = hash;
            object2 = this.lookupMap;
            boolean $i$f$filter = false;
            void var5_8 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!this.idToFile.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = (List)destination$iv$iv;
            ((TrackedLookupMap)object2).set(lookupSymbolKey, CollectionsKt.toSet((Iterable)((Iterable)object)));
        }
        Iterable $this$associateWith$iv = this.fileToId.getKeys();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        $this$filterTo$iv$iv = $this$associateWith$iv;
        destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            File it = (File)element$iv$iv;
            lookupSymbolKey = element$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            Object VALUE = this.fileToId.get(it);
            Intrinsics.checkNotNull(VALUE);
            object = ((Number)VALUE).intValue();
            object2.put(lookupSymbolKey, object);
        }
        Object oldFileToId = destination$iv$iv;
        HashMap oldIdToNewId = new HashMap(oldFileToId.size());
        this.idToFile.clear();
        this.fileToId.clear();
        this.size = 0;
        Object $this$sortedBy$iv2 = oldFileToId.entrySet();
        boolean $i$f$sortedBy = false;
        for (Object $this$sortedBy$iv2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((File)it.getKey()).getPath());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((File)it.getKey()).getPath())));
            }
        })) {
            File file2 = (File)$this$sortedBy$iv2.getKey();
            int oldId = ((Number)$this$sortedBy$iv2.getValue()).intValue();
            int newId = this.addFileIfNeeded(file2);
            ((Map)oldIdToNewId).put(oldId, newId);
        }
        for (LookupSymbolKey lookup : this.lookupMap.getKeys()) {
            void $this$mapNotNullTo$iv$iv;
            Set<Integer> set = this.lookupMap.get(lookup);
            Intrinsics.checkNotNull(set);
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                int it = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                if ((Integer)oldIdToNewId.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Set fileIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            if (fileIds.isEmpty()) {
                this.lookupMap.remove(lookup);
                continue;
            }
            this.lookupMap.set(lookup, fileIds);
        }
    }

    public final void forceGC() {
        this.removeGarbageForTests();
        this.flush();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump(@NotNull Set<LookupSymbol> lookupSymbols) {
        Comparable<LookupSymbolKey> key$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(lookupSymbols, (String)"lookupSymbols");
        this.flush();
        StringBuilder sb = new StringBuilder();
        Printer p = new Printer(sb, 0, null, 6, null);
        Object[] objectArray = new Object[]{"====== File to id map"};
        p.println(objectArray);
        objectArray = new Object[]{this.fileToId.dump()};
        p.println(objectArray);
        objectArray = new Object[]{"====== Id to file map"};
        p.println(objectArray);
        objectArray = new Object[]{this.idToFile.dump()};
        p.println(objectArray);
        Iterable $this$groupBy$iv = lookupSymbols;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            LookupSymbol it = (LookupSymbol)element$iv$iv;
            boolean bl = false;
            LookupSymbolKey key$iv$iv = new LookupSymbolKey(it.getName(), it.getScope());
            Map map = destination$iv$iv;
            key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map lookupsStrings = destination$iv$iv;
        for (LookupSymbolKey lookup : CollectionsKt.sorted((Iterable)this.lookupMap.getKeys())) {
            void $this$mapTo$iv$iv;
            Set<Integer> fileIds;
            String string;
            int n;
            Iterable iterable2;
            Iterable destination$iv$iv2;
            Intrinsics.checkNotNull(this.lookupMap.get(lookup));
            if (lookupsStrings.containsKey(lookup)) {
                void $this$mapTo$iv$iv2;
                Object v = lookupsStrings.get(lookup);
                Intrinsics.checkNotNull(v);
                Iterable $this$map$iv = (Iterable)v;
                boolean $i$f$map = false;
                Iterable element$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    key$iv$iv$iv = (LookupSymbol)item$iv$iv;
                    iterable2 = destination$iv$iv2;
                    n = 0;
                    iterable2.add(it.getScope() + '#' + it.getName());
                }
                string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            } else {
                string = lookup.toString();
            }
            String key = string;
            Iterable $this$map$iv = fileIds;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                n = ((Number)item$iv$iv).intValue();
                iterable2 = destination$iv$iv3;
                boolean bl = false;
                iterable2.add(String.valueOf((int)it));
            }
            String value2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv3)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            Object[] objectArray2 = new Object[]{key + " -> " + value2};
            p.println(objectArray2);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final int addAll$lambda$0(LookupStorage this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.addFileIfNeeded(new File(it));
    }

    @Metadata(k=1, mv={2, 0, 0}, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage$Companion;", "", "<init>", "()V", "", "DELETED_TO_SIZE_THRESHOLD", "D", "", "MINIMUM_GARBAGE_COLLECTIBLE_SIZE", "I", "kotlin-build-common"}, xi=48)
    @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

