/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.toolchain;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionCommonizerLock;
import org.jetbrains.kotlin.gradle.targets.native.toolchain.NativeVersionValueSource;
import org.jetbrains.kotlin.org.apache.commons.io.file.FilesUncheck;
import org.jetbrains.kotlin.tooling.core.KotlinToolingVersion;
import org.jetbrains.kotlin.tooling.core.KotlinToolingVersionKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b \u0018\u0000 \u00132\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H\u0016J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/toolchain/NativeVersionValueSource;", "Lorg/gradle/api/provider/ValueSource;", "", "Lorg/jetbrains/kotlin/gradle/targets/native/toolchain/NativeVersionValueSource$Params;", "()V", "obtain", "prepareKotlinNativeBundle", "", "kotlinNativeBundleConfiguration", "Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlinNativeVersion", "bundleDir", "Ljava/io/File;", "reinstallFlag", "", "processToolchain", "removeBundleIfNeeded", "resolveKotlinNativeConfiguration", "kotlinNativeCompilerConfiguration", "Companion", "Params", "kotlin-gradle-plugin_common"})
public abstract class NativeVersionValueSource
implements ValueSource<String, Params> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean canBeReinstalled = true;
    @NotNull
    public static final String MARKER_FILE = "provisioned.ok";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.jetbrains.kotlin.gradle.targets.native.toolchain");

    @NotNull
    public String obtain() {
        String kotlinNativeVersion2 = (String)((Params)this.getParameters()).getKotlinNativeVersion().get();
        Object object = ((Params)this.getParameters()).getKotlinNativeCompilerConfiguration().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.kotlinNativeCompilerConfiguration.get()");
        ConfigurableFileCollection configurableFileCollection = (ConfigurableFileCollection)object;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinNativeVersion2, (String)"kotlinNativeVersion");
        File file2 = new File((String)((Params)this.getParameters()).getBundleDirectory().get());
        Object object2 = ((Params)this.getParameters()).getReinstallBundle().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.reinstallBundle.get()");
        this.prepareKotlinNativeBundle(configurableFileCollection, kotlinNativeVersion2, file2, (Boolean)object2);
        return kotlinNativeVersion2;
    }

    private final void prepareKotlinNativeBundle(ConfigurableFileCollection kotlinNativeBundleConfiguration, String kotlinNativeVersion2, File bundleDir, boolean reinstallFlag) {
        this.processToolchain(bundleDir, reinstallFlag, kotlinNativeVersion2, kotlinNativeBundleConfiguration);
    }

    private final void processToolchain(File bundleDir, boolean reinstallFlag, String kotlinNativeVersion2, ConfigurableFileCollection kotlinNativeBundleConfiguration) {
        NativeDistributionCommonizerLock lock2 = new NativeDistributionCommonizerLock(bundleDir, (Function1<? super String, Unit>)((Function1)processToolchain.lock.1.INSTANCE));
        lock2.withLock((Function1)new Function1<File, Unit>(this, reinstallFlag, bundleDir, kotlinNativeVersion2, kotlinNativeBundleConfiguration){
            final /* synthetic */ NativeVersionValueSource this$0;
            final /* synthetic */ boolean $reinstallFlag;
            final /* synthetic */ File $bundleDir;
            final /* synthetic */ String $kotlinNativeVersion;
            final /* synthetic */ ConfigurableFileCollection $kotlinNativeBundleConfiguration;
            {
                this.this$0 = $receiver;
                this.$reinstallFlag = $reinstallFlag;
                this.$bundleDir = $bundleDir;
                this.$kotlinNativeVersion = $kotlinNativeVersion;
                this.$kotlinNativeBundleConfiguration = $kotlinNativeBundleConfiguration;
                super(1);
            }

            public final void invoke(File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = ((Params)this.this$0.getParameters()).getSimpleKotlinNativeVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.simpleKotlinNativeVersion.get()");
                boolean needToReinstall = NativeVersionValueSource.Companion.isSnapshotVersion$kotlin_gradle_plugin_common((String)object);
                if (needToReinstall) {
                    NativeVersionValueSource.Companion.getLogger().debug("Snapshot version could be changed, to be sure that up-to-date version is used, Kotlin/Native should be reinstalled");
                }
                NativeVersionValueSource.access$removeBundleIfNeeded(this.this$0, this.$reinstallFlag || needToReinstall, this.$bundleDir);
                if (!FilesKt.resolve((File)this.$bundleDir, (String)"provisioned.ok").exists()) {
                    File gradleCachesKotlinNativeDir = NativeVersionValueSource.access$resolveKotlinNativeConfiguration(this.this$0, this.$kotlinNativeVersion, this.$kotlinNativeBundleConfiguration);
                    NativeVersionValueSource.Companion.copyNativeBundleDistribution$kotlin_gradle_plugin_common(gradleCachesKotlinNativeDir, this.$bundleDir);
                }
            }
        });
    }

    private final void removeBundleIfNeeded(boolean reinstallFlag, File bundleDir) {
        if (reinstallFlag && canBeReinstalled) {
            logger.info("Removing Kotlin/Native bundle");
            FilesKt.deleteRecursively((File)bundleDir);
            canBeReinstalled = false;
        }
    }

    private final File resolveKotlinNativeConfiguration(String kotlinNativeVersion2, ConfigurableFileCollection kotlinNativeCompilerConfiguration) {
        File file2;
        String resolutionErrorMessage = "Kotlin Native dependency has not been properly resolved. Please, make sure that you've declared the repository, which contains " + kotlinNativeVersion2 + '.';
        File file3 = (File)CollectionsKt.singleOrNull((Iterable)((Iterable)kotlinNativeCompilerConfiguration));
        if (file3 == null || (file2 = FilesKt.resolve((File)file3, (String)kotlinNativeVersion2)) == null) {
            throw new IllegalStateException(resolutionErrorMessage.toString());
        }
        File gradleCachesKotlinNativeDir = file2;
        if (!gradleCachesKotlinNativeDir.exists()) {
            throw new IllegalStateException("Kotlin Native bundle dependency was used. Please provide the corresponding version in 'kotlin.native.version' property instead of any other ways.".toString());
        }
        return gradleCachesKotlinNativeDir;
    }

    public static final /* synthetic */ void access$removeBundleIfNeeded(NativeVersionValueSource $this, boolean reinstallFlag, File bundleDir) {
        $this.removeBundleIfNeeded(reinstallFlag, bundleDir);
    }

    public static final /* synthetic */ File access$resolveKotlinNativeConfiguration(NativeVersionValueSource $this, String kotlinNativeVersion2, ConfigurableFileCollection kotlinNativeCompilerConfiguration) {
        return $this.resolveKotlinNativeConfiguration(kotlinNativeVersion2, kotlinNativeCompilerConfiguration);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0015\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/toolchain/NativeVersionValueSource$Companion;", "", "()V", "MARKER_FILE", "", "canBeReinstalled", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "copyNativeBundleDistribution", "", "fromDirectory", "Ljava/io/File;", "toDirectory", "copyNativeBundleDistribution$kotlin_gradle_plugin_common", "createSuccessfulInstallationFile", "bundleDir", "isSnapshotVersion", "kotlinNativeVersion", "isSnapshotVersion$kotlin_gradle_plugin_common", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nNativeVersionValueSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeVersionValueSource.kt\norg/jetbrains/kotlin/gradle/targets/native/toolchain/NativeVersionValueSource$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,154:1\n1291#2,2:155\n*S KotlinDebug\n*F\n+ 1 NativeVersionValueSource.kt\norg/jetbrains/kotlin/gradle/targets/native/toolchain/NativeVersionValueSource$Companion\n*L\n136#1:155,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public final boolean isSnapshotVersion$kotlin_gradle_plugin_common(@NotNull String kotlinNativeVersion2) {
            Intrinsics.checkNotNullParameter((Object)kotlinNativeVersion2, (String)"kotlinNativeVersion");
            return KotlinToolingVersionKt.KotlinToolingVersion((String)kotlinNativeVersion2).getMaturity() == KotlinToolingVersion.Maturity.SNAPSHOT;
        }

        public final void copyNativeBundleDistribution$kotlin_gradle_plugin_common(@NotNull File fromDirectory, @NotNull File toDirectory) {
            Intrinsics.checkNotNullParameter((Object)fromDirectory, (String)"fromDirectory");
            Intrinsics.checkNotNullParameter((Object)toDirectory, (String)"toDirectory");
            this.getLogger().info("Moving Kotlin/Native bundle from tmp directory " + fromDirectory + " to " + toDirectory.getAbsolutePath());
            String[] stringArray = toDirectory.list();
            if (!(stringArray == null || stringArray.length == 0)) {
                this.getLogger().warn("Kotlin/Native bundle directory " + toDirectory.getAbsolutePath() + " is not empty. Native bundle files will be overwritten.");
            }
            Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)fromDirectory, null, (int)1, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File sourceFile = (File)element$iv;
                boolean bl = false;
                String relativePath = FilesKt.toRelativeString((File)sourceFile, (File)fromDirectory);
                File bundleDirFile = FilesKt.resolve((File)toDirectory, (String)relativePath);
                if (sourceFile.isFile()) {
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    FilesUncheck.copy(sourceFile.toPath(), bundleDirFile.toPath(), copyOptionArray);
                    continue;
                }
                if (!sourceFile.isDirectory()) continue;
                bundleDirFile.mkdir();
            }
            this.createSuccessfulInstallationFile(toDirectory);
            this.getLogger().info("Moved Kotlin/Native bundle from " + fromDirectory + " to " + toDirectory.getAbsolutePath());
        }

        private final void createSuccessfulInstallationFile(File bundleDir) {
            FilesKt.resolve((File)bundleDir, (String)NativeVersionValueSource.MARKER_FILE).createNewFile();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/toolchain/NativeVersionValueSource$Params;", "Lorg/gradle/api/provider/ValueSourceParameters;", "bundleDirectory", "Lorg/gradle/api/provider/Property;", "", "getBundleDirectory", "()Lorg/gradle/api/provider/Property;", "kotlinNativeCompilerConfiguration", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getKotlinNativeCompilerConfiguration", "kotlinNativeVersion", "getKotlinNativeVersion", "reinstallBundle", "", "getReinstallBundle", "simpleKotlinNativeVersion", "getSimpleKotlinNativeVersion", "kotlin-gradle-plugin_common"})
    public static interface Params
    extends ValueSourceParameters {
        @NotNull
        public Property<String> getBundleDirectory();

        @NotNull
        public Property<Boolean> getReinstallBundle();

        @NotNull
        public Property<String> getSimpleKotlinNativeVersion();

        @NotNull
        public Property<String> getKotlinNativeVersion();

        @NotNull
        public Property<ConfigurableFileCollection> getKotlinNativeCompilerConfiguration();
    }
}

