/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.mpp.KmpMultiVariantModuleIdentifier;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinTargetSoftwareComponentImplKt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a6\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\bH\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\fH\u0000*\f\b\u0002\u0010\r\"\u00020\u00012\u00020\u0001\u00a8\u0006\u000e"}, d2={"kotlinVariantNameFromPublishedVariantName", "", "resolvedToVariantName", "sortSourceSetsByDependsOnRelation", "", "sourceSets", "", "sourceSetsDependsOnRelation", "", "kmpMultiVariantModuleIdentifier", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KmpMultiVariantModuleIdentifier;", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "Lorg/gradle/api/artifacts/component/ComponentSelector;", "KotlinSourceSetName", "kotlin-gradle-plugin_common"})
public final class SourceSetVisibilityProviderKt {
    @NotNull
    public static final List<String> sortSourceSetsByDependsOnRelation(@NotNull Set<String> sourceSets, @NotNull Map<String, ? extends Set<String>> sourceSetsDependsOnRelation) {
        Intrinsics.checkNotNullParameter(sourceSets, (String)"sourceSets");
        Intrinsics.checkNotNullParameter(sourceSetsDependsOnRelation, (String)"sourceSetsDependsOnRelation");
        Set visited = new LinkedHashSet();
        List result2 = new ArrayList();
        for (String sourceSet : sourceSets) {
            if (!visited.add(sourceSet)) continue;
            SourceSetVisibilityProviderKt.sortSourceSetsByDependsOnRelation$dfs(sourceSetsDependsOnRelation, visited, sourceSets, result2, sourceSet);
        }
        return CollectionsKt.reversed((Iterable)result2);
    }

    @NotNull
    public static final String kotlinVariantNameFromPublishedVariantName(@NotNull String resolvedToVariantName) {
        Intrinsics.checkNotNullParameter((Object)resolvedToVariantName, (String)"resolvedToVariantName");
        String string = KotlinTargetSoftwareComponentImplKt.originalVariantNameFromPublished(resolvedToVariantName);
        if (string == null) {
            string = resolvedToVariantName;
        }
        return string;
    }

    @NotNull
    public static final KmpMultiVariantModuleIdentifier kmpMultiVariantModuleIdentifier(@NotNull ComponentIdentifier $this$kmpMultiVariantModuleIdentifier) {
        KmpMultiVariantModuleIdentifier kmpMultiVariantModuleIdentifier;
        Intrinsics.checkNotNullParameter((Object)$this$kmpMultiVariantModuleIdentifier, (String)"<this>");
        ComponentIdentifier componentIdentifier = $this$kmpMultiVariantModuleIdentifier;
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            String string = ((ProjectComponentIdentifier)$this$kmpMultiVariantModuleIdentifier).getProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectPath");
            kmpMultiVariantModuleIdentifier = new KmpMultiVariantModuleIdentifier.ProjectIdentifier(string);
        } else if (componentIdentifier instanceof ModuleComponentIdentifier) {
            String string = ((ModuleComponentIdentifier)$this$kmpMultiVariantModuleIdentifier).getModuleIdentifier().getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moduleIdentifier.group");
            String string2 = ((ModuleComponentIdentifier)$this$kmpMultiVariantModuleIdentifier).getModuleIdentifier().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moduleIdentifier.name");
            kmpMultiVariantModuleIdentifier = new KmpMultiVariantModuleIdentifier.ModuleIdentifier(string, string2);
        } else {
            kmpMultiVariantModuleIdentifier = new KmpMultiVariantModuleIdentifier.Unidentifiable($this$kmpMultiVariantModuleIdentifier);
        }
        return kmpMultiVariantModuleIdentifier;
    }

    @NotNull
    public static final KmpMultiVariantModuleIdentifier kmpMultiVariantModuleIdentifier(@NotNull ComponentSelector $this$kmpMultiVariantModuleIdentifier) {
        KmpMultiVariantModuleIdentifier kmpMultiVariantModuleIdentifier;
        Intrinsics.checkNotNullParameter((Object)$this$kmpMultiVariantModuleIdentifier, (String)"<this>");
        ComponentSelector componentSelector = $this$kmpMultiVariantModuleIdentifier;
        if (componentSelector instanceof ProjectComponentSelector) {
            String string = ((ProjectComponentSelector)$this$kmpMultiVariantModuleIdentifier).getProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectPath");
            kmpMultiVariantModuleIdentifier = new KmpMultiVariantModuleIdentifier.ProjectIdentifier(string);
        } else if (componentSelector instanceof ModuleComponentSelector) {
            String string = ((ModuleComponentSelector)$this$kmpMultiVariantModuleIdentifier).getModuleIdentifier().getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moduleIdentifier.group");
            String string2 = ((ModuleComponentSelector)$this$kmpMultiVariantModuleIdentifier).getModuleIdentifier().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moduleIdentifier.name");
            kmpMultiVariantModuleIdentifier = new KmpMultiVariantModuleIdentifier.ModuleIdentifier(string, string2);
        } else {
            kmpMultiVariantModuleIdentifier = new KmpMultiVariantModuleIdentifier.Unidentifiable($this$kmpMultiVariantModuleIdentifier);
        }
        return kmpMultiVariantModuleIdentifier;
    }

    private static final void sortSourceSetsByDependsOnRelation$dfs(Map<String, ? extends Set<String>> $sourceSetsDependsOnRelation, Set<String> visited, Set<String> $sourceSets, List<String> result2, String sourceSet) {
        Set set = $sourceSetsDependsOnRelation.get(sourceSet);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Set children = set;
        for (String child : children) {
            if (!visited.add(child)) continue;
            SourceSetVisibilityProviderKt.sortSourceSetsByDependsOnRelation$dfs($sourceSetsDependsOnRelation, visited, $sourceSets, result2, child);
        }
        if ($sourceSets.contains(sourceSet)) {
            result2.add(sourceSet);
        }
    }
}

