/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.internal;

import java.io.File;
import java.nio.file.Files;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.targets.js.internal.UtilsKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0000\u001a\f\u0010\n\u001a\u00020\u0007*\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"appendConfigsFromDir", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "confDir", "Ljava/io/File;", "calculateDirHash", "", "Lorg/gradle/internal/hash/FileHasher;", "dir", "toHex", "", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/gradle/targets/js/internal/UtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,62:1\n603#2:63\n1291#2,2:64\n1291#2,2:68\n13550#3,2:66\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/gradle/targets/js/internal/UtilsKt\n*L\n20#1:63\n21#1:64,2\n47#1:68,2\n32#1:66,2\n*E\n"})
public final class UtilsKt {
    public static final void appendConfigsFromDir(@NotNull Appendable $this$appendConfigsFromDir, @NotNull File confDir) {
        Intrinsics.checkNotNullParameter((Object)$this$appendConfigsFromDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)confDir, (String)"confDir");
        Object[] objectArray = confDir.listFiles();
        if (objectArray == null) {
            return;
        }
        Object[] files2 = objectArray;
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])files2), (Function1)appendConfigsFromDir.1.INSTANCE), (Function1)appendConfigsFromDir.2.INSTANCE);
        boolean $i$f$sortedBy = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            StringUtilsKt.appendLine($this$appendConfigsFromDir, "// " + it.getName());
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            $this$appendConfigsFromDir.append(FilesKt.readText$default((File)it, null, (int)1, null));
            StringUtilsKt.appendLine($this$appendConfigsFromDir);
            StringUtilsKt.appendLine($this$appendConfigsFromDir);
        }
    }

    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$toHex, (String)"<this>");
        int n2 = 0;
        int n3 = $this$toHex.length * 2;
        char[] cArray = new char[n3];
        while (n2 < n3) {
            n = n2++;
            cArray[n] = 32;
        }
        char[] result2 = cArray;
        int i2 = 0;
        byte[] $this$forEach$iv = $this$toHex;
        boolean $i$f$forEach = false;
        int n4 = $this$forEach$iv.length;
        for (n = 0; n < n4; ++n) {
            byte element$iv;
            byte it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            byte n5 = it;
            int n6 = i2;
            i2 = n6 + 1;
            result2[n6] = Character.forDigit(n5 >> 4 & 0xF, 16);
            n6 = i2;
            i2 = n6 + 1;
            result2[n6] = Character.forDigit(n5 & 0xF, 16);
        }
        return new String(result2);
    }

    @Nullable
    public static final String calculateDirHash(@NotNull FileHasher $this$calculateDirHash, @NotNull File dir2) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateDirHash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        if (!dir2.isDirectory()) {
            return null;
        }
        Hasher hasher = Hashing.defaultFunction().newHasher();
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)dir2, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file2 = (File)element$iv;
            boolean bl = false;
            hasher.putString((CharSequence)FilesKt.toRelativeString((File)file2, (File)dir2));
            if (!file2.isFile()) continue;
            if (!Files.isSymbolicLink(file2.toPath())) {
                hasher.putHash($this$calculateDirHash.hash(file2));
                continue;
            }
            File absoluteFile = file2.getAbsoluteFile();
            hasher.putHash($this$calculateDirHash.hash(absoluteFile));
            Intrinsics.checkNotNullExpressionValue((Object)absoluteFile, (String)"absoluteFile");
            hasher.putString((CharSequence)FilesKt.toRelativeString((File)absoluteFile, (File)dir2));
        }
        byte[] byArray = hasher.hash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"hasher.hash().toByteArray()");
        return UtilsKt.toHex(byArray);
    }
}

